/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api.util;

import java.math.BigDecimal;

public class GoTimeUtil {
    private static final String[] TIME_UNITS = new String[]{"ns", "us", "\u00b5s", "ms", "s", "m", "h"};
    private static final long[] UNIT_MULTIPLIERS = new long[]{1L, 1000L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L};

    private GoTimeUtil() {
    }

    public static Integer durationSeconds(String duration) {
        BigDecimal ns = GoTimeUtil.durationNs(duration);
        if (ns == null) {
            return null;
        }
        BigDecimal sec = ns.divide(new BigDecimal(1000000000));
        if (sec.compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
            throw new IllegalArgumentException("Integer Overflow");
        }
        return sec.intValue();
    }

    public static BigDecimal durationNs(String durationP) {
        int unitPos;
        if (durationP == null) {
            return null;
        }
        String duration = durationP.trim();
        if (duration.length() == 0) {
            return null;
        }
        for (unitPos = 1; unitPos < duration.length() && (Character.isDigit(duration.charAt(unitPos)) || duration.charAt(unitPos) == '.'); ++unitPos) {
        }
        if (unitPos >= duration.length()) {
            throw new IllegalArgumentException("Time unit not found in string: " + duration);
        }
        String tail = duration.substring(unitPos);
        Long multiplier = null;
        Integer unitEnd = null;
        for (int i = 0; i < TIME_UNITS.length; ++i) {
            if (!tail.startsWith(TIME_UNITS[i])) continue;
            multiplier = UNIT_MULTIPLIERS[i];
            unitEnd = unitPos + TIME_UNITS[i].length();
            break;
        }
        if (multiplier == null) {
            throw new IllegalArgumentException("Unknown time unit in string: " + duration);
        }
        BigDecimal value = new BigDecimal(duration.substring(0, unitPos));
        value = value.multiply(BigDecimal.valueOf(multiplier));
        String remaining = duration.substring(unitEnd);
        BigDecimal remainingValue = GoTimeUtil.durationNs(remaining);
        if (remainingValue != null) {
            value = value.add(remainingValue);
        }
        return value;
    }
}

