/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api.util;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.jshift.kit.common.KitLogger;
import java.util.List;

public class InitContainerHandler {
    public static final String INIT_CONTAINER_ANNOTATION = "pod.alpha.kubernetes.io/init-containers";
    KitLogger log;

    public InitContainerHandler(KitLogger log) {
        this.log = log;
    }

    public boolean hasInitContainer(PodTemplateSpecBuilder builder, String name) {
        return this.getInitContainer(builder, name) != null;
    }

    public Container getInitContainer(PodTemplateSpecBuilder builder, String name) {
        if (builder.hasSpec().booleanValue()) {
            List initContainerList = builder.buildSpec().getInitContainers();
            for (Container initContainer : initContainerList) {
                if (!initContainer.getName().equals(name)) continue;
                return initContainer;
            }
        }
        return null;
    }

    public void removeInitContainer(PodTemplateSpecBuilder builder, String initContainerName) {
        Container initContainer = this.getInitContainer(builder, initContainerName);
        if (initContainer != null) {
            List initContainers = builder.buildSpec().getInitContainers();
            initContainers.remove(initContainer);
            ((PodTemplateSpecFluent.SpecNested)builder.editSpec().withInitContainers(initContainers)).endSpec();
        }
    }

    public void appendInitContainer(PodTemplateSpecBuilder builder, Container initContainer) {
        String name = initContainer.getName();
        Container existing = this.getInitContainer(builder, name);
        if (existing != null) {
            if (existing.equals((Object)initContainer)) {
                this.log.warn("Trying to add init-container %s a second time. Ignoring ....", new Object[]{name});
                return;
            }
            throw new IllegalArgumentException(String.format("PodSpec %s already contains a different init container with name %s but can not add a second one with the same name. Please choose a different name for the init container", builder.build().getMetadata().getName(), name));
        }
        this.ensureSpec(builder);
        ((PodTemplateSpecFluent.SpecNested)builder.editSpec().addToInitContainers(new Container[]{initContainer})).endSpec();
    }

    private void ensureSpec(PodTemplateSpecBuilder obj) {
        if (obj.buildSpec() == null) {
            obj.withNewSpec().endSpec();
        }
    }
}

