/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api.visitor;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.jshift.kit.config.resource.MetaDataConfig;
import io.jshift.kit.config.resource.ProcessorConfig;
import io.jshift.kit.config.resource.ResourceConfig;
import io.jshift.maven.enricher.api.Enricher;
import io.jshift.maven.enricher.api.Kind;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class MetadataVisitor<T>
extends TypedVisitor<T> {
    private static ThreadLocal<ProcessorConfig> configHolder = new ThreadLocal();
    private final Map<String, String> labelsFromConfig;
    private final Map<String, String> annotationFromConfig;
    private List<Enricher> enrichers = null;

    private MetadataVisitor(ResourceConfig resourceConfig) {
        if (resourceConfig != null) {
            this.labelsFromConfig = this.getMapFromConfiguration(resourceConfig.getLabels(), this.getKind());
            this.annotationFromConfig = this.getMapFromConfiguration(resourceConfig.getAnnotations(), this.getKind());
        } else {
            this.labelsFromConfig = new HashMap<String, String>();
            this.annotationFromConfig = new HashMap<String, String>();
        }
        this.enrichers = this.enrichers;
    }

    public static void setProcessorConfig(ProcessorConfig config) {
        configHolder.set(config);
    }

    public static void clearProcessorConfig() {
        configHolder.set(null);
    }

    private ProcessorConfig getProcessorConfig() {
        ProcessorConfig config = configHolder.get();
        if (config == null) {
            throw new IllegalArgumentException("No ProcessorConfig set");
        }
        return config;
    }

    public void visit(T item) {
        ProcessorConfig config = this.getProcessorConfig();
        ObjectMeta metadata = this.getOrCreateMetadata(item);
        this.updateLabels(metadata);
        this.updateAnnotations(metadata);
    }

    private void updateLabels(ObjectMeta metadata) {
        this.overlayMap(metadata.getLabels(), this.labelsFromConfig);
    }

    private void updateAnnotations(ObjectMeta metadata) {
        this.overlayMap(metadata.getAnnotations(), this.annotationFromConfig);
    }

    private Map<String, String> getMapFromConfiguration(MetaDataConfig config, Kind kind) {
        if (config == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> ret = kind == Kind.SERVICE ? this.propertiesToMap(config.getService()) : (kind == Kind.DEPLOYMENT || kind == Kind.DEPLOYMENT_CONFIG ? this.propertiesToMap(config.getDeployment()) : (kind == Kind.REPLICATION_CONTROLLER || kind == Kind.REPLICA_SET ? this.propertiesToMap(config.getReplicaSet()) : (kind == Kind.POD_SPEC ? this.propertiesToMap(config.getPod()) : (kind == Kind.INGRESS ? this.propertiesToMap(config.getIngress()) : new HashMap<String, String>()))));
        if (config.getAll() != null) {
            ret.putAll(this.propertiesToMap(config.getAll()));
        }
        return ret;
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                propertyMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return propertyMap;
    }

    private void overlayMap(Map<String, String> targetMap, Map<String, String> enrichMap) {
        targetMap = this.ensureMap(targetMap);
        enrichMap = this.ensureMap(enrichMap);
        for (Map.Entry<String, String> entry : enrichMap.entrySet()) {
            if (targetMap.containsKey(entry.getKey())) continue;
            targetMap.put(entry.getKey(), entry.getValue());
        }
    }

    protected abstract Kind getKind();

    protected abstract ObjectMeta getOrCreateMetadata(T var1);

    private Map<String, String> ensureMap(Map<String, String> labels) {
        return labels != null ? labels : new HashMap();
    }

    public static class IngressBuilderVisitor
    extends MetadataVisitor<IngressBuilder> {
        public IngressBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.BUILD;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(IngressBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((IngressBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class BuildBuilderVisitor
    extends MetadataVisitor<BuildBuilder> {
        public BuildBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.BUILD;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(BuildBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((BuildBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class BuildConfigBuilderVisitor
    extends MetadataVisitor<BuildConfigBuilder> {
        public BuildConfigBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.BUILD_CONFIG;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(BuildConfigBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((BuildConfigBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class ImageStreamBuilderVisitor
    extends MetadataVisitor<ImageStreamBuilder> {
        public ImageStreamBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.IMAGESTREAM;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ImageStreamBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((ImageStreamBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class JobBuilderVisitor
    extends MetadataVisitor<JobBuilder> {
        public JobBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.JOB;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(JobBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((JobBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class StatefulSetBuilderVisitor
    extends MetadataVisitor<StatefulSetBuilder> {
        public StatefulSetBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.STATEFUL_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(StatefulSetBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((StatefulSetBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class DaemonSetBuilderVisitor
    extends MetadataVisitor<DaemonSetBuilder> {
        public DaemonSetBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DAEMON_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DaemonSetBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((DaemonSetBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class DeploymentConfigBuilderVisitor
    extends MetadataVisitor<DeploymentConfigBuilder> {
        public DeploymentConfigBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentConfigBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((DeploymentConfigBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class DeploymentBuilderVisitor
    extends MetadataVisitor<DeploymentBuilder> {
        public DeploymentBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.DEPLOYMENT;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(DeploymentBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((DeploymentBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class ReplicationControllerBuilderVisitor
    extends MetadataVisitor<ReplicationControllerBuilder> {
        public ReplicationControllerBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICATION_CONTROLLER;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicationControllerBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((ReplicationControllerBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class ReplicaSet
    extends MetadataVisitor<ReplicaSetBuilder> {
        public ReplicaSet(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.REPLICA_SET;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ReplicaSetBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((ReplicaSetBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class ServiceBuilderVisitor
    extends MetadataVisitor<ServiceBuilder> {
        public ServiceBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.SERVICE;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(ServiceBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((ServiceBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }

    public static class PodTemplateSpecBuilderVisitor
    extends MetadataVisitor<PodTemplateSpecBuilder> {
        public PodTemplateSpecBuilderVisitor(ResourceConfig resourceConfig) {
            super(resourceConfig);
        }

        @Override
        protected Kind getKind() {
            return Kind.POD_SPEC;
        }

        @Override
        protected ObjectMeta getOrCreateMetadata(PodTemplateSpecBuilder item) {
            return item.hasMetadata() != false ? item.buildMetadata() : ((PodTemplateSpecBuilder)item.withNewMetadata().endMetadata()).buildMetadata();
        }
    }
}

