/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.handler;

import io.jshift.kit.config.resource.GroupArtifactVersion;
import io.jshift.maven.enricher.handler.ContainerHandler;
import io.jshift.maven.enricher.handler.DaemonSetHandler;
import io.jshift.maven.enricher.handler.DeploymentConfigHandler;
import io.jshift.maven.enricher.handler.DeploymentHandler;
import io.jshift.maven.enricher.handler.JobHandler;
import io.jshift.maven.enricher.handler.NamespaceHandler;
import io.jshift.maven.enricher.handler.PodTemplateHandler;
import io.jshift.maven.enricher.handler.ProbeHandler;
import io.jshift.maven.enricher.handler.ProjectHandler;
import io.jshift.maven.enricher.handler.ReplicaSetHandler;
import io.jshift.maven.enricher.handler.ReplicationControllerHandler;
import io.jshift.maven.enricher.handler.ServiceHandler;
import io.jshift.maven.enricher.handler.StatefulSetHandler;
import java.util.Properties;

public class HandlerHub {
    private final PodTemplateHandler podTemplateHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        this.podTemplateHandler = new PodTemplateHandler(containerHandler);
    }

    public ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public DeploymentHandler getDeploymentHandler() {
        return new DeploymentHandler(this.podTemplateHandler);
    }

    public DeploymentConfigHandler getDeploymentConfigHandler() {
        return new DeploymentConfigHandler(this.podTemplateHandler);
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return new ReplicaSetHandler(this.podTemplateHandler);
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return new ReplicationControllerHandler(this.podTemplateHandler);
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return new StatefulSetHandler(this.podTemplateHandler);
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return new DaemonSetHandler(this.podTemplateHandler);
    }

    public JobHandler getJobHandler() {
        return new JobHandler(this.podTemplateHandler);
    }

    public ProjectHandler getProjectHandler() {
        return new ProjectHandler();
    }

    public NamespaceHandler getNamespaceHandler() {
        return new NamespaceHandler();
    }
}

