/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.api.model.batch.JobSpecBuilder;
import io.jshift.kit.build.service.docker.ImageConfiguration;
import io.jshift.kit.common.util.KubernetesHelper;
import io.jshift.kit.config.resource.ResourceConfig;
import io.jshift.maven.enricher.handler.PodTemplateHandler;
import java.util.List;

public class JobHandler {
    private final PodTemplateHandler podTemplateHandler;

    JobHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public Job getJob(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobBuilder)((JobBuilder)new JobBuilder().withMetadata(this.createJobSpecMetaData(config))).withSpec(this.createJobSpec(config, images))).build();
    }

    private ObjectMeta createJobSpecMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private JobSpec createJobSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((JobSpecBuilder)new JobSpecBuilder().withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

