/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.jshift.kit.build.service.docker.ImageConfiguration;
import io.jshift.kit.config.resource.ResourceConfig;
import io.jshift.kit.config.resource.VolumeConfig;
import io.jshift.kit.config.resource.VolumeType;
import io.jshift.maven.enricher.handler.ContainerHandler;
import java.util.ArrayList;
import java.util.List;

public class PodTemplateHandler {
    private final ContainerHandler containerHandler;

    public PodTemplateHandler(ContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
    }

    public PodTemplateSpec getPodTemplate(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(this.createPodMetaData(config))).withSpec(this.createPodSpec(config, images))).build();
    }

    private ObjectMeta createPodMetaData(ResourceConfig config) {
        return new ObjectMetaBuilder().build();
    }

    private PodSpec createPodSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withServiceAccountName(config.getServiceAccount())).withContainers(this.containerHandler.getContainers(config, images))).withVolumes(this.getVolumes(config))).build();
    }

    private List<Volume> getVolumes(ResourceConfig config) {
        List volumeConfigs = config.getVolumes();
        ArrayList<Volume> ret = new ArrayList<Volume>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                VolumeType type = VolumeType.typeFor((String)volumeConfig.getType());
                if (type == null) continue;
                ret.add(type.fromConfig(volumeConfig));
            }
        }
        return ret;
    }
}

