/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecBuilder;
import io.jshift.kit.build.service.docker.ImageConfiguration;
import io.jshift.kit.common.util.KubernetesHelper;
import io.jshift.kit.config.resource.ResourceConfig;
import io.jshift.maven.enricher.handler.PodTemplateHandler;
import java.util.List;

public class ReplicaSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    ReplicaSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public ReplicaSet getReplicaSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetBuilder)((ReplicaSetBuilder)new ReplicaSetBuilder().withMetadata(this.createRsMetaData(config))).withSpec(this.createRsSpec(config, images))).build();
    }

    private ObjectMeta createRsMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private ReplicaSetSpec createRsSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetSpecBuilder)((ReplicaSetSpecBuilder)new ReplicaSetSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

