/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb.crypto;

import io.jsondb.CollectionMetaData;
import io.jsondb.crypto.ICipher;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static Logger logger = LoggerFactory.getLogger(CryptoUtil.class);

    public static void encryptFields(Object object, CollectionMetaData cmd, ICipher cipher) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (String secretAnnotatedFieldName : cmd.getSecretAnnotatedFieldNames()) {
            Method getterMethod = cmd.getGetterMethodForFieldName(secretAnnotatedFieldName);
            Method setterMethod = cmd.getSetterMethodForFieldName(secretAnnotatedFieldName);
            String encryptedValue = null;
            try {
                String value = (String)getterMethod.invoke(object, new Object[0]);
                if (null == value) continue;
                encryptedValue = cipher.encrypt(value);
                setterMethod.invoke(object, encryptedValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("Error when invoking method for a @Secret annotated field", (Throwable)e);
                throw e;
            }
        }
    }

    public static void decryptFields(Object object, CollectionMetaData cmd, ICipher cipher) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (String secretAnnotatedFieldName : cmd.getSecretAnnotatedFieldNames()) {
            Method getterMethod = cmd.getGetterMethodForFieldName(secretAnnotatedFieldName);
            Method setterMethod = cmd.getSetterMethodForFieldName(secretAnnotatedFieldName);
            String decryptedValue = null;
            try {
                String value = (String)getterMethod.invoke(object, new Object[0]);
                if (null == value) continue;
                decryptedValue = cipher.decrypt(value);
                setterMethod.invoke(object, decryptedValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("Error when invoking method for a @Secret annotated field", (Throwable)e);
                throw e;
            }
        }
    }

    public static String generate128BitKey(String password, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 128);
        SecretKey key = factory.generateSecret(spec);
        byte[] keybyte = key.getEncoded();
        return Base64.getEncoder().encodeToString(keybyte);
    }
}

