/*
 * Decompiled with CFR 0.152.
 */
package io.jsondb.query.ddl;

import io.jsondb.query.ddl.AddOperation;
import io.jsondb.query.ddl.DeleteOperation;
import io.jsondb.query.ddl.IOperation;
import io.jsondb.query.ddl.RenameOperation;
import java.util.Map;
import java.util.TreeMap;

public class CollectionSchemaUpdate {
    private Map<String, IOperation> collectionUpdateData = new TreeMap<String, IOperation>();

    public static CollectionSchemaUpdate update(String key, IOperation operation) {
        return new CollectionSchemaUpdate().set(key, operation);
    }

    public CollectionSchemaUpdate set(String key, IOperation operation) {
        this.collectionUpdateData.put(key, operation);
        return this;
    }

    public Map<String, IOperation> getUpdateData() {
        return this.collectionUpdateData;
    }

    public Map<String, AddOperation> getAddOperations() {
        TreeMap<String, AddOperation> addOperations = new TreeMap<String, AddOperation>();
        for (Map.Entry<String, IOperation> entry : this.collectionUpdateData.entrySet()) {
            AddOperation aop;
            String key = entry.getKey();
            IOperation op = entry.getValue();
            if (!op.getOperationType().equals((Object)Type.ADD) || null == (aop = (AddOperation)op).getDefaultValue()) continue;
            addOperations.put(key, aop);
        }
        return addOperations;
    }

    public Map<String, RenameOperation> getRenameOperations() {
        TreeMap<String, RenameOperation> renOperations = new TreeMap<String, RenameOperation>();
        for (Map.Entry<String, IOperation> entry : this.collectionUpdateData.entrySet()) {
            String key = entry.getKey();
            IOperation op = entry.getValue();
            if (!op.getOperationType().equals((Object)Type.RENAME)) continue;
            renOperations.put(key, (RenameOperation)op);
        }
        return renOperations;
    }

    public Map<String, DeleteOperation> getDeleteOperations() {
        TreeMap<String, DeleteOperation> delOperations = new TreeMap<String, DeleteOperation>();
        for (Map.Entry<String, IOperation> entry : this.collectionUpdateData.entrySet()) {
            String key = entry.getKey();
            IOperation op = entry.getValue();
            if (!op.getOperationType().equals((Object)Type.DELETE)) continue;
            delOperations.put(key, (DeleteOperation)op);
        }
        return delOperations;
    }

    public static enum Type {
        ADD,
        RENAME,
        DELETE;

    }
}

