/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.orgjson.io;

import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.DateFormats;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.lang.Supplier;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrgJsonSerializer<T>
extends AbstractSerializer<T> {
    private static final String JSON_WRITER_CLASS_NAME = "org.json.JSONWriter";
    private static final Class<?>[] VALUE_TO_STRING_ARG_TYPES = new Class[]{Object.class};
    private static final String JSON_STRING_CLASS_NAME = "org.json.JSONString";
    private static final Class<?> JSON_STRING_CLASS = Classes.isAvailable((String)"org.json.JSONString") ? Classes.forName((String)"org.json.JSONString") : null;

    protected void doSerialize(T t, OutputStream out) throws Exception {
        Object o = this.toJSONInstance(t);
        String s = this.toString(o);
        byte[] bytes = Strings.utf8((CharSequence)s);
        out.write(bytes);
    }

    private static boolean isJSONString(Object o) {
        if (JSON_STRING_CLASS != null) {
            return JSON_STRING_CLASS.isInstance(o);
        }
        return false;
    }

    private Object toJSONInstance(Object object) throws IOException {
        if (object == null) {
            return JSONObject.NULL;
        }
        if (object instanceof Supplier) {
            object = ((Supplier)object).get();
        }
        if (object instanceof JSONObject || object instanceof JSONArray || JSONObject.NULL.equals(object) || OrgJsonSerializer.isJSONString(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal || object instanceof Enum) {
            return object;
        }
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return DateFormats.formatIso8601((Date)date);
        }
        if (object instanceof byte[]) {
            return Encoders.BASE64.encode((Object)((byte[])object));
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.toJSONObject(map);
        }
        if (Objects.isArray((Object)object)) {
            object = Collections.arrayToList((Object)object);
        }
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            return this.toJSONArray(coll);
        }
        String msg = "Unable to serialize object of type " + object.getClass().getName() + " to JSON using known heuristics.";
        throw new IOException(msg);
    }

    private JSONObject toJSONObject(Map<?, ?> m) throws IOException {
        JSONObject obj = new JSONObject();
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object k = entry.getKey();
            Object value = entry.getValue();
            String key = String.valueOf(k);
            value = this.toJSONInstance(value);
            obj.put(key, value);
        }
        return obj;
    }

    private JSONArray toJSONArray(Collection<?> c) throws IOException {
        JSONArray array = new JSONArray();
        for (Object o : c) {
            o = this.toJSONInstance(o);
            array.put(o);
        }
        return array;
    }

    protected String toString(Object o) {
        if (o instanceof JSONObject) {
            return o.toString();
        }
        return (String)Classes.invokeStatic((String)JSON_WRITER_CLASS_NAME, (String)"valueToString", (Class[])VALUE_TO_STRING_ARG_TYPES, (Object[])new Object[]{o});
    }

    @Deprecated
    protected byte[] toBytes(Object o) {
        String s = this.toString(o);
        return Strings.utf8((CharSequence)s);
    }
}

