/*
 * Decompiled with CFR 0.152.
 */
package io.kaizensolutions.virgil.internal;

import cats.effect.kernel.Async;
import cats.syntax.package;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PagingState;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Collector$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Stream;
import fs2.Stream$;
import io.kaizensolutions.virgil.BatchType;
import io.kaizensolutions.virgil.CQL;
import io.kaizensolutions.virgil.CQLExecutor;
import io.kaizensolutions.virgil.CQLType;
import io.kaizensolutions.virgil.MutationResult;
import io.kaizensolutions.virgil.MutationResult$;
import io.kaizensolutions.virgil.Paged$;
import io.kaizensolutions.virgil.codecs.CqlRowDecoder;
import io.kaizensolutions.virgil.configuration.ExecutionAttributes;
import io.kaizensolutions.virgil.configuration.ExecutionAttributes$;
import io.kaizensolutions.virgil.configuration.PageState;
import io.kaizensolutions.virgil.configuration.PageState$;
import io.kaizensolutions.virgil.internal.BindMarker;
import io.kaizensolutions.virgil.internal.BindMarkerName;
import io.kaizensolutions.virgil.internal.BindMarkers;
import io.kaizensolutions.virgil.internal.CqlStatementRenderer$;
import io.kaizensolutions.virgil.internal.Proofs$;
import io.kaizensolutions.virgil.internal.PullMode;
import io.kaizensolutions.virgil.internal.QueryType;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.util.NotGiven$;

public class CQLExecutorImpl<F>
implements CQLExecutor<F> {
    private final CqlSession underlyingSession;
    private final Async<F> F;

    public CQLExecutorImpl(CqlSession underlyingSession, Async<F> F) {
        this.underlyingSession = underlyingSession;
        this.F = F;
    }

    @Override
    public <A> Stream<F, A> execute(CQL<A> in) {
        CQLType cQLType = in.cqlType();
        if (cQLType instanceof CQLType.Mutation) {
            CQLType.Mutation m = (CQLType.Mutation)cQLType;
            return Stream$.MODULE$.eval(this.executeMutation(m, in.executionAttributes()));
        }
        if (cQLType instanceof CQLType.Batch) {
            CQLType.Batch b = (CQLType.Batch)cQLType;
            return Stream$.MODULE$.eval(this.executeBatch(b, in.executionAttributes()));
        }
        if (cQLType instanceof CQLType.Query) {
            PullMode pullMode;
            CQLType.Query query = (CQLType.Query)cQLType;
            CQLType.Query query2 = CQLType.Query$.MODULE$.unapply(query);
            QueryType queryType = query2._1();
            CqlRowDecoder.Object object = query2._2();
            PullMode pullMode2 = pullMode = query2._3();
            CQLType.Query q = query;
            PullMode pullMode3 = pullMode2;
            if (pullMode3 instanceof PullMode.TakeUpto) {
                long l;
                PullMode.TakeUpto takeUpto = PullMode.TakeUpto$.MODULE$.unapply((PullMode.TakeUpto)pullMode3);
                long n = l = takeUpto._1();
                return this.executeGeneralQuery(q, in.executionAttributes()).take(n);
            }
            if (PullMode.All$.MODULE$.equals(pullMode3)) {
                return this.executeGeneralQuery(q, in.executionAttributes());
            }
            throw new MatchError((Object)pullMode3);
        }
        throw new MatchError((Object)cQLType);
    }

    @Override
    public F executeMutation(CQL<MutationResult> in) {
        CQLType cQLType = in.cqlType();
        if (cQLType instanceof CQLType.Mutation) {
            CQLType.Mutation mutation = (CQLType.Mutation)cQLType;
            return this.executeMutation(mutation, in.executionAttributes());
        }
        if (cQLType instanceof CQLType.Batch) {
            CQLType.Batch batch = (CQLType.Batch)cQLType;
            return this.executeBatch(batch, in.executionAttributes());
        }
        if (cQLType instanceof CQLType.Query) {
            CQLType.Query query = CQLType.Query$.MODULE$.unapply((CQLType.Query)cQLType);
            QueryType queryType = query._1();
            CqlRowDecoder.Object object = query._2();
            PullMode pullMode = query._3();
            throw scala.sys.package$.MODULE$.error("Cannot perform a query using executeMutation");
        }
        throw new MatchError((Object)cQLType);
    }

    @Override
    public <A> F executePage(CQL<A> in, Option<PageState> pageState, Proofs$.eq.colon.bang.eq<A, MutationResult> ev) {
        CQLType cQLType = in.cqlType();
        if (cQLType instanceof CQLType.Mutation) {
            throw scala.sys.package$.MODULE$.error("Mutations cannot be used with page queries");
        }
        if (cQLType instanceof CQLType.Batch) {
            CQLType.Batch batch = CQLType.Batch$.MODULE$.unapply((CQLType.Batch)cQLType);
            IndexedSeq indexedSeq = batch._1();
            BatchType batchType = batch._2();
            throw scala.sys.package$.MODULE$.error("Batch Mutations cannot be used with page queries");
        }
        if (cQLType instanceof CQLType.Query) {
            CQLType.Query query = CQLType.Query$.MODULE$.unapply((CQLType.Query)cQLType);
            QueryType queryType = query._1();
            CqlRowDecoder.Object object = query._2();
            PullMode pullMode = query._3();
            CQLType.Query q = (CQLType.Query)cQLType;
            return this.fetchSinglePage(q, pageState, in.executionAttributes());
        }
        throw new MatchError((Object)cQLType);
    }

    @Override
    public F metrics() {
        return (F)this.F.delay(this::metrics$$anonfun$1);
    }

    private F executeMutation(CQLType.Mutation m, ExecutionAttributes config) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.buildMutation(m, config), this.F).flatMap((Function1 & Serializable)boundStatement -> package.all$.MODULE$.toFunctorOps(this.executeAction((Statement<?>)boundStatement), this.F).map((Function1 & Serializable)result -> new MutationResult(MutationResult$.MODULE$.make(result.wasApplied()))));
    }

    private F executeBatch(CQLType.Batch m, ExecutionAttributes config) {
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(Chunk$.MODULE$.from((Iterable)m.mutations()).traverse((Function1 & Serializable)_$2 -> this.buildMutation((CQLType.Mutation)_$2, this.buildMutation$default$2()), this.F), this.F).flatMap((Function1 & Serializable)statements -> this.F.delay(() -> CQLExecutorImpl.executeBatch$$anonfun$2$$anonfun$1(m, statements, config))), this.F).flatMap((Function1 & Serializable)query -> this.executeAction((Statement<?>)query)), this.F).map((Function1 & Serializable)r -> new MutationResult(MutationResult$.MODULE$.make(r.wasApplied())));
    }

    private F buildMutation(CQLType.Mutation in, ExecutionAttributes attr) {
        Tuple2 tuple2 = CqlStatementRenderer$.MODULE$.render(in);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String queryString = (String)tuple2._1();
        BindMarkers bindMarkers = (BindMarkers)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)queryString, (Object)bindMarkers);
        String queryString2 = (String)tuple22._1();
        BindMarkers bindMarkers2 = (BindMarkers)tuple22._2();
        if (bindMarkers2.isEmpty()) {
            return (F)this.F.pure((Object)SimpleStatement.newInstance((String)queryString2));
        }
        return this.buildStatement(queryString2, bindMarkers2, attr);
    }

    private ExecutionAttributes buildMutation$default$2() {
        return ExecutionAttributes$.MODULE$.default();
    }

    private <Output> Stream<?, Output> executeGeneralQuery(CQLType.Query<Output> input, ExecutionAttributes config) {
        Tuple2 tuple2 = CqlStatementRenderer$.MODULE$.render(input);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String queryString = (String)tuple2._1();
        BindMarkers bindMarkers = (BindMarkers)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)queryString, (Object)bindMarkers);
        String queryString2 = (String)tuple22._1();
        BindMarkers bindMarkers2 = (BindMarkers)tuple22._2();
        return Stream$.MODULE$.eval(this.buildStatement(queryString2, bindMarkers2, config)).map((Function1 & Serializable)boundStatement -> {
            CqlRowDecoder.Object reader = input.reader();
            return Tuple2$.MODULE$.apply(boundStatement, (Object)reader);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BoundStatement boundStatement = (BoundStatement)tuple2._1();
                CqlRowDecoder.Object reader = (CqlRowDecoder.Object)tuple2._2();
                return this.select((Statement<?>)boundStatement).mapChunks((Function1 & Serializable)chunk -> chunk.map((Function1 & Serializable)row -> reader.decode(row))).map((Function1 & Serializable)element -> element);
            }
            throw new MatchError((Object)tuple2);
        }, NotGiven$.MODULE$.value());
    }

    private Stream<F, Row> select(Statement<?> query) {
        Pull pull = Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.eval(this.F.fromCompletionStage(this.F.delay(() -> this.select$$anonfun$1(query)))).flatMap((Function1 & Serializable)in -> this.go$1((AsyncResultSet)in)));
        return Pull.StreamPullOps$.MODULE$.stream$extension(pull);
    }

    private <A> F fetchSinglePage(CQLType.Query<A> q, Option<PageState> pageState, ExecutionAttributes attr) {
        Tuple2 tuple2 = CqlStatementRenderer$.MODULE$.render(q);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String queryString = (String)tuple2._1();
        BindMarkers bindMarkers = (BindMarkers)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)queryString, (Object)bindMarkers);
        String queryString2 = (String)tuple22._1();
        BindMarkers bindMarkers2 = (BindMarkers)tuple22._2();
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.buildStatement(queryString2, bindMarkers2, attr), this.F).map((Function1 & Serializable)boundStatement -> {
            CqlRowDecoder.Object reader = q.reader();
            PagingState driverPageState = (PagingState)pageState.map((Function1 & Serializable)_$3 -> _$3.underlying()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            BoundStatement boundStatementWithPage = (BoundStatement)boundStatement.setPagingState(driverPageState);
            return Tuple4$.MODULE$.apply(boundStatement, (Object)reader, (Object)driverPageState, (Object)boundStatementWithPage);
        }), this.F).flatMap((Function1 & Serializable)x$12 -> {
            Tuple4 tuple4 = x$12;
            if (tuple4 != null) {
                BoundStatement boundStatement = (BoundStatement)tuple4._1();
                CqlRowDecoder.Object reader = (CqlRowDecoder.Object)tuple4._2();
                PagingState driverPageState = (PagingState)tuple4._3();
                BoundStatement boundStatementWithPage = (BoundStatement)tuple4._4();
                return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.selectPage((Statement<?>)boundStatementWithPage), this.F).map((Function1 & Serializable)rp -> {
                    Tuple2 tuple2 = rp;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Chunk results = (Chunk)tuple2._1();
                    Option nextPage = (Option)tuple2._2();
                    Tuple2 $4$ = tuple2;
                    Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$4$, (Object)results, (Object)nextPage);
                    Tuple2 $4$2 = (Tuple2)tuple3._1();
                    Chunk results2 = (Chunk)tuple3._2();
                    Option nextPage2 = (Option)tuple3._3();
                    return Tuple2$.MODULE$.apply(rp, (Object)$4$2);
                }), this.F).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Tuple2 rp = (Tuple2)tuple2._1();
                        if (tuple22 != null) {
                            Chunk results = (Chunk)tuple22._1();
                            Option nextPage = (Option)tuple22._2();
                            return Paged$.MODULE$.apply(results.map((Function1 & Serializable)row -> reader.decode(row)), (Option<PageState>)nextPage);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple4);
        });
    }

    private F buildStatement(String queryString, BindMarkers columns, ExecutionAttributes config) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.prepare(queryString), this.F).flatMap((Function1 & Serializable)preparedStatement -> this.F.delay(() -> CQLExecutorImpl.buildStatement$$anonfun$1$$anonfun$1(preparedStatement, columns, config)));
    }

    private F selectPage(Statement<?> queryConfiguredWithPageState) {
        return (F)package.all$.MODULE$.toFunctorOps(this.executeAction(queryConfiguredWithPageState), this.F).map((Function1 & Serializable)resultSet -> {
            Chunk rows = Chunk$.MODULE$.from(CollectionConverters$.MODULE$.IterableHasAsScala(resultSet.currentPage()).asScala());
            if (resultSet.hasMorePages()) {
                PageState pageState = PageState$.MODULE$.fromDriver(resultSet.getExecutionInfo().getSafePagingState());
                return Tuple2$.MODULE$.apply((Object)rows, (Object)Option$.MODULE$.apply((Object)pageState));
            }
            return Tuple2$.MODULE$.apply((Object)rows, (Object)None$.MODULE$);
        });
    }

    private F executeAction(Statement<?> query) {
        return (F)this.F.fromCompletionStage(this.F.delay(() -> this.executeAction$$anonfun$1(query)));
    }

    private F prepare(String query) {
        return (F)this.F.fromCompletionStage(this.F.delay(() -> this.prepare$$anonfun$1(query)));
    }

    private final Option metrics$$anonfun$1() {
        Optional underlyingMetrics = this.underlyingSession.getMetrics();
        if (underlyingMetrics.isPresent()) {
            return Some$.MODULE$.apply(underlyingMetrics.get());
        }
        return None$.MODULE$;
    }

    private static final BatchStatement executeBatch$$anonfun$2$$anonfun$1(CQLType.Batch m$2, Chunk statements$1, ExecutionAttributes config$2) {
        BatchStatementBuilder batch = BatchStatement.builder((com.datastax.oss.driver.api.core.cql.BatchType)m$2.batchType().toDriver()).addStatements((java.lang.Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)statements$1.to(Collector$.MODULE$.supportsIterableFactory((IterableFactory)package$.MODULE$.Seq()))).asJava());
        return config$2.configureBatch(batch).build();
    }

    private static final CompletionStage $anonfun$1(AsyncResultSet in$1) {
        return in$1.fetchNextPage();
    }

    private static final Pull go$1$$anonfun$1(Pull next$1) {
        return next$1;
    }

    private final Pull go$1(AsyncResultSet in2) {
        Pull next;
        Pull pull = next = in2.hasMorePages() ? Pull$.MODULE$.eval(this.F.fromCompletionStage(this.F.delay(() -> CQLExecutorImpl.$anonfun$1(in2)))).flatMap((Function1 & Serializable)in -> this.go$1((AsyncResultSet)in)) : Pull$.MODULE$.done();
        if (in2.remaining() > 0) {
            return Pull$.MODULE$.output(Chunk$.MODULE$.from(CollectionConverters$.MODULE$.IterableHasAsScala(in2.currentPage()).asScala())).$greater$greater(() -> CQLExecutorImpl.go$1$$anonfun$1(next));
        }
        return next;
    }

    private final CompletionStage select$$anonfun$1(Statement query$1) {
        return this.underlyingSession.executeAsync(query$1);
    }

    private static final BoundStatement buildStatement$$anonfun$1$$anonfun$1(PreparedStatement preparedStatement$1, BindMarkers columns$1, ExecutionAttributes config$3) {
        BoundStatementBuilder initial = preparedStatement$1.boundStatementBuilder(new Object[0]);
        BoundStatementBuilder boundColumns = (BoundStatementBuilder)columns$1.underlying().foldLeft((Object)initial, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                BoundStatementBuilder accBuilder = (BoundStatementBuilder)tuple2._1();
                if (tuple22 != null) {
                    String colName = tuple22._1() == null ? null : ((BindMarkerName)tuple22._1()).name();
                    BindMarker column = (BindMarker)tuple22._2();
                    return column.write().encodeByFieldName(accBuilder, colName, column.value());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        BoundStatementBuilder result = config$3.configure(boundColumns);
        return result.build();
    }

    private final CompletionStage executeAction$$anonfun$1(Statement query$2) {
        return this.underlyingSession.executeAsync(query$2);
    }

    private final CompletionStage prepare$$anonfun$1(String query$3) {
        return this.underlyingSession.prepareAsync(query$3);
    }
}

