/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import kalix.javasdk.Metadata;
import kalix.javasdk.eventsourcedentity.EventSourcedEntity;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityContext;
import kalix.javasdk.impl.JsonMessageCodec;
import kalix.javasdk.impl.MethodInvoker;
import kalix.javasdk.impl.eventsourcedentity.EventSourceEntityHandlers;
import kalix.javasdk.impl.eventsourcedentity.EventSourcedHandlersExtractor;
import kalix.javasdk.testkit.EventSourcedResult;
import kalix.javasdk.testkit.impl.EventSourcedEntityEffectsRunner;
import kalix.javasdk.testkit.impl.TestKitEventSourcedEntityContext;

public class EventSourcedTestKit<S, E, ES extends EventSourcedEntity<S, E>>
extends EventSourcedEntityEffectsRunner<S, E> {
    private final ES entity;
    private final EventSourceEntityHandlers eventHandlers;
    private final JsonMessageCodec messageCodec;

    private EventSourcedTestKit(ES ES) {
        super(ES);
        this.entity = ES;
        this.messageCodec = new JsonMessageCodec();
        this.eventHandlers = EventSourcedHandlersExtractor.handlersFrom(ES.getClass(), (JsonMessageCodec)this.messageCodec);
    }

    public static <S, E, ES extends EventSourcedEntity<S, E>> EventSourcedTestKit<S, E, ES> of(Supplier<ES> supplier) {
        return EventSourcedTestKit.of("testkit-entity-id", supplier);
    }

    public static <S, E, ES extends EventSourcedEntity<S, E>> EventSourcedTestKit<S, E, ES> of(Function<EventSourcedEntityContext, ES> function) {
        return EventSourcedTestKit.of("testkit-entity-id", function);
    }

    public static <S, E, ES extends EventSourcedEntity<S, E>> EventSourcedTestKit<S, E, ES> of(String string, Supplier<ES> supplier) {
        return EventSourcedTestKit.of(string, (EventSourcedEntityContext eventSourcedEntityContext) -> (EventSourcedEntity)supplier.get());
    }

    public static <S, E, ES extends EventSourcedEntity<S, E>> EventSourcedTestKit<S, E, ES> of(String string, Function<EventSourcedEntityContext, ES> function) {
        TestKitEventSourcedEntityContext testKitEventSourcedEntityContext = new TestKitEventSourcedEntityContext(string);
        return new EventSourcedTestKit<S, E, EventSourcedEntity>((EventSourcedEntity)function.apply((EventSourcedEntityContext)testKitEventSourcedEntityContext));
    }

    public <R> EventSourcedResult<R> call(Function<ES, EventSourcedEntity.Effect<R>> function) {
        return this.interpretEffects(() -> (EventSourcedEntity.Effect)function.apply(this.entity), Metadata.EMPTY);
    }

    protected final S handleEvent(S s, E e) {
        try {
            Method method = ((MethodInvoker)this.eventHandlers.handlers().apply((Object)this.messageCodec.typeUrlFor(e.getClass()))).method();
            return (S)method.invoke(this.entity, e);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Couldn't find a valid event handler for event type '" + e.getClass().getName() + "'");
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

