/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import kalix.javasdk.Metadata;
import kalix.javasdk.testkit.ValueEntityResult;
import kalix.javasdk.testkit.impl.TestKitValueEntityCommandContext;
import kalix.javasdk.testkit.impl.TestKitValueEntityContext;
import kalix.javasdk.testkit.impl.ValueEntityResultImpl;
import kalix.javasdk.valueentity.ValueEntity;
import kalix.javasdk.valueentity.ValueEntityContext;

public class ValueEntityTestKit<S, E extends ValueEntity<S>> {
    private S state;
    private final S emptyState;
    private final E entity;
    private final String entityId;

    private ValueEntityTestKit(String string, E e) {
        this.entityId = string;
        this.entity = e;
        this.state = e.emptyState();
        this.emptyState = this.state;
    }

    public static <S, E extends ValueEntity<S>> ValueEntityTestKit<S, E> of(Supplier<E> supplier) {
        return ValueEntityTestKit.of((ValueEntityContext valueEntityContext) -> (ValueEntity)supplier.get());
    }

    public static <S, E extends ValueEntity<S>> ValueEntityTestKit<S, E> of(Function<ValueEntityContext, E> function) {
        return ValueEntityTestKit.of("testkit-entity-id", function);
    }

    public static <S, E extends ValueEntity<S>> ValueEntityTestKit<S, E> of(String string, Supplier<E> supplier) {
        return ValueEntityTestKit.of(string, (ValueEntityContext valueEntityContext) -> (ValueEntity)supplier.get());
    }

    public static <S, E extends ValueEntity<S>> ValueEntityTestKit<S, E> of(String string, Function<ValueEntityContext, E> function) {
        TestKitValueEntityContext testKitValueEntityContext = new TestKitValueEntityContext(string);
        return new ValueEntityTestKit<S, ValueEntity>(string, (ValueEntity)function.apply((ValueEntityContext)testKitValueEntityContext));
    }

    public S getState() {
        return this.state;
    }

    private <Reply> ValueEntityResult<Reply> interpretEffects(ValueEntity.Effect<Reply> effect) {
        ValueEntityResultImpl valueEntityResultImpl = new ValueEntityResultImpl(effect);
        if (valueEntityResultImpl.stateWasUpdated()) {
            this.state = valueEntityResultImpl.getUpdatedState();
        } else if (valueEntityResultImpl.stateWasDeleted()) {
            this.state = this.emptyState;
        }
        return valueEntityResultImpl;
    }

    public <R> ValueEntityResult<R> call(Function<E, ValueEntity.Effect<R>> function) {
        TestKitValueEntityCommandContext testKitValueEntityCommandContext = new TestKitValueEntityCommandContext(this.entityId, Metadata.EMPTY);
        this.entity._internalSetCommandContext(Optional.of(testKitValueEntityCommandContext));
        this.entity._internalSetCurrentState(this.state);
        return this.interpretEffects(function.apply(this.entity));
    }
}

