/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import kalix.javasdk.Metadata;
import kalix.javasdk.action.Action;
import kalix.javasdk.action.ActionCreationContext;
import kalix.javasdk.testkit.ActionResult;
import kalix.javasdk.testkit.MockRegistry;
import kalix.javasdk.testkit.impl.ActionResultImpl;
import kalix.javasdk.testkit.impl.TestKitActionContext;
import reactor.core.publisher.Flux;

public class ActionTestkit<A extends Action> {
    private final Function<ActionCreationContext, A> actionFactory;

    private ActionTestkit(Function<ActionCreationContext, A> function) {
        this.actionFactory = function;
    }

    public static <A extends Action> ActionTestkit<A> of(Function<ActionCreationContext, A> function) {
        return new ActionTestkit<A>(function);
    }

    public static <A extends Action> ActionTestkit<A> of(Supplier<A> supplier) {
        return new ActionTestkit<Action>(actionCreationContext -> (Action)supplier.get());
    }

    private A createAction(TestKitActionContext testKitActionContext) {
        Action action = (Action)this.actionFactory.apply((ActionCreationContext)testKitActionContext);
        action._internalSetActionContext(Optional.of(testKitActionContext));
        return (A)action;
    }

    public <R> ActionResult<R> call(Function<A, Action.Effect<R>> function) {
        return this.call(function, Metadata.EMPTY);
    }

    public <R> ActionResult<R> call(Function<A, Action.Effect<R>> function, Metadata metadata) {
        TestKitActionContext testKitActionContext = new TestKitActionContext(metadata, MockRegistry.EMPTY);
        return new ActionResultImpl(function.apply(this.createAction(testKitActionContext)));
    }

    public <R> Flux<ActionResult<R>> streamedCall(Function<A, Flux<Action.Effect<R>>> function) {
        TestKitActionContext testKitActionContext = new TestKitActionContext(Metadata.EMPTY, MockRegistry.EMPTY);
        Flux<Action.Effect<R>> flux = function.apply(this.createAction(testKitActionContext));
        return flux.map(effect -> new ActionResultImpl(effect));
    }
}

