/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.eventsourced;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import java.util.function.Function;
import kalix.javasdk.annotations.EntityType;
import kalix.javasdk.common.ForwardHeadersExtractor;
import kalix.javasdk.eventsourcedentity.EventSourcedEntity;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityContext;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityOptions;
import kalix.javasdk.eventsourcedentity.EventSourcedEntityProvider;
import kalix.javasdk.impl.ComponentDescriptor;
import kalix.javasdk.impl.JsonMessageCodec;
import kalix.javasdk.impl.MessageCodec;
import kalix.javasdk.impl.eventsourcedentity.EventSourceEntityHandlers;
import kalix.javasdk.impl.eventsourcedentity.EventSourcedEntityRouter;
import kalix.javasdk.impl.eventsourcedentity.EventSourcedHandlersExtractor;
import kalix.javasdk.impl.eventsourcedentity.ReflectiveEventSourcedEntityRouter;

public class ReflectiveEventSourcedEntityProvider<S, E, ES extends EventSourcedEntity<S, E>>
implements EventSourcedEntityProvider<S, E, ES> {
    private final String entityType;
    private final Function<EventSourcedEntityContext, ES> factory;
    private final EventSourcedEntityOptions options;
    private final Descriptors.FileDescriptor fileDescriptor;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ComponentDescriptor componentDescriptor;
    private final JsonMessageCodec messageCodec;
    private final EventSourceEntityHandlers eventHandlers;

    public static <S, E, ES extends EventSourcedEntity<S, E>> ReflectiveEventSourcedEntityProvider<S, E, ES> of(Class<ES> clazz, JsonMessageCodec jsonMessageCodec, Function<EventSourcedEntityContext, ES> function) {
        return new ReflectiveEventSourcedEntityProvider<S, E, ES>(clazz, jsonMessageCodec, function, EventSourcedEntityOptions.defaults());
    }

    public ReflectiveEventSourcedEntityProvider(Class<ES> clazz, JsonMessageCodec jsonMessageCodec, Function<EventSourcedEntityContext, ES> function, EventSourcedEntityOptions eventSourcedEntityOptions) {
        EntityType entityType = clazz.getAnnotation(EntityType.class);
        if (entityType == null) {
            throw new IllegalArgumentException("Event Sourced Entity [" + clazz.getName() + "] is missing '@EntityType' annotation");
        }
        this.eventHandlers = EventSourcedHandlersExtractor.handlersFrom(clazz, jsonMessageCodec);
        if (this.eventHandlers.errors().nonEmpty()) {
            throw new IllegalArgumentException("Event Sourced Entity [" + clazz.getName() + "] has event handlers configured incorrectly: " + this.eventHandlers.errors());
        }
        this.entityType = entityType.value();
        this.factory = function;
        this.options = eventSourcedEntityOptions.withForwardHeaders(ForwardHeadersExtractor.extractFrom(clazz));
        this.messageCodec = jsonMessageCodec;
        this.componentDescriptor = ComponentDescriptor.descriptorFor(clazz, jsonMessageCodec);
        this.fileDescriptor = this.componentDescriptor.fileDescriptor();
        this.serviceDescriptor = this.componentDescriptor.serviceDescriptor();
    }

    public EventSourcedEntityOptions options() {
        return this.options;
    }

    public Descriptors.ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public String entityType() {
        return this.entityType;
    }

    public EventSourcedEntityRouter<S, E, ES> newRouter(EventSourcedEntityContext eventSourcedEntityContext) {
        EventSourcedEntity eventSourcedEntity = (EventSourcedEntity)this.factory.apply(eventSourcedEntityContext);
        return new ReflectiveEventSourcedEntityRouter(eventSourcedEntity, this.componentDescriptor.commandHandlers(), this.eventHandlers.handlers(), this.messageCodec);
    }

    public Descriptors.FileDescriptor[] additionalDescriptors() {
        return new Descriptors.FileDescriptor[]{this.fileDescriptor};
    }

    public Optional<MessageCodec> alternativeCodec() {
        return Optional.of(this.messageCodec);
    }
}

