/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.valueentity;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import java.util.function.Function;
import kalix.javasdk.annotations.EntityType;
import kalix.javasdk.common.ForwardHeadersExtractor;
import kalix.javasdk.impl.ComponentDescriptor;
import kalix.javasdk.impl.JsonMessageCodec;
import kalix.javasdk.impl.MessageCodec;
import kalix.javasdk.impl.valueentity.ReflectiveValueEntityRouter;
import kalix.javasdk.impl.valueentity.ValueEntityRouter;
import kalix.javasdk.valueentity.ValueEntity;
import kalix.javasdk.valueentity.ValueEntityContext;
import kalix.javasdk.valueentity.ValueEntityOptions;
import kalix.javasdk.valueentity.ValueEntityProvider;

public class ReflectiveValueEntityProvider<S, E extends ValueEntity<S>>
implements ValueEntityProvider<S, E> {
    private final String entityType;
    private final Function<ValueEntityContext, E> factory;
    private final ValueEntityOptions options;
    private final Descriptors.FileDescriptor fileDescriptor;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ComponentDescriptor componentDescriptor;
    private final JsonMessageCodec messageCodec;

    public static <S, E extends ValueEntity<S>> ReflectiveValueEntityProvider<S, E> of(Class<E> clazz, JsonMessageCodec jsonMessageCodec, Function<ValueEntityContext, E> function) {
        return new ReflectiveValueEntityProvider<S, E>(clazz, jsonMessageCodec, function, ValueEntityOptions.defaults());
    }

    public ReflectiveValueEntityProvider(Class<E> clazz, JsonMessageCodec jsonMessageCodec, Function<ValueEntityContext, E> function, ValueEntityOptions valueEntityOptions) {
        EntityType entityType = clazz.getAnnotation(EntityType.class);
        if (entityType == null) {
            throw new IllegalArgumentException("Value Entity [" + clazz.getName() + "] is missing '@EntityType' annotation");
        }
        this.entityType = entityType.value();
        this.factory = function;
        this.options = valueEntityOptions.withForwardHeaders(ForwardHeadersExtractor.extractFrom(clazz));
        this.messageCodec = jsonMessageCodec;
        this.componentDescriptor = ComponentDescriptor.descriptorFor(clazz, jsonMessageCodec);
        this.fileDescriptor = this.componentDescriptor.fileDescriptor();
        this.serviceDescriptor = this.componentDescriptor.serviceDescriptor();
    }

    public ValueEntityOptions options() {
        return this.options;
    }

    public Descriptors.ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public String entityType() {
        return this.entityType;
    }

    public ValueEntityRouter<S, E> newRouter(ValueEntityContext valueEntityContext) {
        ValueEntity valueEntity = (ValueEntity)this.factory.apply(valueEntityContext);
        return new ReflectiveValueEntityRouter(valueEntity, this.componentDescriptor.commandHandlers());
    }

    public Descriptors.FileDescriptor[] additionalDescriptors() {
        return new Descriptors.FileDescriptor[]{this.fileDescriptor};
    }

    public Optional<MessageCodec> alternativeCodec() {
        return Optional.of(this.messageCodec);
    }
}

