/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.view;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import java.util.function.Function;
import kalix.javasdk.annotations.ViewId;
import kalix.javasdk.impl.ComponentDescriptor;
import kalix.javasdk.impl.ComponentDescriptorFactory;
import kalix.javasdk.impl.JsonMessageCodec;
import kalix.javasdk.impl.MessageCodec;
import kalix.javasdk.impl.view.ReflectiveViewRouter;
import kalix.javasdk.impl.view.ViewRouter;
import kalix.javasdk.view.View;
import kalix.javasdk.view.ViewCreationContext;
import kalix.javasdk.view.ViewOptions;
import kalix.javasdk.view.ViewProvider;

public class ReflectiveViewProvider<S, V extends View<S>>
implements ViewProvider {
    private final Function<ViewCreationContext, V> factory;
    private final String viewId;
    private final ViewOptions options;
    private final Descriptors.FileDescriptor fileDescriptor;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ComponentDescriptor componentDescriptor;
    private final JsonMessageCodec messageCodec;

    public static <S, V extends View<S>> ReflectiveViewProvider<S, V> of(Class<V> clazz, JsonMessageCodec jsonMessageCodec, Function<ViewCreationContext, V> function) {
        String string = Optional.ofNullable(clazz.getAnnotation(ViewId.class)).map(ViewId::value).orElseGet(clazz::getName);
        return new ReflectiveViewProvider<S, V>(clazz, jsonMessageCodec, string, function, ViewOptions.defaults());
    }

    private ReflectiveViewProvider(Class<V> clazz, JsonMessageCodec jsonMessageCodec, String string, Function<ViewCreationContext, V> function, ViewOptions viewOptions) {
        this.factory = function;
        this.options = viewOptions;
        this.messageCodec = jsonMessageCodec;
        this.viewId = string;
        this.componentDescriptor = ComponentDescriptor.descriptorFor(clazz, jsonMessageCodec);
        this.fileDescriptor = this.componentDescriptor.fileDescriptor();
        this.serviceDescriptor = this.componentDescriptor.serviceDescriptor();
    }

    public Descriptors.ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public String viewId() {
        return this.viewId;
    }

    public ViewOptions options() {
        return this.options;
    }

    public ViewRouter<S, V> newRouter(ViewCreationContext viewCreationContext) {
        View view = (View)this.factory.apply(viewCreationContext);
        return new ReflectiveViewRouter(view, this.componentDescriptor.commandHandlers(), ComponentDescriptorFactory.findIgnore(view.getClass()));
    }

    public Descriptors.FileDescriptor[] additionalDescriptors() {
        return new Descriptors.FileDescriptor[0];
    }

    public Optional<MessageCodec> alternativeCodec() {
        return Optional.of(this.messageCodec);
    }
}

