/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.workflowentity;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import java.util.function.Function;
import kalix.javasdk.annotations.EntityType;
import kalix.javasdk.impl.ComponentDescriptor;
import kalix.javasdk.impl.JsonMessageCodec;
import kalix.javasdk.impl.MessageCodec;
import kalix.javasdk.impl.StrictJsonMessageCodec;
import kalix.javasdk.impl.workflow.ReflectiveWorkflowEntityRouter;
import kalix.javasdk.impl.workflowentity.WorkflowEntityRouter;
import kalix.javasdk.workflowentity.WorkflowEntity;
import kalix.javasdk.workflowentity.WorkflowEntityContext;
import kalix.javasdk.workflowentity.WorkflowEntityOptions;
import kalix.javasdk.workflowentity.WorkflowEntityProvider;

public class ReflectiveWorkflowEntityProvider<S, W extends WorkflowEntity<S>>
implements WorkflowEntityProvider<S, W> {
    private final Class<W> workflowClass;
    private final MessageCodec messageCodec;
    private final Function<WorkflowEntityContext, W> factory;
    private final WorkflowEntityOptions options;
    private final String entityType;
    private final Descriptors.FileDescriptor fileDescriptor;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final ComponentDescriptor componentDescriptor;

    public ReflectiveWorkflowEntityProvider(Class<W> clazz, JsonMessageCodec jsonMessageCodec, Function<WorkflowEntityContext, W> function, WorkflowEntityOptions workflowEntityOptions) {
        EntityType entityType = clazz.getAnnotation(EntityType.class);
        if (entityType == null) {
            throw new IllegalArgumentException("Workflow Entity [" + clazz.getName() + "] is missing '@EntityType' annotation");
        }
        this.workflowClass = clazz;
        this.messageCodec = new StrictJsonMessageCodec(jsonMessageCodec);
        this.factory = function;
        this.options = workflowEntityOptions;
        this.entityType = entityType.value();
        this.componentDescriptor = ComponentDescriptor.descriptorFor(clazz, jsonMessageCodec);
        this.fileDescriptor = this.componentDescriptor.fileDescriptor();
        this.serviceDescriptor = this.componentDescriptor.serviceDescriptor();
    }

    public static <S, W extends WorkflowEntity<S>> ReflectiveWorkflowEntityProvider<S, W> of(Class<W> clazz, JsonMessageCodec jsonMessageCodec, Function<WorkflowEntityContext, W> function) {
        return new ReflectiveWorkflowEntityProvider<S, W>(clazz, jsonMessageCodec, function, WorkflowEntityOptions.defaults());
    }

    public String workflowName() {
        return this.entityType;
    }

    public WorkflowEntityOptions options() {
        return this.options;
    }

    public Descriptors.ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public WorkflowEntityRouter<S, W> newRouter(WorkflowEntityContext workflowEntityContext) {
        WorkflowEntity workflowEntity = (WorkflowEntity)this.factory.apply(workflowEntityContext);
        return new ReflectiveWorkflowEntityRouter(workflowEntity, this.componentDescriptor.commandHandlers());
    }

    public Descriptors.FileDescriptor[] additionalDescriptors() {
        return new Descriptors.FileDescriptor[]{this.fileDescriptor};
    }

    public Optional<MessageCodec> alternativeCodec() {
        return Optional.of(this.messageCodec);
    }
}

