/*
 * Decompiled with CFR 0.152.
 */
package kamon.annotation.instrumentation.advisor;

import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import kamon.annotation.instrumentation.cache.AnnotationCache;
import kamon.annotation.util.Hooks;
import kamon.metric.Timer;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import kanela.agent.libs.net.bytebuddy.implementation.bytecode.assign.Assigner;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class TimeAnnotationAdvisor {
    public static final ExecutionContext CallingThreadEC = CallingThreadExecutionContext$.MODULE$;

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void start(@Advice.This(optional=true) Object object, @Advice.Origin Class<?> clazz, @Advice.Origin Method method, @Advice.Origin(value="#t") String string, @Advice.Origin(value="#m") String string2, @Advice.Local(value="startedTimer") Timer.Started started) {
        Timer timer = AnnotationCache.getTimer(method, object, clazz, string, string2);
        started = timer.start();
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public static void end(@Advice.Local(value="startedTimer") Timer.Started started, @Advice.Return(typing=Assigner.Typing.DYNAMIC) Object object) {
        if (object instanceof Future) {
            Hooks.stopTimerOnComplete((Future)object, started);
        } else if (object instanceof CompletionStage) {
            ((CompletionStage)object).handle(new CompletionStageCompleteFunction(started));
        } else {
            started.stop();
        }
    }

    public static class CompletionStageCompleteFunction<T>
    implements BiFunction<T, Throwable, Object> {
        private final Timer.Started timer;

        public CompletionStageCompleteFunction(Timer.Started started) {
            this.timer = started;
        }

        @Override
        public Object apply(T t, Throwable throwable) {
            this.timer.stop();
            return null;
        }
    }
}

