/*
 * Decompiled with CFR 0.152.
 */
package kamon.apm;

import com.typesafe.config.Config;
import java.net.Proxy;
import java.time.Duration;
import java.util.HashMap;
import java.util.regex.Pattern;
import kamino.IngestionV1;
import kamon.Kamon$;
import kamon.apm.package;
import kamon.tag.Tag$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;

public final class package$ {
    public static package$ MODULE$;
    private final Logger _logger;
    private final Pattern _apiKeyPattern;

    static {
        new package$();
    }

    public Logger _logger() {
        return this._logger;
    }

    private Pattern _apiKeyPattern() {
        return this._apiKeyPattern;
    }

    public package.Settings readSettings(Config config, String path) {
        None$ none$;
        Config apmConfig = config.getConfig(path);
        String apiKey = apmConfig.getString("api-key");
        if (apiKey.equals("none")) {
            this._logger().error("No API key defined in the kamon.apm.api-key setting");
        }
        HashMap<String, String> environmentTagsMap = new HashMap<String, String>();
        Kamon$.MODULE$.environment().tags().all().foreach((Function1 & java.io.Serializable & Serializable)t -> environmentTagsMap.put(t.key(), String.valueOf(Tag$.MODULE$.unwrapValue(t))));
        IngestionV1.Plan x$2 = apmConfig.getBoolean("enable-tracing") ? IngestionV1.Plan.METRIC_TRACING : IngestionV1.Plan.METRIC_ONLY;
        Duration x$3 = apmConfig.getDuration("client.timeouts.connection");
        Duration x$4 = apmConfig.getDuration("client.timeouts.read");
        String x$5 = apmConfig.getString("app-version");
        String x$6 = apmConfig.getString("ingestion-api");
        String x$7 = apmConfig.getString("agent");
        int x$8 = apmConfig.getInt("retries.boot");
        int x$9 = apmConfig.getInt("retries.ingestion");
        int x$10 = apmConfig.getInt("retries.shutdown");
        int x$11 = apmConfig.getInt("retries.tracing");
        Duration x$12 = apmConfig.getDuration("retries.backoff");
        Duration x$13 = apmConfig.getDuration("client.backoff");
        String x$14 = apmConfig.getString("proxy.host");
        int x$15 = apmConfig.getInt("proxy.port");
        String string = apmConfig.getString("proxy.type").toLowerCase();
        if ("system".equals(string)) {
            none$ = None$.MODULE$;
        } else if ("socks".equals(string)) {
            none$ = new Some((Object)Proxy.Type.SOCKS);
        } else if ("https".equals(string)) {
            none$ = new Some((Object)Proxy.Type.HTTP);
        } else {
            throw new MatchError((Object)string);
        }
        return new package.Settings(apiKey, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Proxy.Type>)none$, x$14, x$15, environmentTagsMap);
    }

    public boolean isAcceptableApiKey(String apiKey) {
        return apiKey != null && apiKey.length() == 26 && this._apiKeyPattern().matcher(apiKey).matches();
    }

    public int countsArrayIndex(long value) {
        int SubBucketHalfCountMagnitude = 7;
        int SubBucketHalfCount = 128;
        int UnitMagnitude = 0;
        int SubBucketCount = (int)Math.pow(2.0, SubBucketHalfCountMagnitude + 1);
        int LeadingZeroCountBase = 64 - UnitMagnitude - SubBucketHalfCountMagnitude - 1;
        long SubBucketMask = (long)SubBucketCount - 1L << UnitMagnitude;
        if (value < 0L) {
            throw new ArrayIndexOutOfBoundsException("Histogram recorded value cannot be negative.");
        }
        int bucketIndex = package$.getBucketIndex$1(value, LeadingZeroCountBase, SubBucketMask);
        int subBucketIndex = package$.getSubBucketIndex$1(value, bucketIndex, UnitMagnitude);
        return package$.countsArrayIndex$1(bucketIndex, subBucketIndex, SubBucketHalfCountMagnitude, SubBucketHalfCount);
    }

    private static final int countsArrayIndex$1(int bucketIndex, int subBucketIndex, int SubBucketHalfCountMagnitude$1, int SubBucketHalfCount$1) {
        int bucketBaseIndex = bucketIndex + 1 << SubBucketHalfCountMagnitude$1;
        int offsetInBucket = subBucketIndex - SubBucketHalfCount$1;
        return bucketBaseIndex + offsetInBucket;
    }

    private static final int getBucketIndex$1(long value, int LeadingZeroCountBase$1, long SubBucketMask$1) {
        return LeadingZeroCountBase$1 - Long.numberOfLeadingZeros(value | SubBucketMask$1);
    }

    private static final int getSubBucketIndex$1(long value, long bucketIndex, int UnitMagnitude$1) {
        return (int)Math.floor((double)value / Math.pow(2.0, bucketIndex + (long)UnitMagnitude$1));
    }

    private package$() {
        MODULE$ = this;
        this._logger = LoggerFactory.getLogger((String)"kamon.apm");
        this._apiKeyPattern = Pattern.compile("^[a-zA-Z0-9]*$");
    }
}

