/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.QueryOperations$;
import com.datastax.driver.core.RequestHandler;
import java.util.concurrent.atomic.AtomicReference;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Context$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$;
import kamon.instrumentation.cassandra.CassandraInstrumentation$Tags$;
import kamon.instrumentation.cassandra.metrics.HasPoolMetrics;
import kamon.instrumentation.cassandra.metrics.NodeMonitor;
import kamon.instrumentation.context.HasContext;
import kamon.trace.Span;
import kamon.trace.Span$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;

public final class QueryExecutionAdvice$ {
    public static QueryExecutionAdvice$ MODULE$;
    private final Context.Key<Span> ParentSpanKey;

    static {
        new QueryExecutionAdvice$();
    }

    public Context.Key<Span> ParentSpanKey() {
        return this.ParentSpanKey;
    }

    @Advice.OnMethodEnter
    public void onQueryExec(@Advice.This HasContext execution, @Advice.Argument(value=0) Host host, @Advice.FieldValue(value="position") int position, @Advice.FieldValue(value="queryStateRef") AtomicReference<RequestHandler.QueryState> queryState) {
        NodeMonitor nodeMonitor = ((HasPoolMetrics)host).nodeMonitor();
        Span clientSpan = Kamon$.MODULE$.currentSpan();
        Span.Empty$ executionSpan = CassandraInstrumentation$.MODULE$.settings().createRoundTripSpans() ? Kamon$.MODULE$.clientSpanBuilder(QueryOperations$.MODULE$.ExecutionOperationName(), CassandraInstrumentation$Tags$.MODULE$.CassandraDriverComponent()).asChildOf(clientSpan).start() : Span.Empty$.MODULE$;
        if (position > 0) {
            nodeMonitor.speculativeExecution();
            executionSpan.tag("cassandra.speculative", true);
        }
        if (queryState.get().isCancelled()) {
            nodeMonitor.cancellation();
        }
        ((HasPoolMetrics)host).nodeMonitor().executionStarted();
        nodeMonitor.applyNodeTags((Span)executionSpan);
        Context executionContext = execution.context().withEntry(Span$.MODULE$.Key(), (Object)executionSpan).withEntry(this.ParentSpanKey(), (Object)clientSpan);
        execution.setContext(executionContext);
    }

    private QueryExecutionAdvice$() {
        MODULE$ = this;
        this.ParentSpanKey = Context$.MODULE$.key("__parent-span", (Object)Span.Empty$.MODULE$);
    }
}

