/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka;

import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.metric.Metric;
import kamon.package;
import kamon.package$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import scala.Function0;
import scala.Serializable;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;

public final class AkkaMetrics$ {
    public static AkkaMetrics$ MODULE$;
    private final TrieMap<String, AkkaMetrics.ActorGroupInstruments> _groupInstrumentsCache;
    private final TrieMap<String, AkkaMetrics.ActorSystemInstruments> _systemInstrumentsCache;
    private final Metric.Timer ActorTimeInMailbox;
    private final Metric.Timer ActorProcessingTime;
    private final Metric.RangeSampler ActorMailboxSize;
    private final Metric.Counter ActorErrors;
    private final Metric.Timer RouterRoutingTime;
    private final Metric.Timer RouterTimeInMailbox;
    private final Metric.Timer RouterProcessingTime;
    private final Metric.RangeSampler RouterPendingMessages;
    private final Metric.RangeSampler RouterMembers;
    private final Metric.Counter RouterErrors;
    private final Metric.Timer GroupTimeInMailbox;
    private final Metric.Timer GroupProcessingTime;
    private final Metric.RangeSampler GroupPendingMessages;
    private final Metric.RangeSampler GroupMembers;
    private final Metric.Counter GroupErrors;
    private final Metric.Counter SystemDeadLetters;
    private final Metric.Counter SystemUnhandledMessages;
    private final Metric.Counter SystemProcessedMessages;
    private final Metric.RangeSampler SystemActiveActors;

    static {
        new AkkaMetrics$();
    }

    private TrieMap<String, AkkaMetrics.ActorGroupInstruments> _groupInstrumentsCache() {
        return this._groupInstrumentsCache;
    }

    private TrieMap<String, AkkaMetrics.ActorSystemInstruments> _systemInstrumentsCache() {
        return this._systemInstrumentsCache;
    }

    public Metric.Timer ActorTimeInMailbox() {
        return this.ActorTimeInMailbox;
    }

    public Metric.Timer ActorProcessingTime() {
        return this.ActorProcessingTime;
    }

    public Metric.RangeSampler ActorMailboxSize() {
        return this.ActorMailboxSize;
    }

    public Metric.Counter ActorErrors() {
        return this.ActorErrors;
    }

    public AkkaMetrics.ActorInstruments forActor(String path, String system, String dispatcher, Class<?> actorClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher);
        if (!ActorCellInfo$.MODULE$.isTyped(actorClass)) {
            tags.add("class", actorClass.getName());
        }
        return new AkkaMetrics.ActorInstruments(tags.build());
    }

    public Metric.Timer RouterRoutingTime() {
        return this.RouterRoutingTime;
    }

    public Metric.Timer RouterTimeInMailbox() {
        return this.RouterTimeInMailbox;
    }

    public Metric.Timer RouterProcessingTime() {
        return this.RouterProcessingTime;
    }

    public Metric.RangeSampler RouterPendingMessages() {
        return this.RouterPendingMessages;
    }

    public Metric.RangeSampler RouterMembers() {
        return this.RouterMembers;
    }

    public Metric.Counter RouterErrors() {
        return this.RouterErrors;
    }

    public AkkaMetrics.RouterInstruments forRouter(String path, String system, String dispatcher, Class<?> routerClass, String routeeClass) {
        TagSet.Builder tags = TagSet$.MODULE$.builder().add("path", path).add("system", system).add("dispatcher", dispatcher).add("routeeClass", routeeClass);
        if (!ActorCellInfo$.MODULE$.isTyped(routerClass)) {
            tags.add("routerClass", routerClass.getName());
        }
        return new AkkaMetrics.RouterInstruments(tags.build());
    }

    public Metric.Timer GroupTimeInMailbox() {
        return this.GroupTimeInMailbox;
    }

    public Metric.Timer GroupProcessingTime() {
        return this.GroupProcessingTime;
    }

    public Metric.RangeSampler GroupPendingMessages() {
        return this.GroupPendingMessages;
    }

    public Metric.RangeSampler GroupMembers() {
        return this.GroupMembers;
    }

    public Metric.Counter GroupErrors() {
        return this.GroupErrors;
    }

    public AkkaMetrics.ActorGroupInstruments forGroup(String group, String system) {
        return (AkkaMetrics.ActorGroupInstruments)((Object)this._groupInstrumentsCache().getOrElseUpdate((Object)new StringBuilder(1).append(system).append("/").append(group).toString(), (Function0 & java.io.Serializable & Serializable)() -> {
            TagSet.Builder tags = TagSet$.MODULE$.builder().add("group", group).add("system", system);
            return new AkkaMetrics.ActorGroupInstruments(tags.build());
        }));
    }

    public Metric.Counter SystemDeadLetters() {
        return this.SystemDeadLetters;
    }

    public Metric.Counter SystemUnhandledMessages() {
        return this.SystemUnhandledMessages;
    }

    public Metric.Counter SystemProcessedMessages() {
        return this.SystemProcessedMessages;
    }

    public Metric.RangeSampler SystemActiveActors() {
        return this.SystemActiveActors;
    }

    public AkkaMetrics.ActorSystemInstruments forSystem(String name) {
        return (AkkaMetrics.ActorSystemInstruments)((Object)package.AtomicGetOrElseUpdateOnTrieMap$.MODULE$.atomicGetOrElseUpdate$extension0(package$.MODULE$.AtomicGetOrElseUpdateOnTrieMap(this._systemInstrumentsCache()), (Object)name, (Function0 & java.io.Serializable & Serializable)() -> new AkkaMetrics.ActorSystemInstruments(TagSet$.MODULE$.of("system", name))));
    }

    private AkkaMetrics$() {
        MODULE$ = this;
        this._groupInstrumentsCache = TrieMap$.MODULE$.empty();
        this._systemInstrumentsCache = TrieMap$.MODULE$.empty();
        this.ActorTimeInMailbox = Kamon$.MODULE$.timer("akka.actor.time-in-mailbox", "Tracks the time since the instant a message is enqueued in an Actor's mailbox until it is dequeued for processing");
        this.ActorProcessingTime = Kamon$.MODULE$.timer("akka.actor.processing-time", "Tracks the time taken for the actor to process the receive function");
        this.ActorMailboxSize = Kamon$.MODULE$.rangeSampler("akka.actor.mailbox-size", "Tracks the behavior of an Actor's mailbox size");
        this.ActorErrors = Kamon$.MODULE$.counter("akka.actor.errors", "Counts the number of processing errors experienced by an Actor");
        this.RouterRoutingTime = Kamon$.MODULE$.timer("akka.router.routing-time", "Tracks the time taken by a router to process its routing logic");
        this.RouterTimeInMailbox = Kamon$.MODULE$.timer("akka.router.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a routee's mailbox until it is dequeued for processing");
        this.RouterProcessingTime = Kamon$.MODULE$.timer("akka.router.processing-time", "Tracks the time taken for a routee to process the receive function");
        this.RouterPendingMessages = Kamon$.MODULE$.rangeSampler("akka.router.pending-messages", "Tracks the number of messages waiting to be processed across all routees");
        this.RouterMembers = Kamon$.MODULE$.rangeSampler("akka.router.members", "Tracks the number of routees belonging to a router");
        this.RouterErrors = Kamon$.MODULE$.counter("akka.router.errors", "Counts the number of processing errors experienced by the routees of a router");
        this.GroupTimeInMailbox = Kamon$.MODULE$.timer("akka.group.time-in-mailbox", "Tracks the time since the instant a message is enqueued in a member's mailbox until it is dequeued for processing");
        this.GroupProcessingTime = Kamon$.MODULE$.timer("akka.group.processing-time", "Tracks the time taken for a member actor to process the receive function");
        this.GroupPendingMessages = Kamon$.MODULE$.rangeSampler("akka.group.pending-messages", "Tracks the number of messages waiting to be processed across all members");
        this.GroupMembers = Kamon$.MODULE$.rangeSampler("akka.group.members", "Tracks the number of routees belonging to a group");
        this.GroupErrors = Kamon$.MODULE$.counter("akka.group.errors", "Counts the number of processing errors experienced by the members of a group");
        this.SystemDeadLetters = Kamon$.MODULE$.counter("akka.system.dead-letters", "Counts the number of dead letters in an Actor System");
        this.SystemUnhandledMessages = Kamon$.MODULE$.counter("akka.system.unhandled-messages", "Counts the number of unhandled messages in an Actor System");
        this.SystemProcessedMessages = Kamon$.MODULE$.counter("akka.system.processed-messages", "Counts the number of processed messages in an Actor System");
        this.SystemActiveActors = Kamon$.MODULE$.rangeSampler("akka.system.active-actors", "Tracks the number of active Actors in an Actor System");
    }
}

