/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.Envelope;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.akka.AkkaMetrics;
import kamon.instrumentation.akka.AkkaMetrics$;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo;
import kamon.instrumentation.akka.instrumentations.ActorCellInfo$;
import kamon.instrumentation.akka.instrumentations.ActorMonitor$;
import kamon.instrumentation.akka.instrumentations.AkkaPrivateAccess;
import kamon.metric.Counter;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import kamon.util.Clock;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r%faB4i!\u0003\r\n!\u001d\u0005\u0006q\u00021\t!\u001f\u0005\b\u0003\u0003\u0001a\u0011AA\u0002\u0011\u001d\tY\u0001\u0001D\u0001\u0003\u0007Aq!!\u0004\u0001\r\u0003\ty\u0001C\u0004\u00020\u00011\t!!\r\t\u000f\u0005\u0015\u0003A\"\u0001\u0002H!9\u0011Q\r\u0001\u0007\u0002\u0005\u001d\u0004bBA7\u0001\u0019\u0005\u0011q\u000e\u0005\b\u0003c\u0002a\u0011AA8\u000f\u001d\t\u0019\b\u001bE\u0001\u0003k2aa\u001a5\t\u0002\u0005e\u0004bBA>\u0017\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u007fZA\u0011AAA\u0011\u001d\t9k\u0003C\u0005\u0003SCq!a:\f\t\u0013\tI\u000fC\u0004\u0002p.!I!!=\u0007\r\t\u001d2\u0002\u0001B\u0015\u0011)\ti+\u0005B\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0005W\t\"\u0011!Q\u0001\n\u0005e\u0006B\u0003B\u0017#\t\u0005\t\u0015!\u0003\u0002\u0004\"9\u00111P\t\u0005\u0002\t=\u0002bBA\u0001#\u0011\u0005\u00131\u0001\u0005\u0006qF!\t%\u001f\u0005\b\u0003\u0017\tB\u0011IA\u0002\u0011\u001d\ti!\u0005C!\u0005wAq!a\f\u0012\t\u0003\u0012\u0019\u0005C\u0004\u0002FE!\tE!\u0014\t\u000f\u0005\u0015\u0014\u0003\"\u0011\u0003R!9\u0011QN\t\u0005B\u0005=\u0004bBA9#\u0011\u0005\u0013q\u000e\u0005\b\u0005+\nB\u0011\u0002B,\u0011\u001d\u0011Y&\u0005C\u0005\u0005;BqAa\u001f\u0012\t\u0013\u0011iH\u0002\u0004\u0003\bF!!\u0011\u0012\u0005\u000b\u0005\u0017\u0013#Q1A\u0005\u0002\t5\u0005B\u0003BKE\t\u0005\t\u0015!\u0003\u0003\u0010\"Q!q\u0013\u0012\u0003\u0006\u0004%\tA!'\t\u0015\tm%E!A!\u0002\u0013\t\t\u0002C\u0004\u0002|\t\"\tA!(\u0007\r\t\u001d6\u0002\u0001BU\u0011)\ti\u000b\u000bB\u0001B\u0003%\u0011q\u0016\u0005\u000b\u0003\u0003D#\u0011!Q\u0001\n\u0005e\u0006B\u0003BVQ\t\u0005\t\u0015!\u0003\u0002:\"9\u00111\u0010\u0015\u0005\u0002\t5\u0006\"\u0003B\\Q\t\u0007I\u0011\u0002B]\u0011!\u0011)\r\u000bQ\u0001\n\tm\u0006bBA\u0001Q\u0011\u0005\u00131\u0001\u0005\u0006q\"\"\t%\u001f\u0005\b\u0003\u0017AC\u0011IA\u0002\u0011\u001d\ti\u0001\u000bC!\u0005\u000fDq!a\f)\t\u0003\u0012y\rC\u0004\u0002F!\"\tE!7\t\u000f\u0005\u0015\u0004\u0006\"\u0011\u0003^\"9\u0011Q\u000e\u0015\u0005B\u0005=\u0004bBA9Q\u0011\u0005\u0011q\u000e\u0004\u0007\u0005C\\\u0001Aa9\t\u0015\rU\u0002H!A!\u0002\u0013\u00199\u0004\u0003\u0006\u0002Fb\u0012\t\u0011)A\u0005\u0003\u000fD!\"!,9\u0005\u0003\u0005\u000b\u0011BAX\u0011\u001d\tY\b\u000fC\u0001\u0007\u0007B\u0011b!\u00149\u0005\u0004%Iaa\u0014\t\u0011\ru\u0003\b)A\u0005\u0007#Bq!!\u00019\t\u0003\n\u0019\u0001C\u0003yq\u0011\u0005\u0013\u0010C\u0004\u0002\u000ea\"\tea\u0018\t\u000f\u0005=\u0002\b\"\u0011\u0004h!9\u0011Q\t\u001d\u0005B\rE\u0004bBA9q\u0011\u0005\u0013q\u000e\u0004\u0007\u0007kZ\u0001aa\u001e\t\u0015\reTI!A!\u0002\u0013\u0019Y\b\u0003\u0006\u0002F\u0016\u0013\t\u0011)A\u0005\u0003\u000fD!\"!,F\u0005\u0003\u0005\u000b\u0011BAX\u0011\u001d\tY(\u0012C\u0001\u0007\u0003C\u0011ba#F\u0005\u0004%Iaa\u0014\t\u0011\r5U\t)A\u0005\u0007#BQ\u0001_#\u0005BeDq!!\u0004F\t\u0003\u001ay\tC\u0004\u00020\u0015#\tea&\t\u000f\u0005\u0015S\t\"\u0011\u0004\"\"9\u0011QM#\u0005B\r\u0015\u0006bBA9\u000b\u0012\u0005\u0013q\u000e\u0004\b\u0005O\\\u0011\u0011\u0001Bu\u0011)\t)M\u0015B\u0001B\u0003%\u0011q\u0019\u0005\u000b\u0003[\u0013&\u0011!Q\u0001\n\u0005=\u0006bBA>%\u0012\u0005!1\u001e\u0005\n\u0005c\u0014\u0006\u0019!C\u0005\u0005gD\u0011B!>S\u0001\u0004%IAa>\t\u0011\tu(\u000b)Q\u0005\u0003sC\u0011ba\u0002S\u0005\u0004%IAa=\t\u0011\r%!\u000b)A\u0005\u0003sC\u0011ba\u0003S\u0005\u0004%\tb!\u0004\t\u0011\rm!\u000b)A\u0005\u0007\u001fA\u0011b!\bS\u0005\u0004%\tB!/\t\u0011\r}!\u000b)A\u0005\u0005wCq!!\u0001S\t\u0003\n\u0019\u0001C\u0003y%\u0012\u0005\u0013\u0010C\u0004\u0002\fI#\t%a\u0001\t\u000f\u0005\u0015#\u000b\"\u0011\u0004\"!9\u0011Q\r*\u0005B\r\u0015\u0002bBB\u0015%\u0012E11\u0006\u0005\b\u0003[\u0012F\u0011IA8\u0011\u001d\t\tH\u0015C\u0001\u0003_\u0012A\"Q2u_JluN\\5u_JT!!\u001b6\u0002!%t7\u000f\u001e:v[\u0016tG/\u0019;j_:\u001c(BA6m\u0003\u0011\t7n[1\u000b\u00055t\u0017aD5ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u000b\u0003=\fQa[1n_:\u001c\u0001a\u0005\u0002\u0001eB\u00111O^\u0007\u0002i*\tQ/A\u0003tG\u0006d\u0017-\u0003\u0002xi\n1\u0011I\\=SK\u001a\facY1qiV\u0014X-\u00128wK2|\u0007/Z\"p]R,\u0007\u0010\u001e\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011QP\\\u0001\bG>tG/\u001a=u\u0013\tyHPA\u0004D_:$X\r\u001f;\u00021\r\f\u0007\u000f^;sK\u0016sg/\u001a7pa\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u0002\u0006A\u00191/a\u0002\n\u0007\u0005%AO\u0001\u0003M_:<\u0017aH2baR,(/\u001a)s_\u000e,7o]5oON#\u0018M\u001d;US6,7\u000f^1na\u0006ArN\\'fgN\fw-\u001a)s_\u000e,7o]5oON#\u0018M\u001d;\u0015\u0011\u0005E\u0011qCA\r\u0003;\u00012a]A\n\u0013\r\t)\u0002\u001e\u0002\u0004\u0003:L\b\"B?\u0005\u0001\u0004Q\bbBA\u000e\t\u0001\u0007\u0011QA\u0001\u0012K:4X\r\\8qKRKW.Z:uC6\u0004\bbBA\u0010\t\u0001\u0007\u0011\u0011E\u0001\tK:4X\r\\8qKB!\u00111EA\u0016\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00033jgB\fGo\u00195\u000b\u0003-LA!!\f\u0002&\tAQI\u001c<fY>\u0004X-\u0001\fp]6+7o]1hKB\u0013xnY3tg&tw-\u00128e))\t\u0019$!\u000f\u0002<\u0005u\u0012\u0011\t\t\u0004g\u0006U\u0012bAA\u001ci\n!QK\\5u\u0011\u0015iX\u00011\u0001{\u0011\u001d\tY\"\u0002a\u0001\u0003\u000bAq!a\u0010\u0006\u0001\u0004\t)!\u0001\rqe>\u001cWm]:j]\u001e\u001cF/\u0019:u)&lWm\u001d;b[BDq!a\u0011\u0006\u0001\u0004\t\t\"\u0001\bti\u0006$XM\u0012:p[N#\u0018M\u001d;\u0002\u0013=tg)Y5mkJ,G\u0003BA\u001a\u0003\u0013Bq!a\u0013\u0007\u0001\u0004\ti%A\u0004gC&dWO]3\u0011\t\u0005=\u0013q\f\b\u0005\u0003#\nYF\u0004\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006]\u0001\u0007yI|w\u000e\u001e \n\u0003UL1!!\u0018u\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0019\u0002d\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003;\"\u0018!E8o\tJ|\u0007\u000f]3e\u001b\u0016\u001c8/Y4fgR!\u00111GA5\u0011\u001d\tYg\u0002a\u0001\u0003\u000b\tQaY8v]R\f!c\u001c8UKJl\u0017N\\1uS>t7\u000b^1siR\u0011\u00111G\u0001\bG2,\u0017M\\;q\u00031\t5\r^8s\u001b>t\u0017\u000e^8s!\r\t9hC\u0007\u0002QN\u00111B]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005U\u0014\u0001\u00024s_6$\"\"a!\u0002\u0006\u0006%\u0015\u0011TAO!\r\t9\b\u0001\u0005\b\u0003\u000fk\u0001\u0019AA\t\u0003%\t7\r^8s\u0007\u0016dG\u000eC\u0004\u0002\f6\u0001\r!!$\u0002\u0007I,g\r\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*!\u000b\u0002\u000b\u0005\u001cGo\u001c:\n\t\u0005]\u0015\u0011\u0013\u0002\t\u0003\u000e$xN\u001d*fM\"9\u00111T\u0007A\u0002\u00055\u0015A\u00029be\u0016tG\u000fC\u0004\u0002 6\u0001\r!!)\u0002\rML8\u000f^3n!\u0011\ty)a)\n\t\u0005\u0015\u0016\u0011\u0013\u0002\f\u0003\u000e$xN]*zgR,W.A\rde\u0016\fG/\u001a*fOVd\u0017M]!di>\u0014Xj\u001c8ji>\u0014HCCAB\u0003W\u000b),a0\u0002D\"9\u0011Q\u0016\bA\u0002\u0005=\u0016\u0001C2fY2LeNZ8\u0011\t\u0005]\u0014\u0011W\u0005\u0004\u0003gC'!D!di>\u00148)\u001a7m\u0013:4w\u000eC\u0004\u00028:\u0001\r!!/\u0002\u0013%\u001cHK]1dW\u0016$\u0007cA:\u0002<&\u0019\u0011Q\u0018;\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0019\bA\u0002\u0005e\u0016!\u00069beRL7-\u001b9bi\u0016\u001c\u0018J\u001c+sC\u000eLgn\u001a\u0005\b\u0003\u000bt\u0001\u0019AAd\u000319'o\\;q\u001b\u0016$(/[2t!\u0019\ty%!3\u0002N&!\u00111ZA2\u0005\r\u0019V-\u001d\t\u0005\u0003\u001f\f\tO\u0004\u0003\u0002R\u0006ug\u0002BAj\u00037tA!!6\u0002Z:!\u00111KAl\u0013\u0005y\u0017BA7o\u0013\tYG.C\u0002\u0002`*\f1\"Q6lC6+GO]5dg&!\u00111]As\u0005U\t5\r^8s\u000fJ|W\u000f]%ogR\u0014X/\\3oiNT1!a8k\u0003M\u0019'/Z1uKJ{W\u000f^3f\u001b>t\u0017\u000e^8s)\u0019\t\u0019)a;\u0002n\"9\u0011QV\bA\u0002\u0005=\u0006bBAc\u001f\u0001\u0007\u0011qY\u0001\u0018e\u0016\u001cx\u000e\u001c<f\u0003V$xn\u0012:pkBLgn\u001a)bi\"$\"\"a=\u0003\u0004\t}!\u0011\u0005B\u0012!\u0011\t)0!@\u000f\t\u0005]\u0018\u0011 \t\u0004\u0003'\"\u0018bAA~i\u00061\u0001K]3eK\u001aLA!a@\u0003\u0002\t11\u000b\u001e:j]\u001eT1!a?u\u0011\u001d\u0011)\u0001\u0005a\u0001\u0005\u000f\t!\"Y2u_J\u001cE.Y:ta\u0011\u0011IAa\u0005\u0011\r\u0005U(1\u0002B\b\u0013\u0011\u0011iA!\u0001\u0003\u000b\rc\u0017m]:\u0011\t\tE!1\u0003\u0007\u0001\t1\u0011)Ba\u0001\u0002\u0002\u0003\u0005)\u0011\u0001B\f\u0005\ryF%M\t\u0005\u00053\t\t\u0002E\u0002t\u00057I1A!\bu\u0005\u001dqu\u000e\u001e5j]\u001eDq!a#\u0011\u0001\u0004\ti\tC\u0004\u0002\u001cB\u0001\r!!$\t\u000f\t\u0015\u0002\u00031\u0001\u0002t\u0006Q1/_:uK6t\u0015-\\3\u0003\u001bQ\u0013\u0018mY3e\u001b>t\u0017\u000e^8s'\u0011\t\"/a!\u0002\u0017M$\u0018M\u001d;t)J\f7-Z\u0001\b[>t\u0017\u000e^8s)!\u0011\tD!\u000e\u00038\te\u0002c\u0001B\u001a#5\t1\u0002C\u0004\u0002.V\u0001\r!a,\t\u000f\t-R\u00031\u0001\u0002:\"9!QF\u000bA\u0002\u0005\rE\u0003CA\t\u0005{\u0011yD!\u0011\t\u000buL\u0002\u0019\u0001>\t\u000f\u0005m\u0011\u00041\u0001\u0002\u0006!9\u0011qD\rA\u0002\u0005\u0005BCCA\u001a\u0005\u000b\u00129E!\u0013\u0003L!)QP\u0007a\u0001u\"9\u00111\u0004\u000eA\u0002\u0005\u0015\u0001bBA 5\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u0007R\u0002\u0019AA\t)\u0011\t\u0019Da\u0014\t\u000f\u0005-3\u00041\u0001\u0002NQ!\u00111\u0007B*\u0011\u001d\tY\u0007\ba\u0001\u0003\u000b\t1#\u001a=ue\u0006\u001cG/T3tg\u0006<Wm\u00117bgN$B!a=\u0003Z!9\u0011qD\u0010A\u0002\u0005\u0005\u0012!\u00032vS2$7\u000b]1o))\u0011yFa\u001d\u0003v\t]$\u0011\u0010\t\u0005\u0005C\u0012iG\u0004\u0003\u0003d\t%TB\u0001B3\u0015\r\u00119G\\\u0001\u0006iJ\f7-Z\u0005\u0005\u0005W\u0012)'\u0001\u0003Ta\u0006t\u0017\u0002\u0002B8\u0005c\u0012q\u0001R3mCf,GM\u0003\u0003\u0003l\t\u0015\u0004bBAWA\u0001\u0007\u0011q\u0016\u0005\u0006{\u0002\u0002\rA\u001f\u0005\b\u00037\u0001\u0003\u0019AA\u0003\u0011\u001d\ty\u0002\ta\u0001\u0003C\tQb\u001c9fe\u0006$\u0018n\u001c8OC6,GCBAz\u0005\u007f\u0012\u0019\tC\u0004\u0003\u0002\u0006\u0002\r!a=\u0002\u00195,7o]1hK\u000ec\u0017m]:\t\u000f\t\u0015\u0015\u00051\u0001\u0002\u000e\u000611/\u001a8eKJ\u00141c\u00159b]\u0006sG-T8oSR|'o\u0015;bi\u0016\u001c\"A\t:\u0002\tM\u0004\u0018M\\\u000b\u0003\u0005\u001f\u0003BAa\u0019\u0003\u0012&!!1\u0013B3\u0005\u0011\u0019\u0006/\u00198\u0002\u000bM\u0004\u0018M\u001c\u0011\u0002']\u0014\u0018\r\u001d9fI6{g.\u001b;peN#\u0018\r^3\u0016\u0005\u0005E\u0011\u0001F<sCB\u0004X\rZ'p]&$xN]*uCR,\u0007\u0005\u0006\u0004\u0003 \n\r&Q\u0015\t\u0004\u0005C\u0013S\"A\t\t\u000f\t-u\u00051\u0001\u0003\u0010\"9!qS\u0014A\u0002\u0005E!AF\"p]R,\u0007\u0010\u001e)s_B\fw-\u0019;j_:|e\u000e\\=\u0014\t!\u0012\u00181Q\u0001\u0012iJ\f7m[!di&4X-Q2u_J\u001cH\u0003\u0003BX\u0005c\u0013\u0019L!.\u0011\u0007\tM\u0002\u0006C\u0004\u0002.2\u0002\r!a,\t\u000f\u0005\u0005G\u00061\u0001\u0002:\"9!1\u0016\u0017A\u0002\u0005e\u0016AD0tsN$X-\\'fiJL7m]\u000b\u0003\u0005w\u0003BA!0\u0003B:!!qXAo\u001b\u0005Q\u0017\u0002\u0002Bb\u0003K\u0014a#Q2u_J\u001c\u0016p\u001d;f[&s7\u000f\u001e:v[\u0016tGo]\u0001\u0010?NL8\u000f^3n\u001b\u0016$(/[2tAQA\u0011\u0011\u0003Be\u0005\u0017\u0014i\rC\u0003~e\u0001\u0007!\u0010C\u0004\u0002\u001cI\u0002\r!!\u0002\t\u000f\u0005}!\u00071\u0001\u0002\"QQ\u00111\u0007Bi\u0005'\u0014)Na6\t\u000bu\u001c\u0004\u0019\u0001>\t\u000f\u0005m1\u00071\u0001\u0002\u0006!9\u0011qH\u001aA\u0002\u0005\u0015\u0001bBA\"g\u0001\u0007\u0011\u0011\u0003\u000b\u0005\u0003g\u0011Y\u000eC\u0004\u0002LQ\u0002\r!!\u0014\u0015\t\u0005M\"q\u001c\u0005\b\u0003W*\u0004\u0019AA\u0003\u00051!&/Y2lK\u0012\f5\r^8s'\rA$Q\u001d\t\u0004\u0005g\u0011&!G$s_V\u0004X*\u001a;sS\u000e\u001cHK]1dW&tw-Q2u_J\u001cBA\u0015:\u0002\u0004R1!Q\u001dBw\u0005_Dq!!2V\u0001\u0004\t9\rC\u0004\u0002.V\u0003\r!a,\u0002\u0011}K7/\u00117jm\u0016,\"!!/\u0002\u0019}K7/\u00117jm\u0016|F%Z9\u0015\t\u0005M\"\u0011 \u0005\n\u0005w<\u0016\u0011!a\u0001\u0003s\u000b1\u0001\u001f\u00132\u0003%y\u0016n]!mSZ,\u0007\u0005K\u0002Y\u0007\u0003\u00012a]B\u0002\u0013\r\u0019)\u0001\u001e\u0002\tm>d\u0017\r^5mK\u0006Arl\u001d5pk2$GK]1dW\u0006\u001bG/\u001b<f\u0003\u000e$xN]:\u00023}\u001b\bn\\;mIR\u0013\u0018mY6BGRLg/Z!di>\u00148\u000fI\u0001\u0006G2|7m[\u000b\u0003\u0007\u001f\u0001Ba!\u0005\u0004\u00185\u001111\u0003\u0006\u0004\u0007+q\u0017\u0001B;uS2LAa!\u0007\u0004\u0014\t)1\t\\8dW\u000611\r\\8dW\u0002\nQb]=ti\u0016lW*\u001a;sS\u000e\u001c\u0018AD:zgR,W.T3ue&\u001c7\u000f\t\u000b\u0005\u0003g\u0019\u0019\u0003C\u0004\u0002L\t\u0004\r!!\u0014\u0015\t\u0005M2q\u0005\u0005\b\u0003W\u001a\u0007\u0019AA\u0003\u0003I\u0011XmY8sI\u001e\u0013x.\u001e9NKR\u0014\u0018nY:\u0015\r\u0005M2QFB\u0019\u0011\u001d\u0019y\u0003\u001aa\u0001\u0003\u000b\ta\u0002\u001d:pG\u0016\u001c8/\u001b8h)&lW\rC\u0004\u00044\u0011\u0004\r!!\u0002\u0002\u001bQLW.Z%o\u001b\u0006LGNY8y\u00031\t7\r^8s\u001b\u0016$(/[2t!\u0015\u00198\u0011HB\u001f\u0013\r\u0019Y\u0004\u001e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=7qH\u0005\u0005\u0007\u0003\n)O\u0001\tBGR|'/\u00138tiJ,X.\u001a8ugRA1QIB$\u0007\u0013\u001aY\u0005E\u0002\u00034aBqa!\u000e=\u0001\u0004\u00199\u0004C\u0004\u0002Fr\u0002\r!a2\t\u000f\u00055F\b1\u0001\u00020\u0006Ir\f\u001d:pG\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3t\u0007>,h\u000e^3s+\t\u0019\t\u0006\u0005\u0003\u0004T\reSBAB+\u0015\r\u00199F\\\u0001\u0007[\u0016$(/[2\n\t\rm3Q\u000b\u0002\b\u0007>,h\u000e^3s\u0003iy\u0006O]8dKN\u001cX\rZ'fgN\fw-Z:D_VtG/\u001a:!)!\t\tb!\u0019\u0004d\r\u0015\u0004\"B?B\u0001\u0004Q\bbBA\u000e\u0003\u0002\u0007\u0011Q\u0001\u0005\b\u0003?\t\u0005\u0019AA\u0011))\t\u0019d!\u001b\u0004l\r54q\u000e\u0005\u0006{\n\u0003\rA\u001f\u0005\b\u00037\u0011\u0005\u0019AA\u0003\u0011\u001d\tyD\u0011a\u0001\u0003\u000bAq!a\u0011C\u0001\u0004\t\t\u0002\u0006\u0003\u00024\rM\u0004bBA&\u0007\u0002\u0007\u0011Q\n\u0002\u000e)J\f7m[3e%>,H/Z3\u0014\u0007\u0015\u0013)/A\u0007s_V$XM]'fiJL7m\u001d\t\u0005\u0003\u001f\u001ci(\u0003\u0003\u0004\u0000\u0005\u0015(!\u0005*pkR,'/\u00138tiJ,X.\u001a8ugRA11QBC\u0007\u000f\u001bI\tE\u0002\u00034\u0015Cqa!\u001fJ\u0001\u0004\u0019Y\bC\u0004\u0002F&\u0003\r!a2\t\u000f\u00055\u0016\n1\u0001\u00020\u0006A\u0002O]8dKN\u001cX\rZ'fgN\fw-Z:D_VtG/\u001a:\u00023A\u0014xnY3tg\u0016$W*Z:tC\u001e,7oQ8v]R,'\u000f\t\u000b\t\u0003#\u0019\tja%\u0004\u0016\")Q0\u0014a\u0001u\"9\u00111D'A\u0002\u0005\u0015\u0001bBA\u0010\u001b\u0002\u0007\u0011\u0011\u0005\u000b\u000b\u0003g\u0019Ija'\u0004\u001e\u000e}\u0005\"B?O\u0001\u0004Q\bbBA\u000e\u001d\u0002\u0007\u0011Q\u0001\u0005\b\u0003\u007fq\u0005\u0019AA\u0003\u0011\u001d\t\u0019E\u0014a\u0001\u0003#!B!a\r\u0004$\"9\u00111J(A\u0002\u00055C\u0003BA\u001a\u0007OCq!a\u001bQ\u0001\u0004\t)\u0001")
public interface ActorMonitor {
    public static ActorMonitor from(Object object, ActorRef actorRef, ActorRef actorRef2, ActorSystem actorSystem) {
        return ActorMonitor$.MODULE$.from(object, actorRef, actorRef2, actorSystem);
    }

    public Context captureEnvelopeContext();

    public long captureEnvelopeTimestamp();

    public long captureProcessingStartTimestamp();

    public Object onMessageProcessingStart(Context var1, long var2, Envelope var4);

    public void onMessageProcessingEnd(Context var1, long var2, long var4, Object var6);

    public void onFailure(Throwable var1);

    public void onDroppedMessages(long var1);

    public void onTerminationStart();

    public void cleanup();

    public static class ContextPropagationOnly
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean participatesInTracing;
        private final boolean trackActiveActors;
        private final AkkaMetrics.ActorSystemInstruments _systemMetrics;

        private AkkaMetrics.ActorSystemInstruments _systemMetrics() {
            return this._systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            if (this.participatesInTracing) {
                return Kamon$.MODULE$.clock().nanos();
            }
            return 0L;
        }

        @Override
        public Context captureEnvelopeContext() {
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            if (this.participatesInTracing) {
                return Kamon$.MODULE$.clock().nanos();
            }
            return 0L;
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._systemMetrics().processedMessagesByNonTracked().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            ((Storage.Scope)stateFromStart).close();
        }

        @Override
        public void onFailure(Throwable failure) {
        }

        @Override
        public void onDroppedMessages(long count) {
        }

        @Override
        public void onTerminationStart() {
        }

        @Override
        public void cleanup() {
            if (this.trackActiveActors && !this.cellInfo.isTemporary()) {
                this._systemMetrics().activeActors().decrement();
            }
        }

        public ContextPropagationOnly(ActorCellInfo cellInfo, boolean participatesInTracing, boolean trackActiveActors) {
            this.cellInfo = cellInfo;
            this.participatesInTracing = participatesInTracing;
            this.trackActiveActors = trackActiveActors;
            this._systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
            if (trackActiveActors && !cellInfo.isTemporary()) {
                this._systemMetrics().activeActors().increment();
            }
        }
    }

    public static abstract class GroupMetricsTrackingActor
    implements ActorMonitor {
        private final Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics;
        private final ActorCellInfo cellInfo;
        private volatile boolean _isAlive;
        private final boolean _shouldTrackActiveActors;
        private final Clock clock;
        private final AkkaMetrics.ActorSystemInstruments systemMetrics;

        private boolean _isAlive() {
            return this._isAlive;
        }

        private void _isAlive_$eq(boolean x$1) {
            this._isAlive = x$1;
        }

        private boolean _shouldTrackActiveActors() {
            return this._shouldTrackActiveActors;
        }

        public Clock clock() {
            return this.clock;
        }

        public AkkaMetrics.ActorSystemInstruments systemMetrics() {
            return this.systemMetrics;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public Context captureEnvelopeContext() {
            if (this._isAlive() && !this.cellInfo.isTemporary()) {
                this.groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> gm.pendingMessages().increment());
            }
            return Kamon$.MODULE$.currentContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.clock().nanos();
        }

        @Override
        public void onFailure(Throwable failure) {
            this.groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> gm.errors().increment());
        }

        @Override
        public void onDroppedMessages(long count) {
            this.groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> gm.pendingMessages().decrement(count));
        }

        public void recordGroupMetrics(long processingTime, long timeInMailbox) {
            this.groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> {
                gm.processingTime().record(processingTime);
                gm.timeInMailbox().record(timeInMailbox);
                return gm.pendingMessages().decrement();
            });
        }

        @Override
        public void onTerminationStart() {
            this._isAlive_$eq(false);
        }

        @Override
        public void cleanup() {
            if (this._shouldTrackActiveActors()) {
                this.systemMetrics().activeActors().decrement();
                this.groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> gm.members().decrement());
            }
        }

        public GroupMetricsTrackingActor(Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.groupMetrics = groupMetrics;
            this.cellInfo = cellInfo;
            this._isAlive = true;
            this._shouldTrackActiveActors = !cellInfo.isTemporary();
            this.clock = Kamon$.MODULE$.clock();
            this.systemMetrics = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName());
            if (this._shouldTrackActiveActors()) {
                this.systemMetrics().activeActors().increment();
                groupMetrics.foreach((Function1 & Serializable & scala.Serializable)gm -> gm.members().increment());
            }
        }
    }

    public static class TracedMonitor
    implements ActorMonitor {
        private final ActorCellInfo cellInfo;
        private final boolean startsTrace;
        private final ActorMonitor monitor;

        @Override
        public long captureEnvelopeTimestamp() {
            return this.monitor.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            return this.monitor.captureEnvelopeContext();
        }

        @Override
        public long captureProcessingStartTimestamp() {
            return this.monitor.captureProcessingStartTimestamp();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            if (((Span)context.get(Span$.MODULE$.Key())).isEmpty() && !this.startsTrace) {
                return new SpanAndMonitorState(this, null, this.monitor.onMessageProcessingStart(context, envelopeTimestamp, envelope));
            }
            Span.Delayed messageSpan = this.buildSpan(this.cellInfo, context, envelopeTimestamp, envelope).start();
            Context contextWithMessageSpan = context.withEntry(Span$.MODULE$.Key(), (Object)messageSpan);
            return new SpanAndMonitorState(this, (Span)messageSpan, this.monitor.onMessageProcessingStart(contextWithMessageSpan, envelopeTimestamp, envelope));
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            SpanAndMonitorState spanAndMonitor = (SpanAndMonitorState)stateFromStart;
            this.monitor.onMessageProcessingEnd(context, envelopeTimestamp, processingStartTimestamp, spanAndMonitor.wrappedMonitorState());
            if (spanAndMonitor.span() != null) {
                spanAndMonitor.span().finish();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.monitor.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            this.monitor.onDroppedMessages(count);
        }

        @Override
        public void onTerminationStart() {
            this.monitor.onTerminationStart();
        }

        @Override
        public void cleanup() {
            this.monitor.cleanup();
        }

        private String extractMessageClass(Envelope envelope) {
            return ActorCellInfo$.MODULE$.simpleClassName(envelope.message().getClass());
        }

        private Span.Delayed buildSpan(ActorCellInfo cellInfo, Context context, long envelopeTimestamp, Envelope envelope) {
            String messageClass = this.extractMessageClass(envelope);
            Span parentSpan = (Span)context.get(Span$.MODULE$.Key());
            SpanBuilder spanBuilder = Kamon$.MODULE$.internalSpanBuilder(this.operationName(messageClass, envelope.sender()), "akka.actor").asChildOf(parentSpan).doNotTrackMetrics().tag("akka.system", cellInfo.systemName()).tag("akka.actor.path", cellInfo.path()).tag("akka.actor.message-class", messageClass);
            if (!ActorCellInfo$.MODULE$.isTyped(cellInfo.actorOrRouterClass())) {
                spanBuilder.tag("akka.actor.class", cellInfo.actorOrRouterClass().getName());
            }
            return spanBuilder.delay(Kamon$.MODULE$.clock().toInstant(envelopeTimestamp));
        }

        private String operationName(String messageClass, ActorRef sender) {
            String operationType = AkkaPrivateAccess.isPromiseActorRef(sender) ? "ask" : "tell";
            return package$.MODULE$.StringBuilder().newBuilder().append(operationType).append("(").append(messageClass).append(")").result();
        }

        public TracedMonitor(ActorCellInfo cellInfo, boolean startsTrace, ActorMonitor monitor) {
            this.cellInfo = cellInfo;
            this.startsTrace = startsTrace;
            this.monitor = monitor;
        }

        public class SpanAndMonitorState {
            private final Span span;
            private final Object wrappedMonitorState;
            public final /* synthetic */ TracedMonitor $outer;

            public Span span() {
                return this.span;
            }

            public Object wrappedMonitorState() {
                return this.wrappedMonitorState;
            }

            public /* synthetic */ TracedMonitor kamon$instrumentation$akka$instrumentations$ActorMonitor$TracedMonitor$SpanAndMonitorState$$$outer() {
                return this.$outer;
            }

            public SpanAndMonitorState(TracedMonitor $outer, Span span, Object wrappedMonitorState) {
                this.span = span;
                this.wrappedMonitorState = wrappedMonitorState;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }

    public static class TrackedActor
    extends GroupMetricsTrackingActor {
        private final Option<AkkaMetrics.ActorInstruments> actorMetrics;
        private final Counter _processedMessagesCounter;

        private Counter _processedMessagesCounter() {
            return this._processedMessagesCounter;
        }

        @Override
        public long captureEnvelopeTimestamp() {
            return super.captureEnvelopeTimestamp();
        }

        @Override
        public Context captureEnvelopeContext() {
            this.actorMetrics.foreach((Function1 & Serializable & scala.Serializable)am -> am.mailboxSize().increment());
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this._processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = this.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.actorMetrics.foreach((Function1 & Serializable & scala.Serializable)am -> {
                    am.processingTime().record(processingTime);
                    am.timeInMailbox().record(timeInMailbox);
                    return am.mailboxSize().decrement();
                });
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.actorMetrics.foreach((Function1 & Serializable & scala.Serializable)am -> am.errors().increment());
            super.onFailure(failure);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.actorMetrics.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.remove();
                return BoxedUnit.UNIT;
            });
        }

        public TrackedActor(Option<AkkaMetrics.ActorInstruments> actorMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.actorMetrics = actorMetrics;
            super(groupMetrics, cellInfo);
            this._processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }

    public static class TrackedRoutee
    extends GroupMetricsTrackingActor {
        private final AkkaMetrics.RouterInstruments routerMetrics;
        private final Counter processedMessagesCounter;

        private Counter processedMessagesCounter() {
            return this.processedMessagesCounter;
        }

        @Override
        public Context captureEnvelopeContext() {
            this.routerMetrics.pendingMessages().increment();
            return super.captureEnvelopeContext();
        }

        @Override
        public Object onMessageProcessingStart(Context context, long envelopeTimestamp, Envelope envelope) {
            this.processedMessagesCounter().increment();
            return Kamon$.MODULE$.storeContext(context);
        }

        @Override
        public void onMessageProcessingEnd(Context context, long envelopeTimestamp, long processingStartTimestamp, Object stateFromStart) {
            try {
                ((Storage.Scope)stateFromStart).close();
            }
            finally {
                long timestampAfterProcessing = Kamon$.MODULE$.clock().nanos();
                long timeInMailbox = processingStartTimestamp - envelopeTimestamp;
                long processingTime = timestampAfterProcessing - processingStartTimestamp;
                this.routerMetrics.processingTime().record(processingTime);
                this.routerMetrics.timeInMailbox().record(timeInMailbox);
                this.routerMetrics.pendingMessages().decrement();
                this.recordGroupMetrics(processingTime, timeInMailbox);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
            super.onFailure(failure);
        }

        @Override
        public void onDroppedMessages(long count) {
            super.onDroppedMessages(count);
            this.routerMetrics.pendingMessages().decrement(count);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.routerMetrics.members().decrement();
        }

        public TrackedRoutee(AkkaMetrics.RouterInstruments routerMetrics, Seq<AkkaMetrics.ActorGroupInstruments> groupMetrics, ActorCellInfo cellInfo) {
            this.routerMetrics = routerMetrics;
            super(groupMetrics, cellInfo);
            routerMetrics.members().increment();
            this.processedMessagesCounter = AkkaMetrics$.MODULE$.forSystem(cellInfo.systemName()).processedMessagesByTracked();
        }
    }
}

