/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.system.host;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kamon.Kamon$;
import kamon.instrumentation.system.host.HostMetrics;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.ScheduledAction;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kamon.util.Filter;
import kamon.util.Filter$;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;
import scala.Array$;
import scala.Function1;
import scala.Product;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.concurrent.ExecutionContext;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rmf\u0001B2e\u00015D\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\t\u0011%\t\u0019\u0003\u0001a\u0001\n\u0013\t)\u0003C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011\t\u0001!B\u0013\t9\u0003C\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002F!I!\u0011\n\u0001A\u0002\u0013%!1\n\u0005\t\u0005\u001f\u0002\u0001\u0015)\u0003\u0002H!I!\u0011\f\u0001C\u0002\u0013%!1\f\u0005\t\u0007'\u0001\u0001\u0015!\u0003\u0003^!I1Q\u0003\u0001C\u0002\u0013%1q\u0003\u0005\t\u0007+\u0003\u0001\u0015!\u0003\u0004\u001a!9!1\u000e\u0001\u0005B\t5\u0004bBBL\u0001\u0011\u0005#Q\u000e\u0005\b\u00073\u0003A\u0011IBN\u0011\u001d\u0019)\f\u0001C\u0005\u0007o3\u0011Ba\u001a\u0001!\u0003\r\nA!\u001b\t\u000f\t-4C\"\u0001\u0003n!9!qN\n\u0007\u0002\t5dA\u0002B1\u0001\u0011\u0011\u0019\u0007C\u0004\u0002\u0004Y!\tA!\u001d\t\u0013\tMdC1A\u0005\n\tU\u0004\u0002\u0003BB-\u0001\u0006IAa\u001e\t\u0013\t\u0015eC1A\u0005\n\t\u001d\u0005\u0002\u0003BK-\u0001\u0006IA!#\t\u0013\t]eC1A\u0005\n\te\u0005\u0002\u0003BT-\u0001\u0006IAa'\t\u0013\t%fC1A\u0005\n\t-\u0006\u0002\u0003Bi-\u0001\u0006IA!,\t\u0013\tMg\u00031A\u0005\n\tU\u0007\"\u0003Br-\u0001\u0007I\u0011\u0002Bs\u0011!\u0011IO\u0006Q!\n\t]\u0007b\u0002B6-\u0011\u0005!Q\u000e\u0005\b\u0005_2B\u0011\u0001B7\u0011\u001d\u0011YO\u0006C\u0005\u0005[BqA!<\u0017\t\u0013\u0011yO\u0002\u0004\u0004\u001c\u0001!1Q\u0004\u0005\b\u0003\u00079C\u0011AB\u0010\u0011%\u0011\u0019h\nb\u0001\n\u0013\u0011)\b\u0003\u0005\u0003\u0004\u001e\u0002\u000b\u0011\u0002B<\u0011%\u0011)i\nb\u0001\n\u0013\u00119\t\u0003\u0005\u0003\u0016\u001e\u0002\u000b\u0011\u0002BE\u0011%\u00119j\nb\u0001\n\u0013\u0011I\n\u0003\u0005\u0003(\u001e\u0002\u000b\u0011\u0002BN\u0011%\u0019\tc\nb\u0001\n\u0013\u0019\u0019\u0003\u0003\u0005\u00046\u001d\u0002\u000b\u0011BB\u0013\u0011%\u00199d\nb\u0001\n\u0013\u0019I\u0004\u0003\u0005\u0004B\u001d\u0002\u000b\u0011BB\u001e\u0011%\u0019\u0019e\nb\u0001\n\u0013\u0019)\u0005\u0003\u0005\u0004N\u001d\u0002\u000b\u0011BB$\u0011%\u0019ye\nb\u0001\n\u0013\u0019\t\u0006\u0003\u0005\u0004Z\u001d\u0002\u000b\u0011BB*\u0011%\u0019Yf\nb\u0001\n\u0013\u0019i\u0006\u0003\u0005\u0004f\u001d\u0002\u000b\u0011BB0\u0011%\u00199g\nb\u0001\n\u0013\u0019I\u0007\u0003\u0005\u0004r\u001d\u0002\u000b\u0011BB6\u0011%\u0019\u0019h\nb\u0001\n\u0013\u0019)\b\u0003\u0005\u0004~\u001d\u0002\u000b\u0011BB<\u0011\u001d\u0011Yg\nC\u0001\u0005[BqAa\u001c(\t\u0003\u0011i\u0007C\u0004\u0004\u0000\u001d\"IA!\u001c\t\u000f\r\u0005u\u0005\"\u0003\u0003n!911Q\u0014\u0005\n\t5\u0004bBBCO\u0011%1q\u0011\u0005\b\u0007#;C\u0011\u0002B7\u0011\u001d\u0019\u0019j\nC\u0005\u0005[:q!a\u0013e\u0011\u0003\tiE\u0002\u0004dI\"\u0005\u0011q\n\u0005\b\u0003\u00071E\u0011AA)\r\u0019\t\u0019F\u0012\u0001\u0002V!9\u00111\u0001%\u0005\u0002\u0005u\u0003bBA2\u0011\u0012\u0005\u0013Q\r\u0004\u0007\u0003w2\u0005)a \t\u0015\u000555J!f\u0001\n\u0003\ty\t\u0003\u0006\u0002\u001e.\u0013\t\u0012)A\u0005\u0003#C!\"a(L\u0005+\u0007I\u0011AAH\u0011)\t\tk\u0013B\tB\u0003%\u0011\u0011\u0013\u0005\b\u0003\u0007YE\u0011AAR\u0011%\tYkSA\u0001\n\u0003\ti\u000bC\u0005\u00024.\u000b\n\u0011\"\u0001\u00026\"I\u00111Z&\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003\u001b\\\u0015\u0011!C!\u0003\u001fA\u0011\"a4L\u0003\u0003%\t!!5\t\u0013\u0005e7*!A\u0005\u0002\u0005m\u0007\"CAs\u0017\u0006\u0005I\u0011IAt\u0011%\t)pSA\u0001\n\u0003\t9\u0010C\u0005\u0003\u0002-\u000b\t\u0011\"\u0011\u0003\u0004!I!QA&\u0002\u0002\u0013\u0005#q\u0001\u0005\n\u0005\u0013Y\u0015\u0011!C!\u0005\u00179\u0011Ba\u0004G\u0003\u0003E\tA!\u0005\u0007\u0013\u0005md)!A\t\u0002\tM\u0001bBA\u0002;\u0012\u0005!\u0011\u0005\u0005\n\u0005\u000bi\u0016\u0011!C#\u0005\u000fA\u0011Ba\t^\u0003\u0003%\tI!\n\t\u0013\t-R,!A\u0005\u0002\n5\u0002\"\u0003B ;\u0006\u0005I\u0011\u0002B!\u0005QAun\u001d;NKR\u0014\u0018nY:D_2dWm\u0019;pe*\u0011QMZ\u0001\u0005Q>\u001cHO\u0003\u0002hQ\u000611/_:uK6T!!\u001b6\u0002\u001f%t7\u000f\u001e:v[\u0016tG/\u0019;j_:T\u0011a[\u0001\u0006W\u0006lwN\\\u0002\u0001'\r\u0001a\u000e\u001e\t\u0003_Jl\u0011\u0001\u001d\u0006\u0002c\u0006)1oY1mC&\u00111\u000f\u001d\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UDX\"\u0001<\u000b\u0005]T\u0017AB7pIVdW-\u0003\u0002zm\ny1k\u00195fIVdW\rZ!di&|g.\u0001\u0002fGB\u0011Ap`\u0007\u0002{*\u0011a\u0010]\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0001{\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u001d\u00111\u0002\t\u0004\u0003\u0013\u0001Q\"\u00013\t\u000bi\u0014\u0001\u0019A>\u0002\u0017}\u001bwN\u001c4jOB\u000bG\u000f[\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019}\u001bwN\u001c4jOB\u000bG\u000f\u001b\u0011\u0002'}c\u0017m\u001d;J]\u001a\u0014X-];f]R$\u0016nY6\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\t\u00055\u0012\u0011D\u0001\u0005i&lW-\u0003\u0003\u00022\u0005-\"aB%ogR\fg\u000e^\u0001\u0018?2\f7\u000f^%oMJ,\u0017/^3oiRK7m[0%KF$B!a\u000e\u0002>A\u0019q.!\u000f\n\u0007\u0005m\u0002O\u0001\u0003V]&$\b\"CA \r\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\u0015?2\f7\u000f^%oMJ,\u0017/^3oiRK7m\u001b\u0011\u0002\u0013}\u001bX\r\u001e;j]\u001e\u001cXCAA$!\r\tIe\u0013\b\u0004\u0003\u0013)\u0015\u0001\u0006%pgRlU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fE\u0002\u0002\n\u0019\u001b\"A\u00128\u0015\u0005\u00055#a\u0002$bGR|'/_\n\u0005\u0011:\f9\u0006E\u0002v\u00033J1!a\u0017w\u00055iu\u000eZ;mK\u001a\u000b7\r^8ssR\u0011\u0011q\f\t\u0004\u0003CBU\"\u0001$\u0002\r\r\u0014X-\u0019;f)\u0011\t9'!\u001c\u0011\u0007U\fI'C\u0002\u0002lY\u0014a!T8ek2,\u0007bBA8\u0015\u0002\u0007\u0011\u0011O\u0001\tg\u0016$H/\u001b8hgB!\u00111OA=\u001d\r)\u0018QO\u0005\u0004\u0003o2\u0018!D'pIVdWMR1di>\u0014\u00180\u0003\u0003\u0002|\u0005u$\u0001C*fiRLgnZ:\u000b\u0007\u0005]do\u0005\u0004L]\u0006\u0005\u0015q\u0011\t\u0004_\u0006\r\u0015bAACa\n9\u0001K]8ek\u000e$\bcA8\u0002\n&\u0019\u00111\u00129\u0003\u0019M+'/[1mSj\f'\r\\3\u0002#Q\u0014\u0018mY6fI&sG/\u001a:gC\u000e,7/\u0006\u0002\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018*\fA!\u001e;jY&!\u00111TAK\u0005\u00191\u0015\u000e\u001c;fe\u0006\u0011BO]1dW\u0016$\u0017J\u001c;fe\u001a\f7-Z:!\u00035!(/Y2lK\u0012lu.\u001e8ug\u0006qAO]1dW\u0016$Wj\\;oiN\u0004CCBAS\u0003O\u000bI\u000bE\u0002\u0002b-Cq!!$Q\u0001\u0004\t\t\nC\u0004\u0002 B\u0003\r!!%\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003K\u000by+!-\t\u0013\u00055\u0015\u000b%AA\u0002\u0005E\u0005\"CAP#B\u0005\t\u0019AAI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a.+\t\u0005E\u0015\u0011X\u0016\u0003\u0003w\u0003B!!0\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u00199\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0006}&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002TB\u0019q.!6\n\u0007\u0005]\u0007OA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002^\u0006\r\bcA8\u0002`&\u0019\u0011\u0011\u001d9\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002@Y\u000b\t\u00111\u0001\u0002T\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jB1\u00111^Ay\u0003;l!!!<\u000b\u0007\u0005=\b/\u0001\u0006d_2dWm\u0019;j_:LA!a=\u0002n\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI0a@\u0011\u0007=\fY0C\u0002\u0002~B\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002@a\u000b\t\u00111\u0001\u0002^\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002T\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0012\u00051Q-];bYN$B!!?\u0003\u000e!I\u0011qH.\u0002\u0002\u0003\u0007\u0011Q\\\u0001\t'\u0016$H/\u001b8hgB\u0019\u0011\u0011M/\u0014\u000bu\u0013)\"a\"\u0011\u0015\t]!QDAI\u0003#\u000b)+\u0004\u0002\u0003\u001a)\u0019!1\u00049\u0002\u000fI,h\u000e^5nK&!!q\u0004B\r\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005#\tQ!\u00199qYf$b!!*\u0003(\t%\u0002bBAGA\u0002\u0007\u0011\u0011\u0013\u0005\b\u0003?\u0003\u0007\u0019AAI\u0003\u001d)h.\u00199qYf$BAa\f\u0003<A)qN!\r\u00036%\u0019!1\u00079\u0003\r=\u0003H/[8o!\u001dy'qGAI\u0003#K1A!\u000fq\u0005\u0019!V\u000f\u001d7fe!I!QH1\u0002\u0002\u0003\u0007\u0011QU\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0011\u0011\t\u0005M!QI\u0005\u0005\u0005\u000f\n)B\u0001\u0004PE*,7\r^\u0001\u000e?N,G\u000f^5oON|F%Z9\u0015\t\u0005]\"Q\n\u0005\n\u0003\u007fI\u0011\u0011!a\u0001\u0003\u000f\n!bX:fiRLgnZ:!Q\rQ!1\u000b\t\u0004_\nU\u0013b\u0001B,a\nAao\u001c7bi&dW-\u0001\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014XC\u0001B/!\r\u0011yFF\u0007\u0002\u0001\t1bI]3rk\u0016tGoQ8mY\u0016\u001cG/[8o)\u0006\u001c8n\u0005\u0003\u0017]\n\u0015\u0004c\u0001B0'\tq1i\u001c7mK\u000e$\u0018n\u001c8UCN\\7CA\no\u0003\r\u0011XO\u001c\u000b\u0003\u0003o\tqa\u00197fC:,\b\u000f\u0006\u0002\u0003^\u0005aq\fZ3gCVdG\u000fV1hgV\u0011!q\u000f\t\u0005\u0005s\u0012y(\u0004\u0002\u0003|)\u0019!Q\u00106\u0002\u0007Q\fw-\u0003\u0003\u0003\u0002\nm$A\u0002+bON+G/A\u0007`I\u00164\u0017-\u001e7u)\u0006<7\u000fI\u0001\f?NL8\u000f^3n\u0013:4w.\u0006\u0002\u0003\nB!!1\u0012BI\u001b\t\u0011iI\u0003\u0002\u0003\u0010\u0006!qn\u001d5j\u0013\u0011\u0011\u0019J!$\u0003\u0015MK8\u000f^3n\u0013:4w.\u0001\u0007`gf\u001cH/Z7J]\u001a|\u0007%\u0001\u0003`Q\u0006dWC\u0001BN!\u0011\u0011iJa)\u000e\u0005\t}%\u0002\u0002BQ\u0005\u001b\u000b\u0001\u0002[1sI^\f'/Z\u0005\u0005\u0005K\u0013yJ\u0001\rICJ$w/\u0019:f\u0003\n\u001cHO]1di&|g\u000eT1zKJ\fQa\u00185bY\u0002\nqbX2qk&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0005[\u0003BAa,\u0003L:!!\u0011\u0017Bd\u001d\u0011\u0011\u0019L!2\u000f\t\tU&1\u0019\b\u0005\u0005o\u0013\tM\u0004\u0003\u0003:\n}VB\u0001B^\u0015\r\u0011i\f\\\u0001\u0007yI|w\u000e\u001e \n\u0003-L!!\u001b6\n\u0005\u001dD\u0017BA3g\u0013\r\u0011I\rZ\u0001\f\u0011>\u001cH/T3ue&\u001c7/\u0003\u0003\u0003N\n='AD\"qk&s7\u000f\u001e:v[\u0016tGo\u001d\u0006\u0004\u0005\u0013$\u0017\u0001E0daVLen\u001d;sk6,g\u000e^:!\u0003Ey\u0006O]3w\u0007B,Hj\\1e)&\u001c7n]\u000b\u0003\u0005/\u0004Ra\u001cBm\u0005;L1Aa7q\u0005\u0015\t%O]1z!\ry'q\\\u0005\u0004\u0005C\u0004(\u0001\u0002'p]\u001e\fQc\u00189sKZ\u001c\u0005/\u001e'pC\u0012$\u0016nY6t?\u0012*\u0017\u000f\u0006\u0003\u00028\t\u001d\b\"CA C\u0005\u0005\t\u0019\u0001Bl\u0003Iy\u0006O]3w\u0007B,Hj\\1e)&\u001c7n\u001d\u0011\u0002\u001dI,7m\u001c:e\u0007B,Xk]1hK\u0006IA/[2lg\u0012KgM\u001a\u000b\t\u0005;\u0014\tP!>\u0003z\"9!1\u001f\u0014A\u0002\t]\u0017\u0001\u00039sKZLw.^:\t\u000f\t]h\u00051\u0001\u0003X\u000691-\u001e:sK:$\bb\u0002B~M\u0001\u0007!Q`\u0001\ti&\u001c7\u000eV=qKB!!q`B\u0007\u001d\u0011\u0019\ta!\u0003\u000f\t\r\r1q\u0001\b\u0005\u0005s\u001b)!\u0003\u0002\u0003\u0010&!!\u0011\u0015BG\u0013\u0011\u0019YAa(\u0002!\r+g\u000e\u001e:bYB\u0013xnY3tg>\u0014\u0018\u0002BB\b\u0007#\u0011\u0001\u0002V5dWRK\b/\u001a\u0006\u0005\u0007\u0017\u0011y*A\n`MJ,\u0017/^3oi\u000e{G\u000e\\3di>\u0014\b%\u0001\u000b`S:4'/Z9vK:$8i\u001c7mK\u000e$xN]\u000b\u0003\u00073\u00012Aa\u0018(\u0005aIeN\u001a:fcV,g\u000e^\"pY2,7\r^5p]R\u000b7o[\n\u0005O9\u0014)\u0007\u0006\u0002\u0004\u001a\u0005\u0019ql\\:\u0016\u0005\r\u0015\u0002\u0003BB\u0014\u0007ci!a!\u000b\u000b\t\r-2QF\u0001\u0003_NTAaa\f\u0003\u000e\u0006A1o\u001c4uo\u0006\u0014X-\u0003\u0003\u00044\r%\"aD(qKJ\fG/\u001b8h'f\u001cH/Z7\u0002\t}{7\u000fI\u0001\u0013?6,Wn\u001c:z\u0013:\u001cHO];nK:$8/\u0006\u0002\u0004<A!!qVB\u001f\u0013\u0011\u0019yDa4\u0003#5+Wn\u001c:z\u0013:\u001cHO];nK:$8/A\n`[\u0016lwN]=J]N$(/^7f]R\u001c\b%\u0001\t`g^\f\u0007/\u00138tiJ,X.\u001a8ugV\u00111q\t\t\u0005\u0005_\u001bI%\u0003\u0003\u0004L\t='aD*xCBLen\u001d;sk6,g\u000e^:\u0002#}\u001bx/\u00199J]N$(/^7f]R\u001c\b%A\f`Y>\fG-\u0011<fe\u0006<W-\u00138tiJ,X.\u001a8ugV\u001111\u000b\t\u0005\u0005_\u001b)&\u0003\u0003\u0004X\t='A\u0006'pC\u0012\fe/\u001a:bO\u0016Len\u001d;sk6,g\u000e^:\u00021}cw.\u00193Bm\u0016\u0014\u0018mZ3J]N$(/^7f]R\u001c\b%A\u000e`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo]\u000b\u0003\u0007?\u0002BAa,\u0004b%!11\rBh\u0005]\u0019Fo\u001c:bO\u0016lu.\u001e8u\u0013:\u001cHO];nK:$8/\u0001\u000f`M&dWmU=ti\u0016lWk]1hK&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002=}3\u0017\u000e\\3TsN$X-\\!di&4\u0018\u000e^=J]N$(/^7f]R\u001cXCAB6!\u0011\u0011yk!\u001c\n\t\r=$q\u001a\u0002\u0019'R|'/Y4f\t\u00164\u0018nY3J]N$(/^7f]R\u001c\u0018aH0gS2,7+_:uK6\f5\r^5wSRL\u0018J\\:ueVlWM\u001c;tA\u0005YrL\\3uo>\u00148.Q2uSZLG/_%ogR\u0014X/\\3oiN,\"aa\u001e\u0011\t\t=6\u0011P\u0005\u0005\u0007w\u0012yM\u0001\u000eOKR<xN]6BGRLg/\u001b;z\u0013:\u001cHO];nK:$8/\u0001\u000f`]\u0016$xo\u001c:l\u0003\u000e$\u0018N^5us&s7\u000f\u001e:v[\u0016tGo\u001d\u0011\u0002#I,7m\u001c:e\u001b\u0016lwN]=Vg\u0006<W-A\tsK\u000e|'\u000f\u001a'pC\u0012\fe/\u001a:bO\u0016\f!C]3d_J$7\u000b^8sC\u001e,Wk]1hK\u0006IAo\u001c)fe\u000e,g\u000e\u001e\u000b\u0007\u0005;\u001cIi!$\t\u000f\r-%\t1\u0001\u0003^\u0006)a/\u00197vK\"91q\u0012\"A\u0002\tu\u0017!\u0002;pi\u0006d\u0017!\u0006:fG>\u0014Hm\u0015;pe\u0006<W-Q2uSZLG/_\u0001\u0016e\u0016\u001cwN\u001d3OKR<xN]6BGRLg/\u001b;z\u0003Uy\u0016N\u001c4sKF,XM\u001c;D_2dWm\u0019;pe\u0002\nAa\u001d;pa\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0011\t9d!(\t\u000f\r}\u0015\u00031\u0001\u0004\"\u0006Ia.Z<D_:4\u0017n\u001a\t\u0005\u0007G\u001b\t,\u0004\u0002\u0004&*!1qUBU\u0003\u0019\u0019wN\u001c4jO*!11VBW\u0003!!\u0018\u0010]3tC\u001a,'BABX\u0003\r\u0019w.\\\u0005\u0005\u0007g\u001b)K\u0001\u0004D_:4\u0017nZ\u0001\re\u0016\fGmU3ui&twm\u001d\u000b\u0005\u0003\u000f\u001aI\fC\u0004\u0004(J\u0001\ra!)")
public class HostMetricsCollector
implements ScheduledAction {
    private final String _configPath;
    private Instant _lastInfrequentTick = Instant.now();
    private volatile Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings = this.readSettings(Kamon$.MODULE$.config());
    private final FrequentCollectionTask _frequentCollector = new FrequentCollectionTask();
    private final InfrequentCollectionTask _infrequentCollector = new InfrequentCollectionTask();

    private String _configPath() {
        return this._configPath;
    }

    private Instant _lastInfrequentTick() {
        return this._lastInfrequentTick;
    }

    private void _lastInfrequentTick_$eq(Instant x$1) {
        this._lastInfrequentTick = x$1;
    }

    public Settings kamon$instrumentation$system$host$HostMetricsCollector$$_settings() {
        return this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings;
    }

    private void kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(Settings x$1) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings = x$1;
    }

    private FrequentCollectionTask _frequentCollector() {
        return this._frequentCollector;
    }

    private InfrequentCollectionTask _infrequentCollector() {
        return this._infrequentCollector;
    }

    public void run() {
        this._frequentCollector().run();
        if (Duration.between(this._lastInfrequentTick(), Instant.now()).getSeconds() >= 10L) {
            this._infrequentCollector().run();
            this._lastInfrequentTick_$eq(Instant.now());
        }
    }

    public void stop() {
        this._frequentCollector().cleanup();
        this._infrequentCollector().cleanup();
    }

    public void reconfigure(Config newConfig) {
        this.kamon$instrumentation$system$host$HostMetricsCollector$$_settings_$eq(this.readSettings(newConfig));
    }

    private Settings readSettings(Config config) {
        Config hostConfig = config.getConfig(this._configPath());
        return new Settings(Filter$.MODULE$.from(hostConfig.getConfig("network.tracked-interfaces")), Filter$.MODULE$.from(hostConfig.getConfig("storage.tracked-mount-types")));
    }

    public HostMetricsCollector(ExecutionContext ec) {
        this._configPath = "kamon.instrumentation.system.host";
    }

    public interface CollectionTask {
        public void run();

        public void cleanup();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new HostMetricsCollector(settings.executionContext());
        }
    }

    public class FrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final HostMetrics.CpuInstruments _cpuInstruments;
        private long[] _prevCpuLoadTicks;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private HostMetrics.CpuInstruments _cpuInstruments() {
            return this._cpuInstruments;
        }

        private long[] _prevCpuLoadTicks() {
            return this._prevCpuLoadTicks;
        }

        private void _prevCpuLoadTicks_$eq(long[] x$1) {
            this._prevCpuLoadTicks = x$1;
        }

        @Override
        public void run() {
            this.recordCpuUsage();
        }

        @Override
        public void cleanup() {
            this._cpuInstruments().remove();
        }

        private void recordCpuUsage() {
            if (this._prevCpuLoadTicks().length > 0) {
                long[] previousTicks = this._prevCpuLoadTicks();
                long[] currentTicks = this._hal().getProcessor().getSystemCpuLoadTicks();
                long user = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.USER);
                long nice = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.NICE);
                long system = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SYSTEM);
                long idle = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IDLE);
                long iowait = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IOWAIT);
                long irq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.IRQ);
                long softirq = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.SOFTIRQ);
                long steal = this.ticksDiff(previousTicks, currentTicks, CentralProcessor.TickType.STEAL);
                long total = user + nice + system + idle + iowait + irq + softirq + steal;
                this._cpuInstruments().user().record(FrequentCollectionTask.toPercent$1(user, total));
                this._cpuInstruments().system().record(FrequentCollectionTask.toPercent$1(system, total));
                this._cpuInstruments().iowait().record(FrequentCollectionTask.toPercent$1(iowait, total));
                this._cpuInstruments().idle().record(FrequentCollectionTask.toPercent$1(idle, total));
                this._cpuInstruments().stolen().record(FrequentCollectionTask.toPercent$1(steal, total));
                this._cpuInstruments().combined().record(FrequentCollectionTask.toPercent$1(user + system + nice + iowait, total));
                this._prevCpuLoadTicks_$eq(currentTicks);
                return;
            }
            this._prevCpuLoadTicks_$eq(this._hal().getProcessor().getSystemCpuLoadTicks());
        }

        private long ticksDiff(long[] previous, long[] current, CentralProcessor.TickType tickType) {
            return package$.MODULE$.max(current[tickType.getIndex()] - previous[tickType.getIndex()], 0L);
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$FrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        private static final long toPercent$1(long value, long total$1) {
            return (long)(100.0 * (double)value / (double)total$1);
        }

        public FrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._cpuInstruments = new HostMetrics.CpuInstruments(this._defaultTags());
            this._prevCpuLoadTicks = (long[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Long());
        }
    }

    public class InfrequentCollectionTask
    implements CollectionTask {
        private final TagSet _defaultTags;
        private final SystemInfo _systemInfo;
        private final HardwareAbstractionLayer _hal;
        private final OperatingSystem _os;
        private final HostMetrics.MemoryInstruments _memoryInstruments;
        private final HostMetrics.SwapInstruments _swapInstruments;
        private final HostMetrics.LoadAverageInstruments _loadAverageInstruments;
        private final HostMetrics.StorageMountInstruments _fileSystemUsageInstruments;
        private final HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments;
        private final HostMetrics.NetworkActivityInstruments _networkActivityInstruments;

        private TagSet _defaultTags() {
            return this._defaultTags;
        }

        private SystemInfo _systemInfo() {
            return this._systemInfo;
        }

        private HardwareAbstractionLayer _hal() {
            return this._hal;
        }

        private OperatingSystem _os() {
            return this._os;
        }

        private HostMetrics.MemoryInstruments _memoryInstruments() {
            return this._memoryInstruments;
        }

        private HostMetrics.SwapInstruments _swapInstruments() {
            return this._swapInstruments;
        }

        private HostMetrics.LoadAverageInstruments _loadAverageInstruments() {
            return this._loadAverageInstruments;
        }

        private HostMetrics.StorageMountInstruments _fileSystemUsageInstruments() {
            return this._fileSystemUsageInstruments;
        }

        private HostMetrics.StorageDeviceInstruments _fileSystemActivityInstruments() {
            return this._fileSystemActivityInstruments;
        }

        private HostMetrics.NetworkActivityInstruments _networkActivityInstruments() {
            return this._networkActivityInstruments;
        }

        @Override
        public void run() {
            this.recordMemoryUsage();
            this.recordLoadAverage();
            this.recordStorageUsage();
            this.recordStorageActivity();
            this.recordNetworkActivity();
        }

        @Override
        public void cleanup() {
            this._memoryInstruments().remove();
            this._swapInstruments().remove();
            this._loadAverageInstruments().remove();
            this._fileSystemUsageInstruments().remove();
            this._fileSystemActivityInstruments().remove();
            this._networkActivityInstruments().remove();
        }

        private void recordMemoryUsage() {
            GlobalMemory memory = this._hal().getMemory();
            long totalMemory = memory.getTotal();
            long availableMemory = memory.getAvailable();
            long usedMemory = totalMemory - availableMemory;
            this._memoryInstruments().total().update((double)totalMemory);
            this._memoryInstruments().free().update((double)availableMemory);
            this._memoryInstruments().used().update((double)usedMemory);
            this._memoryInstruments().usage().update((double)this.toPercent(usedMemory, totalMemory));
            long usedSwap = memory.getVirtualMemory().getSwapUsed();
            long totalSwap = memory.getVirtualMemory().getSwapTotal();
            this._swapInstruments().total().update((double)totalSwap);
            this._swapInstruments().used().update((double)usedSwap);
            this._swapInstruments().usage().update((double)this.toPercent(usedSwap, totalSwap));
            this._swapInstruments().free().update((double)(totalSwap - usedSwap));
        }

        private void recordLoadAverage() {
            double[] loadAverage = this._hal().getProcessor().getSystemLoadAverage(3);
            if (loadAverage[0] >= 0.0) {
                this._loadAverageInstruments().oneMinute().update(loadAverage[0]);
            }
            if (loadAverage[1] >= 0.0) {
                this._loadAverageInstruments().fiveMinutes().update(loadAverage[1]);
            }
            if (loadAverage[2] >= 0.0) {
                this._loadAverageInstruments().fifteenMinutes().update(loadAverage[2]);
            }
        }

        private void recordStorageUsage() {
            List fileStores = this._os().getFileSystem().getFileStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileStores).asScala()).foreach((Function1 & Serializable & scala.Serializable)fs -> {
                if (this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedMounts().accept(fs.getType())) {
                    HostMetrics.StorageMountInstruments.MountInstruments mountInstruments = this._fileSystemUsageInstruments().mountInstruments(fs.getMount());
                    long totalSpace = fs.getTotalSpace();
                    long usedSpace = totalSpace - fs.getUsableSpace();
                    mountInstruments.free().update((double)fs.getUsableSpace());
                    mountInstruments.total().update((double)totalSpace);
                    mountInstruments.used().update((double)usedSpace);
                    return mountInstruments.usage().update((double)this.toPercent(usedSpace, totalSpace));
                }
                return BoxedUnit.UNIT;
            });
        }

        private long toPercent(long value, long total) {
            return (long)(100.0 * (double)value / (double)total);
        }

        private void recordStorageActivity() {
            List devices = this._hal().getDiskStores();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(devices).asScala()).foreach((Function1 & Serializable & scala.Serializable)device -> {
                InfrequentCollectionTask.$anonfun$recordStorageActivity$1(this, device);
                return BoxedUnit.UNIT;
            });
        }

        private void recordNetworkActivity() {
            List interfaces = this._hal().getNetworkIFs();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(interfaces).asScala()).foreach((Function1 & Serializable & scala.Serializable)networkIF -> {
                InfrequentCollectionTask.$anonfun$recordNetworkActivity$1(this, networkIF);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ HostMetricsCollector kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer() {
            return HostMetricsCollector.this;
        }

        public static final /* synthetic */ void $anonfun$recordStorageActivity$1(InfrequentCollectionTask $this, HWDiskStore device) {
            if (!device.getPartitions().isEmpty()) {
                HostMetrics.StorageDeviceInstruments.DeviceInstruments deviceInstruments = $this._fileSystemActivityInstruments().deviceInstruments(device.getName());
                deviceInstruments.reads().diff(device.getReads());
                deviceInstruments.writes().diff(device.getWrites());
                deviceInstruments.readBytes().diff(device.getReadBytes());
                deviceInstruments.writeBytes().diff(device.getWriteBytes());
            }
        }

        public static final /* synthetic */ void $anonfun$recordNetworkActivity$1(InfrequentCollectionTask $this, NetworkIF networkIF) {
            if ($this.kamon$instrumentation$system$host$HostMetricsCollector$InfrequentCollectionTask$$$outer().kamon$instrumentation$system$host$HostMetricsCollector$$_settings().trackedInterfaces().accept(networkIF.getName())) {
                HostMetrics.NetworkActivityInstruments.InterfaceInstruments interfaceInstruments = $this._networkActivityInstruments().interfaceInstruments(networkIF.getName());
                interfaceInstruments.receivedBytes().diff(networkIF.getBytesRecv());
                interfaceInstruments.sentBytes().diff(networkIF.getBytesSent());
                interfaceInstruments.sentPackets().diff(networkIF.getPacketsSent());
                interfaceInstruments.receivedPackets().diff(networkIF.getPacketsRecv());
                interfaceInstruments.sendErrorPackets().diff(networkIF.getOutErrors());
                interfaceInstruments.receiveErrorPackets().diff(networkIF.getInErrors());
            }
        }

        public InfrequentCollectionTask() {
            if (HostMetricsCollector.this == null) {
                throw null;
            }
            this._defaultTags = TagSet$.MODULE$.of("component", "host");
            this._systemInfo = new SystemInfo();
            this._hal = this._systemInfo().getHardware();
            this._os = this._systemInfo().getOperatingSystem();
            this._memoryInstruments = new HostMetrics.MemoryInstruments(this._defaultTags());
            this._swapInstruments = new HostMetrics.SwapInstruments(this._defaultTags());
            this._loadAverageInstruments = new HostMetrics.LoadAverageInstruments(this._defaultTags());
            this._fileSystemUsageInstruments = new HostMetrics.StorageMountInstruments(this._defaultTags());
            this._fileSystemActivityInstruments = new HostMetrics.StorageDeviceInstruments(this._defaultTags());
            this._networkActivityInstruments = new HostMetrics.NetworkActivityInstruments(this._defaultTags());
        }
    }

    public static class Settings
    implements Product,
    scala.Serializable {
        private final Filter trackedInterfaces;
        private final Filter trackedMounts;

        public Filter trackedInterfaces() {
            return this.trackedInterfaces;
        }

        public Filter trackedMounts() {
            return this.trackedMounts;
        }

        public Settings copy(Filter trackedInterfaces, Filter trackedMounts) {
            return new Settings(trackedInterfaces, trackedMounts);
        }

        public Filter copy$default$1() {
            return this.trackedInterfaces();
        }

        public Filter copy$default$2() {
            return this.trackedMounts();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.trackedInterfaces();
                }
                case 1: {
                    return this.trackedMounts();
                }
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            Filter filter = this.trackedInterfaces();
            Filter filter2 = settings.trackedInterfaces();
            if (filter == null) {
                if (filter2 != null) {
                    return false;
                }
            } else if (!filter.equals(filter2)) return false;
            Filter filter3 = this.trackedMounts();
            Filter filter4 = settings.trackedMounts();
            if (filter3 == null) {
                if (filter4 != null) {
                    return false;
                }
            } else if (!filter3.equals(filter4)) return false;
            if (!settings.canEqual(this)) return false;
            return true;
        }

        public Settings(Filter trackedInterfaces, Filter trackedMounts) {
            this.trackedInterfaces = trackedInterfaces;
            this.trackedMounts = trackedMounts;
            Product.$init$((Product)this);
        }
    }
}

