/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.jdbc;

import com.zaxxer.hikari.HikariConfig;
import java.io.Serializable;
import kamon.instrumentation.jdbc.ConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.DatabaseTags;
import kamon.instrumentation.jdbc.HasConnectionPoolTelemetry;
import kamon.instrumentation.jdbc.JdbcMetrics;
import kamon.instrumentation.jdbc.JdbcMetrics$;
import kamon.tag.TagSet;
import kamon.tag.TagSet$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.Try$;

public final class HikariPoolConstructorAdvice$ {
    public static final HikariPoolConstructorAdvice$ MODULE$ = new HikariPoolConstructorAdvice$();

    @Advice.OnMethodExit
    public void exit(@Advice.This HasConnectionPoolTelemetry hikariPool, @Advice.Argument(value=0) HikariConfig config) {
        String url = config.getJdbcUrl();
        String vendor = (String)Try$.MODULE$.apply((Function0 & Serializable)() -> StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(url), ':')[1]).getOrElse((Function0 & Serializable)() -> "unknown");
        TagSet metricTags = TagSet$.MODULE$.builder().add("jdbc.pool.vendor", "hikari").add("jdbc.pool.name", config.getPoolName()).add("db.vendor", vendor).build();
        TagSet spanTags = TagSet$.MODULE$.builder().add("db.url", url).build();
        JdbcMetrics.ConnectionPoolInstruments poolInstruments = JdbcMetrics$.MODULE$.poolInstruments(metricTags);
        hikariPool.connectionPoolTelemetry().set(new ConnectionPoolTelemetry(poolInstruments, new DatabaseTags(metricTags, spanTags)));
    }

    private HikariPoolConstructorAdvice$() {
    }
}

