/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.http;

import kamon.instrumentation.pekko.http.ServerFlowWrapper;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.apache.pekko.stream.scaladsl.FlowOps;

public class FlowOpsMapAsyncAdvice {
    public static ThreadLocal<EndpointInfo> currentEndpoint = new ThreadLocal();

    @Advice.OnMethodExit
    public static void onExit(@Advice.Return(readOnly=false) FlowOps flow) {
        EndpointInfo endpointInfo = currentEndpoint.get();
        if (endpointInfo != null) {
            flow = ServerFlowWrapper.apply(flow, endpointInfo.listenInterface, endpointInfo.listenPort);
        }
    }

    public static class EndpointInfo {
        public final String listenInterface;
        public final int listenPort;

        public EndpointInfo(String string, int n) {
            this.listenInterface = string;
            this.listenPort = n;
        }
    }
}

