/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.pekko.instrumentations;

import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.pekko.PekkoInstrumentation;
import kamon.instrumentation.pekko.PekkoInstrumentation$;
import kamon.instrumentation.pekko.PekkoMetrics;
import kamon.instrumentation.pekko.PekkoMetrics$;
import kamon.instrumentation.pekko.instrumentations.ActorCellInfo;
import kamon.instrumentation.pekko.instrumentations.ActorCellInfo$;
import kamon.instrumentation.pekko.instrumentations.ActorMonitor;
import kamon.instrumentation.pekko.instrumentations.HasGroupPath;
import kamon.util.Filter;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ActorMonitor$ {
    public static final ActorMonitor$ MODULE$ = new ActorMonitor$();

    public ActorMonitor from(Object actorCell, ActorRef ref, ActorRef parent, ActorSystem system) {
        ActorMonitor actorMonitor;
        ActorCellInfo cell = ActorCellInfo$.MODULE$.from(actorCell, ref, parent, system);
        PekkoInstrumentation.Settings settings = PekkoInstrumentation$.MODULE$.settings();
        boolean isTraced = Kamon$.MODULE$.filter(PekkoInstrumentation$.MODULE$.TraceActorFilterName()).accept(cell.path());
        boolean startsTrace = settings.safeActorStartTraceFilter().accept(cell.path());
        boolean participatesInTracing = (isTraced || startsTrace) && !cell.isStreamImplementationActor();
        String autoGroupingPath = this.resolveAutoGroupingPath(cell.actorOrRouterClass(), ref, parent, system.name());
        if (cell.isRouter()) {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cell, participatesInTracing, false);
        } else {
            Seq<String> configuredMatchingGroups;
            boolean isTracked;
            Filter trackedFilter = cell.isRouter() || cell.isRoutee() ? Kamon$.MODULE$.filter(PekkoInstrumentation$.MODULE$.TrackRouterFilterName()) : settings.safeActorTrackFilter();
            boolean bl = isTracked = !cell.isRootSupervisor() && trackedFilter.accept(cell.path());
            Object object = cell.isRootSupervisor() ? (Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$) : ((configuredMatchingGroups = PekkoInstrumentation$.MODULE$.matchingActorGroups(cell.path())).isEmpty() && !isTracked && settings.autoGrouping() && !cell.isRouter() && !cell.isRoutee() && !ActorCellInfo$.MODULE$.isTyped(cell.actorOrRouterClass()) ? (!trackedFilter.excludes(cell.path()) && Kamon$.MODULE$.filter(PekkoInstrumentation$.MODULE$.TrackAutoGroupFilterName()).accept(autoGroupingPath) ? (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PekkoMetrics.ActorGroupInstruments[]{PekkoMetrics$.MODULE$.forGroup(autoGroupingPath, system.name())})) : package$.MODULE$.List().empty()) : (Seq)configuredMatchingGroups.map((Function1 & Serializable)groupName -> PekkoMetrics$.MODULE$.forGroup((String)groupName, cell.systemName())));
            Seq trackingGroups = object;
            actorMonitor = cell.isRoutee() && isTracked ? this.createRouteeMonitor(cell, (Seq<PekkoMetrics.ActorGroupInstruments>)trackingGroups) : this.createRegularActorMonitor(cell, isTracked, participatesInTracing, (Seq<PekkoMetrics.ActorGroupInstruments>)trackingGroups);
        }
        ActorMonitor.ContextPropagationOnly monitor = actorMonitor;
        return ActorMonitor$.traceWrap$1(monitor, participatesInTracing, cell, startsTrace);
    }

    private ActorMonitor createRegularActorMonitor(ActorCellInfo cellInfo, boolean isTracked, boolean participatesInTracing, Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics) {
        ActorMonitor actorMonitor;
        if (isTracked || !groupMetrics.isEmpty()) {
            None$ actorMetrics = !isTracked ? None$.MODULE$ : new Some((Object)PekkoMetrics$.MODULE$.forActor(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass()));
            actorMonitor = new ActorMonitor.TrackedActor((Option<PekkoMetrics.ActorInstruments>)actorMetrics, groupMetrics, cellInfo);
        } else {
            actorMonitor = new ActorMonitor.ContextPropagationOnly(cellInfo, participatesInTracing, true);
        }
        return actorMonitor;
    }

    private ActorMonitor createRouteeMonitor(ActorCellInfo cellInfo, Seq<PekkoMetrics.ActorGroupInstruments> groupMetrics) {
        PekkoMetrics.RouterInstruments routerMetrics = PekkoMetrics$.MODULE$.forRouter(cellInfo.path(), cellInfo.systemName(), cellInfo.dispatcherName(), cellInfo.actorOrRouterClass(), (String)cellInfo.routeeClass().filterNot((Function1 & Serializable)className -> BoxesRunTime.boxToBoolean((boolean)ActorCellInfo$.MODULE$.isTyped(className))).map((Function1 & Serializable)x$1 -> x$1.getName()).getOrElse((Function0 & Serializable)() -> "Unknown"));
        return new ActorMonitor.TrackedRoutee(routerMetrics, groupMetrics, cellInfo);
    }

    private String resolveAutoGroupingPath(Class<?> actorClass, ActorRef ref, ActorRef parent, String systemName) {
        String string;
        String parentPath;
        String name = ref.path().name();
        int elementCount = ref.path().elements().size();
        String string2 = parentPath = parent instanceof HasGroupPath ? ((HasGroupPath)((Object)parent)).groupPath() : "";
        if (elementCount == 1) {
            String string3 = name;
            String string4 = "/";
            string = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : new StringBuilder(1).append(systemName).append("/").append(name).toString();
        } else {
            string = ActorCellInfo$.MODULE$.simpleClassName(actorClass);
        }
        String refGroupName = string;
        String refGroupPath = parentPath.isEmpty() ? refGroupName : new StringBuilder(1).append(parentPath).append("/").append(refGroupName).toString();
        ((HasGroupPath)((Object)ref)).setGroupPath(refGroupPath);
        return refGroupPath;
    }

    private static final ActorMonitor traceWrap$1(ActorMonitor monitor, boolean participatesInTracing$1, ActorCellInfo cell$1, boolean startsTrace$1) {
        return participatesInTracing$1 ? new ActorMonitor.TracedMonitor(cell$1, startsTrace$1, monitor) : monitor;
    }

    private ActorMonitor$() {
    }
}

