/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.api.instrumentation;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kanela.agent.api.advisor.AdvisorDescription;
import kanela.agent.api.instrumentation.bridge.BridgeDescription;
import kanela.agent.api.instrumentation.classloader.ClassLoaderRefiner;
import kanela.agent.api.instrumentation.mixin.MixinDescription;
import kanela.agent.libs.io.vavr.Function5;
import kanela.agent.libs.io.vavr.control.Option;
import kanela.agent.libs.net.bytebuddy.agent.builder.AgentBuilder;
import kanela.agent.libs.net.bytebuddy.description.method.MethodDescription;
import kanela.agent.libs.net.bytebuddy.description.type.TypeDescription;
import kanela.agent.libs.net.bytebuddy.dynamic.DynamicType;
import kanela.agent.libs.net.bytebuddy.implementation.MethodDelegation;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatcher;
import kanela.agent.libs.net.bytebuddy.matcher.ElementMatchers;
import kanela.agent.libs.net.bytebuddy.utility.JavaModule;

public final class InstrumentationDescription {
    private final Option<ElementMatcher<? super TypeDescription>> elementMatcher;
    private final Option<ClassLoaderRefiner> classLoaderRefiner;
    private final List<MixinDescription> mixins;
    private final List<BridgeDescription> bridges;
    private final List<AdvisorDescription> advisors;
    private final List<AgentBuilder.Transformer> transformers;

    private InstrumentationDescription(Builder builder) {
        this.elementMatcher = builder.elementMatcher;
        this.classLoaderRefiner = builder.classLoaderRefiner;
        this.mixins = builder.mixins;
        this.bridges = builder.bridges;
        this.advisors = builder.advisors;
        this.transformers = builder.transformers;
    }

    public Option<ElementMatcher<? super TypeDescription>> getElementMatcher() {
        return this.elementMatcher;
    }

    public Option<ClassLoaderRefiner> getClassLoaderRefiner() {
        return this.classLoaderRefiner;
    }

    public List<MixinDescription> getMixins() {
        return this.mixins;
    }

    public List<BridgeDescription> getBridges() {
        return this.bridges;
    }

    public List<AdvisorDescription> getAdvisors() {
        return this.advisors;
    }

    public List<AgentBuilder.Transformer> getTransformers() {
        return this.transformers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstrumentationDescription)) {
            return false;
        }
        InstrumentationDescription other = (InstrumentationDescription)o;
        Option<ElementMatcher<? super TypeDescription>> this$elementMatcher = this.getElementMatcher();
        Option<ElementMatcher<? super TypeDescription>> other$elementMatcher = other.getElementMatcher();
        if (this$elementMatcher == null ? other$elementMatcher != null : !((Object)this$elementMatcher).equals(other$elementMatcher)) {
            return false;
        }
        Option<ClassLoaderRefiner> this$classLoaderRefiner = this.getClassLoaderRefiner();
        Option<ClassLoaderRefiner> other$classLoaderRefiner = other.getClassLoaderRefiner();
        if (this$classLoaderRefiner == null ? other$classLoaderRefiner != null : !((Object)this$classLoaderRefiner).equals(other$classLoaderRefiner)) {
            return false;
        }
        List<MixinDescription> this$mixins = this.getMixins();
        List<MixinDescription> other$mixins = other.getMixins();
        if (this$mixins == null ? other$mixins != null : !((Object)this$mixins).equals(other$mixins)) {
            return false;
        }
        List<BridgeDescription> this$bridges = this.getBridges();
        List<BridgeDescription> other$bridges = other.getBridges();
        if (this$bridges == null ? other$bridges != null : !((Object)this$bridges).equals(other$bridges)) {
            return false;
        }
        List<AdvisorDescription> this$advisors = this.getAdvisors();
        List<AdvisorDescription> other$advisors = other.getAdvisors();
        if (this$advisors == null ? other$advisors != null : !((Object)this$advisors).equals(other$advisors)) {
            return false;
        }
        List<AgentBuilder.Transformer> this$transformers = this.getTransformers();
        List<AgentBuilder.Transformer> other$transformers = other.getTransformers();
        return !(this$transformers == null ? other$transformers != null : !((Object)this$transformers).equals(other$transformers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Option<ElementMatcher<? super TypeDescription>> $elementMatcher = this.getElementMatcher();
        result = result * 59 + ($elementMatcher == null ? 43 : ((Object)$elementMatcher).hashCode());
        Option<ClassLoaderRefiner> $classLoaderRefiner = this.getClassLoaderRefiner();
        result = result * 59 + ($classLoaderRefiner == null ? 43 : ((Object)$classLoaderRefiner).hashCode());
        List<MixinDescription> $mixins = this.getMixins();
        result = result * 59 + ($mixins == null ? 43 : ((Object)$mixins).hashCode());
        List<BridgeDescription> $bridges = this.getBridges();
        result = result * 59 + ($bridges == null ? 43 : ((Object)$bridges).hashCode());
        List<AdvisorDescription> $advisors = this.getAdvisors();
        result = result * 59 + ($advisors == null ? 43 : ((Object)$advisors).hashCode());
        List<AgentBuilder.Transformer> $transformers = this.getTransformers();
        result = result * 59 + ($transformers == null ? 43 : ((Object)$transformers).hashCode());
        return result;
    }

    public String toString() {
        return "InstrumentationDescription(elementMatcher=" + this.getElementMatcher() + ", classLoaderRefiner=" + this.getClassLoaderRefiner() + ", mixins=" + this.getMixins() + ", bridges=" + this.getBridges() + ", advisors=" + this.getAdvisors() + ", transformers=" + this.getTransformers() + ")";
    }

    public static class Builder {
        private Option<ElementMatcher<? super TypeDescription>> elementMatcher;
        private Option<ClassLoaderRefiner> classLoaderRefiner = Option.none();
        private final List<MixinDescription> mixins = new ArrayList<MixinDescription>();
        private final List<BridgeDescription> bridges = new ArrayList<BridgeDescription>();
        private final List<AdvisorDescription> advisors = new ArrayList<AdvisorDescription>();
        private final List<AgentBuilder.Transformer> transformers = new ArrayList<AgentBuilder.Transformer>();

        Builder addElementMatcher(Supplier<ElementMatcher<? super TypeDescription>> f) {
            this.elementMatcher = Option.of(f.get());
            return this;
        }

        public Builder withMixin(Supplier<Class<?>> clazz) {
            this.mixins.add(MixinDescription.of(clazz.get()));
            return this;
        }

        public Builder withBridge(Supplier<Class<?>> clazz) {
            this.bridges.add(BridgeDescription.of(clazz.get()));
            return this;
        }

        public Builder withClassLoaderRefiner(Supplier<ClassLoaderRefiner> clazz) {
            this.classLoaderRefiner = Option.of(clazz.get());
            return this;
        }

        public Builder withAdvisorFor(ElementMatcher.Junction<MethodDescription> methodDescription, Supplier<Class<?>> classSupplier) {
            this.advisors.add(AdvisorDescription.of(methodDescription.and(this.defaultMethodElementMatcher()), classSupplier.get()));
            return this;
        }

        public Builder withAdvisorFor(ElementMatcher.Junction<MethodDescription> methodDescription, String advisorClassName) {
            this.advisors.add(AdvisorDescription.of(methodDescription.and(this.defaultMethodElementMatcher()), advisorClassName));
            return this;
        }

        public Builder withInterceptorFor(ElementMatcher.Junction<MethodDescription> method, Supplier<Class<?>> delegate) {
            this.withTransformation((builder, typeDescription, classLoader, javaModule, domain) -> builder.method(method).intercept(MethodDelegation.to((Class)delegate.get())));
            return this;
        }

        public Builder withInterceptorFor(ElementMatcher.Junction<MethodDescription> method, Object delegate) {
            this.withTransformation((builder, typeDescription, classLoader, javaModule, domain) -> builder.method(method).intercept(MethodDelegation.to(delegate)));
            return this;
        }

        public Builder withTransformation(Function5<DynamicType.Builder, TypeDescription, ClassLoader, JavaModule, ProtectionDomain, DynamicType.Builder> f) {
            this.transformers.add(this.withTransformer(f));
            return this;
        }

        private AgentBuilder.Transformer withTransformer(Function5<DynamicType.Builder, TypeDescription, ClassLoader, JavaModule, ProtectionDomain, DynamicType.Builder> f) {
            return f::apply;
        }

        public InstrumentationDescription build() {
            return new InstrumentationDescription(this);
        }

        private ElementMatcher.Junction<MethodDescription> defaultMethodElementMatcher() {
            return ElementMatchers.not(ElementMatchers.isAbstract()).and(ElementMatchers.not(ElementMatchers.isNative())).and(ElementMatchers.not(ElementMatchers.isSynthetic()));
        }
    }
}

