/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.io.vavr.collection;

import java.util.Objects;
import java.util.function.Predicate;
import kanela.agent.libs.io.vavr.Tuple;
import kanela.agent.libs.io.vavr.Tuple2;
import kanela.agent.libs.io.vavr.collection.LinearSeq;
import kanela.agent.libs.io.vavr.collection.List;

interface ListModule {

    public static interface SplitAt {
        public static <T> Tuple2<List<T>, List<T>> splitByPredicateReversed(List<T> source, Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate, "predicate is null");
            LinearSeq init2 = List.Nil.instance();
            LinearSeq<T> tail = source;
            while (!tail.isEmpty() && !predicate.test(tail.head())) {
                init2 = init2.prepend(tail.head());
                tail = tail.tail();
            }
            return Tuple.of(init2, tail);
        }
    }

    public static interface Combinations {
        public static <T> List<List<T>> apply(List<T> elements, int k) {
            if (k == 0) {
                return List.of(List.empty());
            }
            return elements.zipWithIndex().flatMap(t -> Combinations.apply(elements.drop((Integer)t._2 + 1), k - 1).map(c -> c.prepend(t._1)));
        }
    }
}

