/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import kanela.agent.libs.org.pmw.tinylog.ClassLoaderResolver;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.ConfigurationObserver;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.Level;
import kanela.agent.libs.org.pmw.tinylog.Logger;
import kanela.agent.libs.org.pmw.tinylog.PropertiesLoader;
import kanela.agent.libs.org.pmw.tinylog.WriterDefinition;
import kanela.agent.libs.org.pmw.tinylog.WritingThread;
import kanela.agent.libs.org.pmw.tinylog.writers.ConsoleWriter;
import kanela.agent.libs.org.pmw.tinylog.writers.Writer;

public final class Configurator {
    private static final String DEFAULT_PROPERTIES_FILE = "tinylog.properties";
    private static final String DEFAULT_THREAD_TO_OBSERVE_BY_WRITING_THREAD = "main";
    private static final int DEFAULT_PRIORITY_FOR_WRITING_THREAD = 3;
    private static final Pattern URL_DETECTION_PATTERN = Pattern.compile("^[a-zA-Z]{2,}:/.*");
    private static WritingThread activeWritingThread = null;
    private static final Object lock = new Object();
    private Level level;
    private final Map<String, Level> customLevels;
    private String formatPattern;
    private Locale locale;
    private final List<WriterDefinition> writers;
    private WritingThreadData writingThreadData;
    private Integer maxStackTraceElements;

    Configurator(Level level, Map<String, Level> map, String string, Locale locale, List<WriterDefinition> list, WritingThreadData writingThreadData, Integer n) {
        this.level = level;
        this.customLevels = new HashMap<String, Level>(map);
        this.formatPattern = string;
        this.locale = locale;
        this.writers = new ArrayList<WriterDefinition>(list);
        this.writingThreadData = writingThreadData;
        this.maxStackTraceElements = n;
    }

    public static Configurator defaultConfig() {
        return new Configurator(null, Collections.<String, Level>emptyMap(), null, Locale.getDefault(), Collections.singletonList(new WriterDefinition(new ConsoleWriter())), null, null);
    }

    public static Configurator currentConfig() {
        return Logger.getConfiguration();
    }

    public static Configurator fromResource(String string) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = ClassLoaderResolver.resolve(Configurator.class).getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        try {
            Configurator.shutdownWritingThread(true);
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return PropertiesLoader.readProperties(properties);
    }

    public static Configurator fromFile(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Configurator.shutdownWritingThread(true);
            properties.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return PropertiesLoader.readProperties(properties);
    }

    public static Configurator fromStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        return PropertiesLoader.readProperties(properties);
    }

    public static Configurator fromURL(URL uRL) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            throw new FileNotFoundException();
        }
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return PropertiesLoader.readProperties(properties);
    }

    public static Configurator fromMap(Map<String, ?> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null) continue;
            properties.put(entry.getKey(), obj.toString());
        }
        return PropertiesLoader.readProperties(properties);
    }

    public Configurator level(Level level) {
        this.level = level;
        return this;
    }

    public Configurator level(Package package_, Level level) {
        return this.level(package_.getName(), level);
    }

    public Configurator level(Class<?> clazz, Level level) {
        return this.level(clazz.getName(), level);
    }

    public Configurator level(String string, Level level) {
        if (level == null) {
            this.customLevels.remove(string);
        } else {
            this.customLevels.put(string, level);
        }
        return this;
    }

    public Configurator resetCustomLevels() {
        this.customLevels.clear();
        return this;
    }

    public Configurator formatPattern(String string) {
        this.formatPattern = string;
        return this;
    }

    public Configurator locale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        return this;
    }

    public Configurator writer(Writer writer) {
        this.writers.clear();
        if (writer != null) {
            this.writers.add(new WriterDefinition(writer));
        }
        return this;
    }

    public Configurator writer(Writer writer, Level level) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        this.writers.clear();
        this.writers.add(new WriterDefinition(writer, level));
        return this;
    }

    public Configurator writer(Writer writer, String string) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (string == null) {
            throw new NullPointerException("format pattern is null");
        }
        this.writers.clear();
        this.writers.add(new WriterDefinition(writer, string));
        return this;
    }

    public Configurator writer(Writer writer, Level level, String string) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (string == null) {
            throw new NullPointerException("format pattern is null");
        }
        this.writers.clear();
        this.writers.add(new WriterDefinition(writer, level, string));
        return this;
    }

    public Configurator addWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        this.writers.add(new WriterDefinition(writer));
        return this;
    }

    public Configurator addWriter(Writer writer, Level level) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        this.writers.add(new WriterDefinition(writer, level));
        return this;
    }

    public Configurator addWriter(Writer writer, String string) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (string == null) {
            throw new NullPointerException("format pattern is null");
        }
        this.writers.add(new WriterDefinition(writer, string));
        return this;
    }

    public Configurator addWriter(Writer writer, Level level, String string) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (string == null) {
            throw new NullPointerException("format pattern is null");
        }
        this.writers.add(new WriterDefinition(writer, level, string));
        return this;
    }

    public Configurator removeWriter(Writer writer) {
        Iterator<WriterDefinition> iterator = this.writers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getWriter() != writer) continue;
            iterator.remove();
        }
        return this;
    }

    public Configurator removeAllWriters() {
        this.writers.clear();
        return this;
    }

    public Configurator writingThread(boolean bl) {
        if (bl) {
            return this.writingThread(DEFAULT_THREAD_TO_OBSERVE_BY_WRITING_THREAD, 3);
        }
        this.writingThreadData = null;
        return this;
    }

    public Configurator writingThread(int n) {
        return this.writingThread(DEFAULT_THREAD_TO_OBSERVE_BY_WRITING_THREAD, n);
    }

    public Configurator writingThread(String string) {
        return this.writingThread(string, 3);
    }

    public Configurator writingThread(String string, int n) {
        this.writingThreadData = new WritingThreadData(string, n);
        return this;
    }

    public Configurator maxStackTraceElements(int n) {
        this.maxStackTraceElements = n < 0 ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(n);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate() {
        Object object = lock;
        synchronized (object) {
            if (!(activeWritingThread == null || this.writingThreadData != null && this.writingThreadData.covers(activeWritingThread))) {
                activeWritingThread.shutdown();
                activeWritingThread = null;
            }
            Configuration configuration = this.create();
            try {
                Logger.setConfiguration(configuration);
            }
            catch (Exception exception) {
                InternalLogger.error(exception, "Failed to activate configuration");
                return false;
            }
            if (activeWritingThread == null && configuration.getWritingThread() != null) {
                activeWritingThread = configuration.getWritingThread();
                activeWritingThread.start();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownWritingThread(boolean bl) {
        Object object = lock;
        synchronized (object) {
            if (activeWritingThread != null) {
                activeWritingThread.shutdown();
                if (bl) {
                    boolean bl2;
                    do {
                        try {
                            activeWritingThread.join();
                            bl2 = true;
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = false;
                        }
                    } while (!bl2);
                }
                activeWritingThread = null;
            }
        }
    }

    public static void shutdownConfigurationObserver(boolean bl) {
        ConfigurationObserver configurationObserver = ConfigurationObserver.getActiveObserver();
        if (configurationObserver != null) {
            configurationObserver.shutdown();
            if (bl) {
                while (true) {
                    try {
                        configurationObserver.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Configurator init() {
        Properties properties = new Properties();
        String string = System.getProperty("tinylog.configuration", DEFAULT_PROPERTIES_FILE);
        URL uRL = null;
        InputStream inputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (URL_DETECTION_PATTERN.matcher(string).matches()) {
            try {
                uRL = new URL(string);
                inputStream = uRL.openStream();
                bl3 = true;
            }
            catch (MalformedURLException malformedURLException) {
                InternalLogger.error(malformedURLException, "Invalid URL: \"{}\"", string);
            }
            catch (IOException iOException) {
                InternalLogger.error(iOException, "Cannot connect to \"{}\"", string);
            }
        } else {
            inputStream = ClassLoaderResolver.resolve(Configurator.class).getResourceAsStream(string);
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(string);
                    bl2 = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (string != DEFAULT_PROPERTIES_FILE) {
                        InternalLogger.error(fileNotFoundException, "Cannot find \"{}\"", string);
                    }
                }
            } else {
                bl = true;
            }
        }
        if (inputStream != null) {
            try {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                InternalLogger.error(iOException, "Failed to read properties file \"{}\"", string);
            }
        }
        Properties properties2 = (Properties)System.getProperties().clone();
        for (Object object : properties2.keySet()) {
            String string2 = (String)object;
            if (!string2.startsWith("tinylog.")) continue;
            properties.put(string2, properties2.getProperty(string2));
        }
        if (properties.isEmpty()) {
            return Configurator.defaultConfig();
        }
        if ("true".equalsIgnoreCase(properties.getProperty("tinylog.configuration.observe"))) {
            Configurator.shutdownWritingThread(true);
            Configurator configurator2 = PropertiesLoader.readProperties(properties);
            if (bl) {
                ConfigurationObserver.createResourceConfigurationObserver(configurator2, properties, string).start();
            } else if (bl2) {
                ConfigurationObserver.createFileConfigurationObserver(configurator2, properties, string).start();
            } else if (bl3) {
                ConfigurationObserver.createURLConfigurationObserver(configurator2, properties, uRL).start();
            }
            return configurator2;
        }
        Configurator.shutdownWritingThread(true);
        return PropertiesLoader.readProperties(properties);
    }

    Configurator copy() {
        WritingThreadData writingThreadData = this.writingThreadData == null ? null : new WritingThreadData(this.writingThreadData.threadToObserve, this.writingThreadData.priority);
        return new Configurator(this.level, this.customLevels, this.formatPattern, this.locale, this.writers, writingThreadData, this.maxStackTraceElements);
    }

    Configuration create() {
        WritingThread writingThread;
        Configurator configurator2 = this.copy();
        if (configurator2.writingThreadData == null) {
            writingThread = null;
        } else {
            writingThread = new WritingThread(configurator2.writingThreadData.threadToObserve, configurator2.writingThreadData.priority);
            if (configurator2.writingThreadData.threadToObserve != null && writingThread.getThreadToObserve() == null) {
                InternalLogger.warn("Thread \"{}\" could not be found, writing thread will not be used", configurator2.writingThreadData.threadToObserve);
                writingThread = null;
            }
        }
        return new Configuration(configurator2, configurator2.level, configurator2.customLevels, configurator2.formatPattern, configurator2.locale, configurator2.writers, writingThread, configurator2.maxStackTraceElements);
    }

    static final class WritingThreadData {
        private final String threadToObserve;
        private final int priority;

        WritingThreadData(String string, int n) {
            this.threadToObserve = string;
            this.priority = n;
        }

        boolean covers(WritingThread writingThread) {
            if (writingThread == null) {
                return false;
            }
            if (this.threadToObserve == null ? writingThread.getNameOfThreadToObserve() != null : !this.threadToObserve.equals(writingThread.getNameOfThreadToObserve())) {
                return false;
            }
            return this.priority == writingThread.getPriority();
        }
    }
}

