/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.libs.org.pmw.tinylog.labelers;

import java.io.File;
import java.util.Arrays;
import kanela.agent.libs.org.pmw.tinylog.Configuration;
import kanela.agent.libs.org.pmw.tinylog.EnvironmentHelper;
import kanela.agent.libs.org.pmw.tinylog.InternalLogger;
import kanela.agent.libs.org.pmw.tinylog.labelers.Labeler;
import kanela.agent.libs.org.pmw.tinylog.labelers.LogFileComparator;
import kanela.agent.libs.org.pmw.tinylog.labelers.LogFileFilter;
import kanela.agent.libs.org.pmw.tinylog.labelers.PropertiesSupport;

@PropertiesSupport(name="pid")
public final class ProcessIdLabeler
implements Labeler {
    private final String pid = EnvironmentHelper.getRuntimeDialect().getProcessId();
    private LogFileFilter logFileFilter;

    public String getProcessId() {
        return this.pid;
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public File getLogFile(File file, int n) {
        File file2;
        String string = file.getAbsoluteFile().getParent();
        String string2 = file.getName();
        int n2 = string2.indexOf(46, 1);
        if (n2 > 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2);
            this.logFileFilter = new LogFileFilter(string3, string4);
            file2 = new File(string, string3 + "." + this.pid + string4);
        } else {
            this.logFileFilter = new LogFileFilter(string2, "");
            file2 = new File(string, string2 + "." + this.pid);
        }
        this.delete(file2.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter), n);
        return file2;
    }

    @Override
    public File roll(File file, int n) {
        if (file.exists() && !file.delete()) {
            InternalLogger.warn("Failed to delete \"{}\"", file);
        }
        this.delete(file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter), n);
        return file;
    }

    private void delete(File[] fileArray, int n) {
        if (fileArray != null && fileArray.length > n) {
            Arrays.sort(fileArray, LogFileComparator.getInstance());
            for (int i = n; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file.delete()) continue;
                InternalLogger.warn("Failed to delete \"{}\"", file);
            }
        }
    }
}

