/*
 * Decompiled with CFR 0.152.
 */
package kanela.agent.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import kanela.agent.libs.io.vavr.control.Try;

public final class Manifests {
    public static Set<String> getAllPropertiesFromTitleOrBundle() {
        return kanela.agent.libs.io.vavr.collection.List.ofAll(Manifests.getAll()).flatMap(manifest -> Manifests.filterMapByKey(manifest.getMainAttributes().entrySet())).filter(Objects::nonNull).toJavaSet();
    }

    private static List<String> filterMapByKey(Set<Map.Entry<Object, Object>> entries2) {
        return entries2.stream().filter(Manifests.buildPredicate()).map(entry -> entry.getValue().toString()).collect(Collectors.toList());
    }

    private static Predicate<Map.Entry<Object, Object>> buildPredicate() {
        List<Predicate> allPredicates = Arrays.asList(entry -> entry.getKey().toString().equalsIgnoreCase("Implementation-Title"), entry -> entry.getKey().toString().equalsIgnoreCase("Automatic-Module-Name"), entry -> entry.getKey().toString().equalsIgnoreCase("Bundle-Name"));
        return allPredicates.stream().reduce(w -> true, Predicate::or);
    }

    private static List<Manifest> getAll() {
        return Try.of(() -> {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            ArrayList<Manifest> manifests = new ArrayList<Manifest>(1);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                Throwable throwable = null;
                try {
                    manifests.add(new Manifest(stream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            return manifests;
        }).getOrElse(Collections::emptyList);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Manifests;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Manifests()";
    }
}

