/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public class Int2IntHashMap
implements Map<Integer, Integer> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private int[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Int2IntHashMap(int missingValue) {
        this(8, 0.65f, missingValue);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = this.missingValue;
        while (this.entries[index + 1] != this.missingValue) {
            if (this.entries[index] == key) {
                value = this.entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public int put(int key, int value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int mask = this.entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = this.missingValue;
        while (this.entries[index + 1] != this.missingValue) {
            if (this.entries[index] == key) {
                oldValue = this.entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        if (oldValue == this.missingValue) {
            ++this.size;
            this.entries[index] = key;
        }
        this.entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int[] oldEntries = this.entries;
        int length = this.entries.length;
        this.capacity(newCapacity);
        int[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            int value = oldEntries[keyIndex + 1];
            if (value == this.missingValue) continue;
            int key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (newEntries[index + 1] != this.missingValue) {
                index = Int2IntHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    public void intForEach(IntIntConsumer consumer) {
        int length = this.entries.length;
        int remaining = this.size;
        for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
            if (this.entries[valueIndex] == this.missingValue) continue;
            consumer.accept(this.entries[valueIndex - 1], this.entries[valueIndex]);
            --remaining;
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (value != this.missingValue) {
            int length = this.entries.length;
            int remaining = this.size;
            for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
                if (this.missingValue == this.entries[valueIndex]) continue;
                if (value == this.entries[valueIndex]) {
                    found = true;
                    break;
                }
                --remaining;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsInt(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Integer get(Object key) {
        return this.valOrNull(this.get((Integer)key));
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return this.valOrNull(this.put((int)key, (int)value));
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        this.intForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Integer remove(Object key) {
        return this.valOrNull(this.remove((Integer)key));
    }

    public int remove(int key) {
        int mask = this.entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        int oldValue = this.missingValue;
        while (this.entries[keyIndex + 1] != this.missingValue) {
            if (this.entries[keyIndex] == key) {
                oldValue = this.entries[keyIndex + 1];
                this.entries[keyIndex + 1] = this.missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        int mask = this.entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (this.entries[(keyIndex = Int2IntHashMap.next(keyIndex, mask)) + 1] != this.missingValue) {
            int hash = Hashing.evenHash(this.entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            this.entries[deleteKeyIndex] = this.entries[keyIndex];
            this.entries[deleteKeyIndex + 1] = this.entries[keyIndex + 1];
            this.entries[keyIndex + 1] = this.missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public int minValue() {
        int missingValue = this.missingValue;
        int min2 = this.size == 0 ? missingValue : Integer.MAX_VALUE;
        int length = this.entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = this.entries[valueIndex];
            if (value == missingValue) continue;
            min2 = Math.min(min2, value);
        }
        return min2;
    }

    public int maxValue() {
        int missingValue = this.missingValue;
        int max = this.size == 0 ? missingValue : Integer.MIN_VALUE;
        int length = this.entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = this.entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public int replace(int key, int value) {
        int currentValue = this.get(key);
        if (currentValue != this.missingValue) {
            currentValue = this.put(key, value);
        }
        return currentValue;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        int curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Integer valOrNull(int value) {
        return value == this.missingValue ? null : Integer.valueOf(value);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Integer>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Integer value = Int2IntHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Int2IntHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Int2IntHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int value) {
            return Int2IntHashMap.this.containsValue(value);
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsKey(key);
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public int setValue(int value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Int2IntHashMap.this.missingValue == value) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            int prevValue = Int2IntHashMap.this.entries[keyPosition + 1];
            ((Int2IntHashMap)Int2IntHashMap.this).entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            if (Int2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, Integer> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getIntValue());
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.getIntKey()) ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Integer, Integer> {
            private final int k;
            private final int v;

            public MapEntry(int k, int v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public Integer getValue() {
                return this.v;
            }

            @Override
            public Integer setValue(Integer value) {
                return Int2IntHashMap.this.put(this.k, (int)value);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ Integer.hashCode(EntryIterator.this.getIntValue());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getValue() != null && e.getKey().equals(this.k) && e.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Int2IntHashMap.this.size;
            int missingValue = Int2IntHashMap.this.missingValue;
            int[] entries2 = Int2IntHashMap.this.entries;
            int keyIndex = capacity = entries2.length;
            if (entries2[capacity - 1] != missingValue) {
                for (int i = 1; i < capacity; i += 2) {
                    if (entries2[i] != missingValue) continue;
                    keyIndex = i - 1;
                    break;
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] entries2 = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries2.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries2[index + 1] == missingValue) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Int2IntHashMap)Int2IntHashMap.this).entries[position + 1] = Int2IntHashMap.this.missingValue;
            --Int2IntHashMap.this.size;
            Int2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

