/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.CrossDcHeartbeatingState;
import org.apache.pekko.cluster.CrossDcHeartbeatingState$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rme!B6m\u00011$\bbBA\u0002\u0001\u0011\u0005\u0011q\u0001\u0005\t[\u0002\u0011\r\u0011\"\u0001\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0001\u0002\u001a!A\u0011\u0011\u0005\u0001!\u0002\u0013\tY\u0002C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&!A\u0011\u0011\u0007\u0001!\u0002\u0013\t9\u0003C\u0005\u00024\u0001\u0001\r\u0011\"\u0001\u0002\u001a!I\u0011Q\u0007\u0001A\u0002\u0013\u0005\u0011q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002\u001c!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011q\t\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002J!I\u0011q\u000b\u0001C\u0002\u0013\u0005\u0011\u0011\f\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002\\!I\u0011Q\u000e\u0001C\u0002\u0013\u0005\u0011q\u000e\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002r!I\u0011Q\u0011\u0001A\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0001\u0003#C\u0001\"!&\u0001A\u0003&\u0011\u0011\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011%\tI\u000b\u0001a\u0001\n\u0003\tY\u000bC\u0005\u00024\u0002\u0001\r\u0011\"\u0001\u00026\"A\u0011\u0011\u0018\u0001!B\u0013\ti\u000bC\u0005\u0002<\u0002\u0011\r\u0011\"\u0001\u0002>\"A\u0011Q\u0019\u0001!\u0002\u0013\ty\fC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005-\u0007\u0001\"\u0011\u0002J\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003[\u0004A\u0011AAo\u0011\u001d\ty\u000f\u0001C\u0001\u0003;Dq!!=\u0001\t\u0003\ti\u000eC\u0004\u0002t\u0002!\t!!>\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0011\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005gAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003<\u0001!I!!3\b\u0011\t-C\u000e#\u0001o\u0005\u001b2qa\u001b7\t\u00029\u0014y\u0005C\u0004\u0002\u0004)\"\tA!\u0015\u0007\u0013\tM#\u0006%A\u0012\"\tUcA\u0002B/U\t\u0013y\u0006C\u0004\u0002\u00045\"\tAa \t\u0013\t\u0015U&!A\u0005\u0002\t}\u0004\"\u0003BD[\u0005\u0005I\u0011\tBE\u0011%\u0011Y*LA\u0001\n\u0003\u0011i\nC\u0005\u0003&6\n\t\u0011\"\u0001\u0003(\"I!\u0011W\u0017\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005\u0003l\u0013\u0011!C\u0001\u0005\u0007D\u0011Ba2.\u0003\u0003%\tE!3\t\u0013\t5W&!A\u0005B\t=\u0007\"\u0003Bi[\u0005\u0005I\u0011\tBj\u0011%\u0011).LA\u0001\n\u0003\u00129nB\u0005\u0003\\*\n\t\u0011#\u0001\u0003^\u001aI!Q\f\u0016\u0002\u0002#\u0005!q\u001c\u0005\b\u0003\u0007QD\u0011\u0001B|\u0011%\u0011\tNOA\u0001\n\u000b\u0012\u0019\u000eC\u0005\u0003zj\n\t\u0011\"!\u0003\u0000!I!1 \u001e\u0002\u0002\u0013\u0005%Q \u0005\n\u0007\u0007Q\u0014\u0011!C\u0005\u0007\u000b1\u0011b!\u0004+!\u0003\r\nca\u0004\u0007\u0013\rM!\u0006%A\u0012\"\rUaABB\u000eU\t\u001bi\u0002\u0003\u0006\u0004\"\t\u0013)\u001a!C\u0001\u0003WC!ba\tC\u0005#\u0005\u000b\u0011BAW\u0011\u001d\t\u0019A\u0011C\u0001\u0007KA\u0011B!\"C\u0003\u0003%\taa\u000b\t\u0013\r=\")%A\u0005\u0002\rE\u0002\"\u0003BD\u0005\u0006\u0005I\u0011\tBE\u0011%\u0011YJQA\u0001\n\u0003\u0011i\nC\u0005\u0003&\n\u000b\t\u0011\"\u0001\u0004F!I!\u0011\u0017\"\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005\u0003\u0014\u0015\u0011!C\u0001\u0007\u0013B\u0011Ba2C\u0003\u0003%\te!\u0014\t\u0013\t5')!A\u0005B\t=\u0007\"\u0003Bi\u0005\u0006\u0005I\u0011\tBj\u0011%\u0011)NQA\u0001\n\u0003\u001a\tfB\u0005\u0004n)\n\t\u0011#\u0001\u0004p\u0019I11\u0004\u0016\u0002\u0002#\u00051\u0011\u000f\u0005\b\u0003\u0007\u0011F\u0011AB=\u0011%\u0011\tNUA\u0001\n\u000b\u0012\u0019\u000eC\u0005\u0003zJ\u000b\t\u0011\"!\u0004|!I!1 *\u0002\u0002\u0013\u00055q\u0010\u0005\n\u0007\u0007\u0011\u0016\u0011!C\u0005\u0007\u000b1aa!\u0016+\u0005\u000e]\u0003bBA\u00021\u0012\u00051\u0011\f\u0005\n\u0005\u000bC\u0016\u0011!C\u0001\u00073B\u0011Ba\"Y\u0003\u0003%\tE!#\t\u0013\tm\u0005,!A\u0005\u0002\tu\u0005\"\u0003BS1\u0006\u0005I\u0011AB/\u0011%\u0011\t\fWA\u0001\n\u0003\u0012\u0019\fC\u0005\u0003Bb\u000b\t\u0011\"\u0001\u0004b!I!q\u0019-\u0002\u0002\u0013\u00053Q\r\u0005\n\u0005\u001bD\u0016\u0011!C!\u0005\u001fD\u0011B!5Y\u0003\u0003%\tEa5\t\u0013\tU\u0007,!A\u0005B\r%t!CBEU\u0005\u0005\t\u0012ABF\r%\u0019)FKA\u0001\u0012\u0003\u0019i\tC\u0004\u0002\u0004\u0015$\ta!%\t\u0013\tEW-!A\u0005F\tM\u0007\"\u0003B}K\u0006\u0005I\u0011QB-\u0011%\u0011Y0ZA\u0001\n\u0003\u001b\u0019\nC\u0005\u0004\u0004\u0015\f\t\u0011\"\u0003\u0004\u0006\t12I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r^*f]\u0012,'O\u0003\u0002n]\u000691\r\\;ti\u0016\u0014(BA8q\u0003\u0015\u0001Xm[6p\u0015\t\t(/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0006\u0019qN]4\u0014\u0007\u0001)8\u0010\u0005\u0002ws6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0004B]f\u0014VM\u001a\t\u0003y~l\u0011! \u0006\u0003}:\fQ!Y2u_JL1!!\u0001~\u0005\u0015\t5\r^8s\u0003\u0019a\u0014N\\5u}\r\u0001ACAA\u0005!\r\tY\u0001A\u0007\u0002YV\u0011\u0011q\u0002\t\u0005\u0003\u0017\t\t\"C\u0002\u0002\u00141\u0014qa\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003A1XM\u001d2pg\u0016DU-\u0019:uE\u0016\fG/\u0006\u0002\u0002\u001cA\u0019a/!\b\n\u0007\u0005}qOA\u0004C_>dW-\u00198\u0002#Y,'OY8tK\"+\u0017M\u001d;cK\u0006$\b%A\u0007dYV\u001cH/\u001a:M_\u001e<WM]\u000b\u0003\u0003O\u0001B!!\u000b\u0002.9\u0019\u00111\u0006\u0002\u000e\u0003\u0001IA!a\f\u0002\u0012\ti1\t\\;ti\u0016\u0014Hj\\4hKJ\fab\u00197vgR,'\u000fT8hO\u0016\u0014\b%\u0001\nbGRLg/\u001a7z\u001b>t\u0017\u000e^8sS:<\u0017AF1di&4X\r\\=N_:LGo\u001c:j]\u001e|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004m\u0006m\u0012bAA\u001fo\n!QK\\5u\u0011%\t\t%CA\u0001\u0002\u0004\tY\"A\u0002yIE\n1#Y2uSZ,G._'p]&$xN]5oO\u0002\nq#[:FqR,'O\\1m\u00072,8\u000f^3s\u001b\u0016l'-\u001a:\u0016\u0005\u0005%\u0003c\u0002<\u0002L\u0005=\u00131D\u0005\u0004\u0003\u001b:(!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY!!\u0015\n\u0007\u0005MCN\u0001\u0004NK6\u0014WM]\u0001\u0019SN,\u0005\u0010^3s]\u0006d7\t\\;ti\u0016\u0014X*Z7cKJ\u0004\u0013aD2s_N\u001cHiY*fiRLgnZ:\u0016\u0005\u0005m\u0003\u0003BA/\u0003GrA!!\u000b\u0002`%!\u0011\u0011MA\t\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018\u0002BA3\u0003O\u0012ad\u0011:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN]*fiRLgnZ:\n\u0007\u0005%DNA\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0003A\u0019'o\\:t\t\u000e\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\fde>\u001c8\u000fR2GC&dWO]3EKR,7\r^8s+\t\t\t\b\u0005\u0004\u0002t\u0005e\u0014QP\u0007\u0003\u0003kR1!a\u001eo\u0003\u0019\u0011X-\\8uK&!\u00111PA;\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u0018\u0010E\u0002}\u0003\u007fJ1!!!~\u0005\u001d\tE\r\u001a:fgN\fqc\u0019:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN\u001d\u0011\u0002\u0015M,\u0017/^3oG\u0016t%/\u0006\u0002\u0002\nB\u0019a/a#\n\u0007\u00055uO\u0001\u0003M_:<\u0017AD:fcV,gnY3Oe~#S-\u001d\u000b\u0005\u0003s\t\u0019\nC\u0005\u0002BI\t\t\u00111\u0001\u0002\n\u0006Y1/Z9vK:\u001cWM\u0014:!\u00035qW\r\u001f;IK\u0006\u0014HOQ3biR\u0011\u00111\u0014\t\u0005\u0003;\u000b\u0019K\u0004\u0003\u0002\f\u0005}\u0015bAAQY\u000612\t\\;ti\u0016\u0014\b*Z1si\n,\u0017\r^*f]\u0012,'/\u0003\u0003\u0002&\u0006\u001d&!\u0003%fCJ$(-Z1u\u0015\r\t\t\u000b\\\u0001\u0011I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016,\"!!,\u0011\t\u0005-\u0011qV\u0005\u0004\u0003cc'\u0001G\"s_N\u001cHi\u0019%fCJ$(-Z1uS:<7\u000b^1uK\u0006!B-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/Z0%KF$B!!\u000f\u00028\"I\u0011\u0011\t\f\u0002\u0002\u0003\u0007\u0011QV\u0001\u0012I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016\u0004\u0013!\u00045fCJ$(-Z1u)\u0006\u001c8.\u0006\u0002\u0002@B\u0019A0!1\n\u0007\u0005\rWPA\u0006DC:\u001cW\r\u001c7bE2,\u0017A\u00045fCJ$(-Z1u)\u0006\u001c8\u000eI\u0001\taJ,7\u000b^1siR\u0011\u0011\u0011H\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\u0005E\u0017q\u001b\t\u0004y\u0006M\u0017bAAk{\nq\u0011i\u0019;peN+G.Z2uS>t\u0007bBAm9\u0001\u0007\u0011QP\u0001\bC\u0012$'/Z:t\u0003\u001d\u0011XmY3jm\u0016,\"!a8\u0011\t\u0005\u0005\u0018q\u001d\b\u0004y\u0006\r\u0018bAAs{\u0006)\u0011i\u0019;pe&!\u0011\u0011^Av\u0005\u001d\u0011VmY3jm\u0016T1!!:~\u0003\u001d!wN]7b]R\fa!Y2uSZ,\u0017!D5oiJ|7\u000f]3di&tw-\u0001\u0003j]&$H\u0003BA\u001d\u0003oDq!!?\"\u0001\u0004\tY0\u0001\u0005t]\u0006\u00048\u000f[8u!\u0011\tiP!\u0004\u000f\t\u0005}(\u0011\u0002\b\u0005\u0005\u0003\u00119A\u0004\u0003\u0003\u0004\t\u0015Q\"\u00019\n\u0005=\u0004\u0018BA7o\u0013\r\u0011Y\u0001\\\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0005\u001f\u0011\tBA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0003\f1\f\u0011\"\u00193e\u001b\u0016l'-\u001a:\u0015\t\u0005e\"q\u0003\u0005\b\u00053\u0011\u0003\u0019AA(\u0003\u0005i\u0017\u0001\u0004:f[>4X-T3nE\u0016\u0014H\u0003BA\u001d\u0005?AqA!\u0007$\u0001\u0004\ty%A\u0005iK\u0006\u0014HOY3bi\u0006a\u0001.Z1si\n,\u0017\r\u001e*taR!\u0011\u0011\bB\u0014\u0011\u001d\u0011I#\na\u0001\u0005W\tAA\u001a:p[B!\u00111\u0002B\u0017\u0013\r\u0011y\u0003\u001c\u0002\u000e+:L\u0017/^3BI\u0012\u0014Xm]:\u0002+Q\u0014\u0018nZ4fe\u001aK'o\u001d;IK\u0006\u0014HOY3biR!\u0011\u0011\bB\u001b\u0011\u001d\u0011IC\na\u0001\u0005W\tAe]3mM&\u001b(+Z:q_:\u001c\u0018N\u00197f\r>\u00148I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r\u001e\u000b\u0003\u00037\tQEY3d_6,\u0017i\u0019;jm\u0016LeMU3ta>t7/\u001b2mK\u001a{'\u000fS3beR\u0014W-\u0019;)\u0007\u0001\u0011y\u0004\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\r\u0011)E\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B%\u0005\u0007\u00121\"\u00138uKJt\u0017\r\\!qS\u000612I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r^*f]\u0012,'\u000fE\u0002\u0002\f)\u001a\"AK;\u0015\u0005\t5#!E%ogB,7\r^5p]\u000e{W.\\1oIN!A&\u001eB,!\ra(\u0011L\u0005\u0004\u00057j(!\t(p'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8WKJLg-[2bi&|gNT3fI\u0016$'\u0001\u0004*fa>\u0014Ho\u0015;biV\u001c8CB\u0017v\u0005C\u00129\u0007E\u0002w\u0005GJ1A!\u001ax\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u001b\u0003z9!!1\u000eB;\u001d\u0011\u0011iGa\u001d\u000e\u0005\t=$\u0002\u0002B9\u0003\u000b\ta\u0001\u0010:p_Rt\u0014\"\u0001=\n\u0007\t]t/A\u0004qC\u000e\\\u0017mZ3\n\t\tm$Q\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0005o:HC\u0001BA!\r\u0011\u0019)L\u0007\u0002U\u0005!1m\u001c9z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0012\t\u0005\u0005\u001b\u00139*\u0004\u0002\u0003\u0010*!!\u0011\u0013BJ\u0003\u0011a\u0017M\\4\u000b\u0005\tU\u0015\u0001\u00026bm\u0006LAA!'\u0003\u0010\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa(\u0011\u0007Y\u0014\t+C\u0002\u0003$^\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!+\u00030B\u0019aOa+\n\u0007\t5vOA\u0002B]fD\u0011\"!\u00113\u0003\u0003\u0005\rAa(\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!.\u0011\r\t]&Q\u0018BU\u001b\t\u0011ILC\u0002\u0003<^\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yL!/\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00037\u0011)\rC\u0005\u0002BQ\n\t\u00111\u0001\u0003*\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011YIa3\t\u0013\u0005\u0005S'!AA\u0002\t}\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t}\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t-\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001c\te\u0007\"CA!q\u0005\u0005\t\u0019\u0001BU\u00031\u0011V\r]8siN#\u0018\r^;t!\r\u0011\u0019IO\n\u0006u\t\u0005(Q\u001e\t\u0007\u0005G\u0014IO!!\u000e\u0005\t\u0015(b\u0001Bto\u00069!/\u001e8uS6,\u0017\u0002\u0002Bv\u0005K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81!\u0011\u0011yO!>\u000e\u0005\tE(\u0002\u0002Bz\u0005'\u000b!![8\n\t\tm$\u0011\u001f\u000b\u0003\u0005;\fQ!\u00199qYf\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001c\t}\b\"CB\u0001}\u0005\u0005\t\u0019\u0001BA\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007\u000f\u0001BA!$\u0004\n%!11\u0002BH\u0005\u0019y%M[3di\na1\u000b^1ukN\u0014V\r]8siN!\u0001)\u001eB,S\t\u0001\u0015IA\u000bN_:LGo\u001c:j]\u001e\u001cF/\u0019;f%\u0016\u0004xN\u001d;\u0014\t\u0005+8q\u0003\t\u0004\u0005\u0007\u0003\u0015fA!C1\n\u0001Rj\u001c8ji>\u0014\u0018N\\4BGRLg/Z\n\t\u0005V\u001cyB!\u0019\u0003hA\u0019!1Q!\u0002\u000bM$\u0018\r^3\u0002\rM$\u0018\r^3!)\u0011\u00199c!\u000b\u0011\u0007\t\r%\tC\u0004\u0004\"\u0015\u0003\r!!,\u0015\t\r\u001d2Q\u0006\u0005\n\u0007C1\u0005\u0013!a\u0001\u0003[\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00044)\"\u0011QVB\u001bW\t\u00199\u0004\u0005\u0003\u0004:\r\u0005SBAB\u001e\u0015\u0011\u0019ida\u0010\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B#o&!11IB\u001e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u000b\u0005\u0005S\u001b9\u0005C\u0005\u0002B)\u000b\t\u00111\u0001\u0003 R!\u00111DB&\u0011%\t\t\u0005TA\u0001\u0002\u0004\u0011I\u000b\u0006\u0003\u0003\f\u000e=\u0003\"CA!\u001b\u0006\u0005\t\u0019\u0001BP)\u0011\tYba\u0015\t\u0013\u0005\u0005\u0003+!AA\u0002\t%&!E'p]&$xN]5oO\u0012{'/\\1oiNA\u0001,^B\u0010\u0005C\u00129\u0007\u0006\u0002\u0004\\A\u0019!1\u0011-\u0015\t\t%6q\f\u0005\n\u0003\u0003j\u0016\u0011!a\u0001\u0005?#B!a\u0007\u0004d!I\u0011\u0011I0\u0002\u0002\u0003\u0007!\u0011\u0016\u000b\u0005\u0005\u0017\u001b9\u0007C\u0005\u0002B\u0001\f\t\u00111\u0001\u0003 R!\u00111DB6\u0011%\t\teYA\u0001\u0002\u0004\u0011I+\u0001\tN_:LGo\u001c:j]\u001e\f5\r^5wKB\u0019!1\u0011*\u0014\u000bI\u001b\u0019H!<\u0011\u0011\t\r8QOAW\u0007OIAaa\u001e\u0003f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\r=D\u0003BB\u0014\u0007{Bqa!\tV\u0001\u0004\ti\u000b\u0006\u0003\u0004\u0002\u000e\u001d\u0005#\u0002<\u0004\u0004\u00065\u0016bABCo\n1q\n\u001d;j_:D\u0011b!\u0001W\u0003\u0003\u0005\raa\n\u0002#5{g.\u001b;pe&tw\rR8s[\u0006tG\u000fE\u0002\u0003\u0004\u0016\u001cR!ZBH\u0005[\u0004bAa9\u0003j\u000emCCABF)\u0011\tYb!&\t\u0013\r\u0005\u0011.!AA\u0002\rm\u0003f\u0001\u0016\u0003@!\u001a\u0011Fa\u0010")
@InternalApi
public class CrossDcHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private ActorContext context;
    private ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    @Override
    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", this.cluster().selfDataCenter());
            return;
        }
    }

    @Override
    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m3 = memberRemoved.member();
                    this.$outer.removeMember(m3);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m3 = memberRemoved.member();
                    this.$outer.removeMember(m3);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                return object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    this.$outer.sender().$bang(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant(), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof ReportStatus;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m3) {
        if (CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m3)) {
            this.dataCentersState_$eq(this.dataCentersState().addMember(m3));
            if (this.verboseHeartbeat()) {
                String string = m3.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.clusterLogger().logDebug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", m3);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
            return;
        }
    }

    public void removeMember(Member m3) {
        UniqueAddress uniqueAddress = m3.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
            return;
        }
        this.dataCentersState_$eq(this.dataCentersState().removeMember(m3));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.dataCentersState().activeReceivers().contains((Object)from) && !this.crossDcFailureDetector().isMonitoring(from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat(from.address());
            return;
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        if (activeDcs > 1) {
            return this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress());
        }
        return false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        if (!this.activelyMonitoring() && this.selfIsResponsibleForCrossDcHeartbeat()) {
            this.clusterLogger().logInfo("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
            this.activelyMonitoring_$eq(true);
            this.context().become((PartialFunction<Object, BoxedUnit>)this.active().orElse(this.introspecting()));
            return;
        }
        if (!this.activelyMonitoring()) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logInfo("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove(a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, ClusterHeartbeatSender.Heartbeat nextHB$1, UniqueAddress to) {
        Object object;
        if ($this.crossDcFailureDetector().isMonitoring(to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            object = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            object = $this.cluster().scheduler().scheduleOnce($this.crossDcSettings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang(nextHB$1, $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$(this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), new ActorWithLogClass(this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)((SortedSet)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering())));
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.crossDcSettings().HeartbeatInterval()), this.crossDcSettings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    Serializable {
        private final CrossDcHeartbeatingState state;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.state();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "state";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            return object instanceof MonitoringDormant;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    Serializable {
        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            return object instanceof ReportStatus;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

