/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.CoordinatedShutdown$IncompatibleConfigurationDetectedReason$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterUserAction;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.Invalid;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.Valid$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015cAB\u000b\u0017\u0003\u00031b\u0004\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d9\u0002A1A\u0005\u0002UBa!\u000f\u0001!\u0002\u00131\u0004b\u0002\u001e\u0001\u0005\u0004%\ta\u000f\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001f\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\"1!\n\u0001Q\u0001\n\tCqa\u0013\u0001C\u0002\u0013%\u0011\t\u0003\u0004M\u0001\u0001\u0006IA\u0011\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003B\u0011\u0019q\u0005\u0001)A\u0005\u0005\")q\n\u0001C\u0005!\")\u0001\r\u0001C\u0003C\")q\u000e\u0001C\u0003a\")\u0011\u0010\u0001C\u0003u\"9\u0011q\u0002\u0001\u0005\u0006\u0005E\u0001bBA\r\u0001\u0011%\u00111\u0004\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\ty\u0003\u0001C\u0005\u0003c\u0011qbU3fI:{G-\u001a)s_\u000e,7o\u001d\u0006\u0003/a\tqa\u00197vgR,'O\u0003\u0002\u001a5\u0005)\u0001/Z6l_*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!B\u0012!B1di>\u0014\u0018B\u0001\u0016(\u0005\u0015\t5\r^8s\u0003]Qw.\u001b8D_:4\u0017nZ\"p[B\fGo\u00115fG.,'o\u0001\u0001\u0011\u00059zS\"\u0001\f\n\u0005A2\"a\u0006&pS:\u001cuN\u001c4jO\u000e{W\u000e]1u\u0007\",7m[3s\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003]\u0001AQa\u000b\u0002A\u00025*\u0012A\u000e\t\u0003]]J!\u0001\u000f\f\u0003\u000f\rcWo\u001d;fe\u0006A1\r\\;ti\u0016\u0014\b%A\u0006tK24\u0017\t\u001a3sKN\u001cX#\u0001\u001f\u0011\u0005\u0019j\u0014B\u0001 (\u0005\u001d\tE\r\u001a:fgN\fAb]3mM\u0006#GM]3tg\u0002\n!ES8j]R{\u0017J\\2p[B\fG/\u001b2mK\u000e{gNZ5h+:,gNZ8sG\u0016$W#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00027b]\u001eT\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\t\n11\u000b\u001e:j]\u001e\f1ES8j]R{\u0017J\\2p[B\fG/\u001b2mK\u000e{gNZ5h+:,gNZ8sG\u0016$\u0007%A\u000eWC2LG-\u0019;fI&s7m\\7qCRL'\r\\3D_:4\u0017nZ\u0001\u001d-\u0006d\u0017\u000eZ1uK\u0012LenY8na\u0006$\u0018N\u00197f\u0007>tg-[4!\u0003Mqu\u000eZ3TQV$Hm\\<o/\u0006\u0014h.\u001b8h\u0003Qqu\u000eZ3TQV$Hm\\<o/\u0006\u0014h.\u001b8hA\u0005a1\u000f^8q\u001fJ\u0014UmY8nKR\u0011\u0011\u000b\u0016\t\u0003AIK!aU\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006+6\u0001\rAV\u0001\tE\u0016D\u0017M^5peB\u0019\u0001eV-\n\u0005a\u000b#AB(qi&|g\u000e\u0005\u0002[;:\u0011aeW\u0005\u00039\u001e\nQ!Q2u_JL!AX0\u0003\u000fI+7-Z5wK*\u0011AlJ\u0001\u0014e\u0016\u001cW-\u001b<f\u0015>LgnU3fI:{G-\u001a\u000b\u0003#\nDQa\u0019\bA\u0002\u0011\f\u0011b]3fI:{G-Z:\u0011\u0007\u0015dGH\u0004\u0002gUB\u0011q-I\u0007\u0002Q*\u0011\u0011\u000eL\u0001\u0007yI|w\u000e\u001e \n\u0005-\f\u0013A\u0002)sK\u0012,g-\u0003\u0002n]\n\u00191+\u001a;\u000b\u0005-\f\u0013\u0001\n:fG\u0016Lg/Z%oSRTu.\u001b8BG.LenY8na\u0006$\u0018N\u00197f\u0007>tg-[4\u0015\tE\u000b8\u000f\u001f\u0005\u0006e>\u0001\r\u0001P\u0001\u0007U>Lg\u000eV8\t\u000bQ|\u0001\u0019A;\u0002\r=\u0014\u0018nZ5o!\t1c/\u0003\u0002xO\tA\u0011i\u0019;peJ+g\rC\u0003V\u001f\u0001\u0007a+\u0001\u0012sK\u000e,\u0017N^3J]&$(j\\5o\u0003\u000e\\7i\\7qCRL'\r\\3D_:4\u0017n\u001a\u000b\u0007#ndX0!\u0004\t\u000bI\u0004\u0002\u0019\u0001\u001f\t\u000bQ\u0004\u0002\u0019A;\t\u000by\u0004\u0002\u0019A@\u0002\u0017\r|gNZ5h\u0007\",7m\u001b\t\u0005\u0003\u0003\t9AD\u0002/\u0003\u0007I1!!\u0002\u0017\u0003UIe\u000e^3s]\u0006d7\t\\;ti\u0016\u0014\u0018i\u0019;j_:LA!!\u0003\u0002\f\t\u00012i\\7qCRL'\r\\3D_:4\u0017n\u001a\u0006\u0004\u0003\u000b1\u0002\"B+\u0011\u0001\u00041\u0016!\t:fG\u0016Lg/Z%oSRTu.\u001b8BG.,fn\u00195fG.,GmQ8oM&<GcB)\u0002\u0014\u0005U\u0011q\u0003\u0005\u0006eF\u0001\r\u0001\u0010\u0005\u0006iF\u0001\r!\u001e\u0005\u0006+F\u0001\rAV\u0001\u0017Y><\u0017J\\5u\u0015>Lg.Q2l%\u0016\u001cW-\u001b<fIR\u0019\u0011+!\b\t\r\u0005}!\u00031\u0001v\u0003\u00111'o\\7\u0002U1|wmV1s]&tw-\u00138wC2LGmQ8oM&<\u0017J\u001a\"za\u0006\u001c8oQ8oM&<7\t[3dWR\u0019\u0011+!\n\t\u000f\u0005\u001d2\u00031\u0001\u0002*\u00059\u0011N\u001c<bY&$\u0007c\u0001\u0018\u0002,%\u0019\u0011Q\u0006\f\u0003\u000f%sg/\u00197jI\u0006)Bn\\4FeJ|'/\u00138wC2LGmQ8oM&<GcA)\u00024!9\u0011Q\u0007\u000bA\u0002\u0005%\u0012A\u0003<bY&$\u0017\r^5p]\"\u001a\u0001!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\niDA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public abstract class SeedNodeProcess
implements Actor {
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final Cluster cluster;
    private final Address selfAddress;
    private final String JoinToIncompatibleConfigUnenforced;
    private final String ValidatedIncompatibleConfig;
    private final String NodeShutdownWarning;
    private ActorContext context;
    private ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    private String JoinToIncompatibleConfigUnenforced() {
        return this.JoinToIncompatibleConfigUnenforced;
    }

    private String ValidatedIncompatibleConfig() {
        return this.ValidatedIncompatibleConfig;
    }

    private String NodeShutdownWarning() {
        return this.NodeShutdownWarning;
    }

    private void stopOrBecome(Option<PartialFunction<Object, BoxedUnit>> behavior) {
        Option<PartialFunction<Object, BoxedUnit>> option = behavior;
        if (option instanceof Some) {
            Some some = (Some)option;
            PartialFunction done2 = (PartialFunction)some.value();
            this.context().become((PartialFunction<Object, BoxedUnit>)done2);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.context().stop(this.self());
            return;
        }
        throw new MatchError(option);
    }

    public final void receiveJoinSeedNode(Set<Address> seedNodes) {
        Seq<String> requiredNonSensitiveKeys = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(this.joinConfigCompatChecker.requiredKeys(), this.cluster().settings());
        Config configToValidate = JoinConfigCompatChecker$.MODULE$.filterWithKeys(requiredNonSensitiveKeys, this.context().system().settings().config());
        seedNodes.foreach((Function1 & Serializable)a -> {
            SeedNodeProcess.$anonfun$receiveJoinSeedNode$1(this, configToValidate, a);
            return BoxedUnit.UNIT;
        });
    }

    public final void receiveInitJoinAckIncompatibleConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        if (this.cluster().settings().ByPassConfigCompatCheck()) {
            this.logInitJoinAckReceived(origin);
            this.cluster().ClusterLogger().logWarning("Joining cluster with incompatible configurations. {}", this.JoinToIncompatibleConfigUnenforced());
            this.context().parent().$bang(new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        this.cluster().ClusterLogger().logError(ClusterLogMarker$.MODULE$.joinFailed(), new StringBuilder(72).append("Couldn't join seed nodes because of incompatible cluster configuration. ").append(this.NodeShutdownWarning()).toString());
        this.context().stop(this.self());
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run(CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$);
    }

    public final void receiveInitJoinAckCompatibleConfig(Address joinTo, ActorRef origin, InternalClusterAction.CompatibleConfig configCheck, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        boolean bl = false;
        Invalid invalid = null;
        ConfigValidation configValidation = this.joinConfigCompatChecker.check(configCheck.clusterConfig(), this.context().system().settings().config());
        if (Valid$.MODULE$.equals(configValidation)) {
            this.context().parent().$bang(new ClusterUserAction.JoinTo(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        if (configValidation instanceof Invalid) {
            bl = true;
            invalid = (Invalid)configValidation;
            if (this.cluster().settings().ByPassConfigCompatCheck()) {
                this.logWarningInvalidConfigIfBypassConfigCheck(invalid);
                this.context().parent().$bang(new ClusterUserAction.JoinTo(joinTo), this.self());
                this.stopOrBecome(behavior);
                return;
            }
        }
        if (bl) {
            this.logErrorInvalidConfig(invalid);
            this.context().stop(this.self());
            ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run(CoordinatedShutdown$IncompatibleConfigurationDetectedReason$.MODULE$);
            return;
        }
        throw new MatchError((Object)configValidation);
    }

    public final void receiveInitJoinAckUncheckedConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        this.cluster().ClusterLogger().logWarning("Joining a cluster without configuration compatibility check feature.");
        this.context().parent().$bang(new ClusterUserAction.JoinTo(joinTo), this.self());
        this.stopOrBecome(behavior);
    }

    private void logInitJoinAckReceived(ActorRef from) {
        this.cluster().ClusterLogger().logInfo("Received InitJoinAck message from [{}] to [{}]", from, (Object)this.selfAddress());
    }

    private void logWarningInvalidConfigIfBypassConfigCheck(Invalid invalid) {
        this.cluster().ClusterLogger().logWarning("{}: {}. {}.", (Object)this.ValidatedIncompatibleConfig(), (Object)invalid.errorMessages().mkString(", "), (Object)this.JoinToIncompatibleConfigUnenforced());
    }

    private void logErrorInvalidConfig(Invalid validation) {
        this.cluster().ClusterLogger().logError("{}: {}. {}", (Object)this.ValidatedIncompatibleConfig(), (Object)validation.errorMessages().mkString(", "), (Object)this.NodeShutdownWarning());
    }

    public static final /* synthetic */ void $anonfun$receiveJoinSeedNode$1(SeedNodeProcess $this, Config configToValidate$1, Address a) {
        ActorSelection$.MODULE$.toScala($this.context().actorSelection($this.context().parent().path().toStringWithAddress(a))).$bang(new InternalClusterAction.InitJoin(configToValidate$1), $this.self());
    }

    public SeedNodeProcess(JoinConfigCompatChecker joinConfigCompatChecker) {
        this.joinConfigCompatChecker = joinConfigCompatChecker;
        Actor.$init$(this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfAddress = this.cluster().selfAddress();
        this.JoinToIncompatibleConfigUnenforced = "Join will be performed because compatibility check is configured to not be enforced.";
        this.ValidatedIncompatibleConfig = "Cluster validated this node config, but sent back incompatible settings";
        this.NodeShutdownWarning = "It's recommended to perform a full cluster shutdown in order to deploy this new version. If a cluster shutdown isn't an option, you may want to disable this protection by setting 'pekko.cluster.configuration-compatibility-check.enforce-on-join = off'. Note that disabling it will allow the formation of a cluster with nodes having incompatible configuration settings. This node will be shutdown!";
        Statics.releaseFence();
    }
}

