/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.snapshot.local;

import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.CircuitBreaker;
import org.apache.pekko.persistence.DeleteSnapshotsFailure;
import org.apache.pekko.persistence.DeleteSnapshotsSuccess;
import org.apache.pekko.persistence.Persistence;
import org.apache.pekko.persistence.SaveSnapshotFailure;
import org.apache.pekko.persistence.SaveSnapshotSuccess;
import org.apache.pekko.persistence.SelectedSnapshot;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.SnapshotSelectionCriteria;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.persistence.serialization.package$;
import org.apache.pekko.persistence.snapshot.SnapshotStore;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\r\u001da!\u0002\u001a4\u0001]z\u0004\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0001\u0004!\u0019!C\u0005C\"1!\u000e\u0001Q\u0001\n\tDqa\u001b\u0001C\u0002\u0013%A\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0011\b\u0001)A\u0005[\"91\u000f\u0001b\u0001\n\u0013!\bBB>\u0001A\u0003%Q\u000fC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u00055\u0001\u0001)A\u0005}\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111\u0005\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007fA\u0001\"a\u0013\u0001A\u0003&\u0011Q\u0005\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002 \u0002!\t%!*\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003K\u0004A\u0011CAt\u0011\u001d\ti\u000f\u0001C\t\u0003_DqA!\u0002\u0001\t#\u00119\u0001C\u0004\u0003\u0016\u0001!\tBa\u0006\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B4\u0001\u0011E!\u0011\u000e\u0005\n\u0005c\u0002\u0011\u0013!C\t\u0005gBqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\u000e\u0002!\tEa$\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"I!Q\u0013\u0001C\u0002\u0013%!q\u0013\u0005\t\u0005G\u0003\u0001\u0015!\u0003\u0003\u001a\u001a1!Q\u0015\u0001\u0007\u0005OC!\"a\u001b'\u0005\u0003\u0005\u000b\u0011BA7\u0011\u0019Yf\u0005\"\u0001\u00036\"I!1\u0018\u0014C\u0002\u0013\u0005!q\u0013\u0005\t\u0005{3\u0003\u0015!\u0003\u0003\u001a\"9!q\u0018\u0014\u0005\u0002\t\u0005gA\u0002Bh\u0001\u0019\u0011\t\u000e\u0003\u0006\u0003T2\u0012\t\u0011)A\u0005\u0003kAaa\u0017\u0017\u0005\u0002\tU\u0007b\u0002BnY\u00115!Q\u001c\u0005\b\u0005\u007fcC\u0011\u0001Bv\u0011\u001d\u0011\t\u0010\u0001C\u0005\u0005g\u0014!\u0003T8dC2\u001cf.\u00199tQ>$8\u000b^8sK*\u0011A'N\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u0003m]\n\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003qe\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011!hO\u0001\u0006a\u0016\\7n\u001c\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xm\u0005\u0003\u0001\u0001\u001aS\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\r\u0005\u0002H\u00116\tQ'\u0003\u0002Jk\ti1K\\1qg\"|Go\u0015;pe\u0016\u0004\"a\u0013(\u000e\u00031S!!T\u001d\u0002\u000b\u0005\u001cGo\u001c:\n\u0005=c%\u0001D!di>\u0014Hj\\4hS:<\u0017AB2p]\u001aLwm\u0001\u0001\u0011\u0005MKV\"\u0001+\u000b\u0005A+&B\u0001,X\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001-\u0002\u0007\r|W.\u0003\u0002[)\n11i\u001c8gS\u001e\fa\u0001P5oSRtDCA/`!\tq\u0006!D\u00014\u0011\u0015\u0001&\u00011\u0001S\u0003=1\u0015\u000e\\3oC6,\u0007+\u0019;uKJtW#\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017\u0001C7bi\u000eD\u0017N\\4\u000b\u0005\u001d\u0014\u0015\u0001B;uS2L!!\u001b3\u0003\u000bI+w-\u001a=\u0002!\u0019KG.\u001a8b[\u0016\u0004\u0016\r\u001e;fe:\u0004\u0013!\u00069feNL7\u000f^3oG\u0016LEm\u0015;beRLE\r_\u000b\u0002[B\u0011\u0011I\\\u0005\u0003_\n\u00131!\u00138u\u0003Y\u0001XM]:jgR,gnY3JIN#\u0018M\u001d;JIb\u0004\u0013aD7bq2{\u0017\rZ!ui\u0016l\u0007\u000f^:\u0002!5\f\u0007\u0010T8bI\u0006#H/Z7qiN\u0004\u0013\u0001E:ue\u0016\fW\u000eR5ta\u0006$8\r[3s+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=:\u0003!!\u0017n\u001d9bi\u000eD\u0017B\u0001>x\u0005EiUm]:bO\u0016$\u0015n\u001d9bi\u000eDWM]\u0001\u0012gR\u0014X-Y7ESN\u0004\u0018\r^2iKJ\u0004\u0013a\u00013jeV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0003S>T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0003GS2,\u0017\u0001\u00023je\u0002\nac]3sS\u0006d\u0017N_1uS>tW\t\u001f;f]NLwN\\\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033I\u0014!D:fe&\fG.\u001b>bi&|g.\u0003\u0003\u0002\u001e\u0005]!!D*fe&\fG.\u001b>bi&|g.A\ftKJL\u0017\r\\5{CRLwN\\#yi\u0016t7/[8oA\u000511/\u0019<j]\u001e,\"!!\n\u0011\r\u0005\u001d\u0012\u0011GA\u001b\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012!C5n[V$\u0018M\u00197f\u0015\r\tyCQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001a\u0003S\u00111aU3u!\u0011\t9$!\u000f\u000e\u0003]J1!a\u000f8\u0005A\u0019f.\u00199tQ>$X*\u001a;bI\u0006$\u0018-\u0001\u0006tCZLgnZ0%KF$B!!\u0011\u0002HA\u0019\u0011)a\u0011\n\u0007\u0005\u0015#I\u0001\u0003V]&$\b\"CA%!\u0005\u0005\t\u0019AA\u0013\u0003\rAH%M\u0001\bg\u00064\u0018N\\4!\u0003%aw.\u00193Bgft7\r\u0006\u0004\u0002R\u0005%\u00141\u0011\t\u0007\u0003'\nI&!\u0018\u000e\u0005\u0005U#bAA,\u0005\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0013Q\u000b\u0002\u0007\rV$XO]3\u0011\u000b\u0005\u000by&a\u0019\n\u0007\u0005\u0005$I\u0001\u0004PaRLwN\u001c\t\u0005\u0003o\t)'C\u0002\u0002h]\u0012\u0001cU3mK\u000e$X\rZ*oCB\u001c\bn\u001c;\t\u000f\u0005-$\u00031\u0001\u0002n\u0005i\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u0004B!a\u001c\u0002~9!\u0011\u0011OA=!\r\t\u0019HQ\u0007\u0003\u0003kR1!a\u001eR\u0003\u0019a$o\\8u}%\u0019\u00111\u0010\"\u0002\rA\u0013X\rZ3g\u0013\u0011\ty(!!\u0003\rM#(/\u001b8h\u0015\r\tYH\u0011\u0005\b\u0003\u000b\u0013\u0002\u0019AAD\u0003!\u0019'/\u001b;fe&\f\u0007\u0003BA\u001c\u0003\u0013K1!a#8\u0005e\u0019f.\u00199tQ>$8+\u001a7fGRLwN\\\"sSR,'/[1\u0002\u0013M\fg/Z!ts:\u001cGCBAI\u0003'\u000b9\n\u0005\u0004\u0002T\u0005e\u0013\u0011\t\u0005\b\u0003+\u001b\u0002\u0019AA\u001b\u0003!iW\r^1eCR\f\u0007B\u0002\u001c\u0014\u0001\u0004\tI\nE\u0002B\u00037K1!!(C\u0005\r\te._\u0001\fI\u0016dW\r^3Bgft7\r\u0006\u0003\u0002\u0012\u0006\r\u0006bBAK)\u0001\u0007\u0011Q\u0007\u000b\u0007\u0003#\u000b9+!+\t\u000f\u0005-T\u00031\u0001\u0002n!9\u0011QQ\u000bA\u0002\u0005\u001d\u0015!\u0006:fG\u0016Lg/\u001a)mk\u001eLg.\u00138uKJt\u0017\r\\\u000b\u0003\u0003_\u0003B!!-\u000246\t\u0001!\u0003\u0003\u00026\u0006]&a\u0002*fG\u0016Lg/Z\u0005\u0004\u0003sc%!B!di>\u0014\u0018!D:oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0003\u0002@\u0006\u0015\u0007#BA\u0014\u0003\u0003t\u0018\u0002BAb\u0003S\u00111aU3r\u0011\u001d\t)j\u0006a\u0001\u0003k\tA\u0001\\8bIR!\u00111ZAj!\u0019\ti-a4\u0002^5\ta-C\u0002\u0002R\u001a\u00141\u0001\u0016:z\u0011\u001d\t)\n\u0007a\u0001\u0003+\u0004b!a\n\u0002B\u0006U\u0002f\u0001\r\u0002ZB!\u00111\\Aq\u001b\t\tiNC\u0002\u0002`\n\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019/!8\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006!1/\u0019<f)\u0019\t\t%!;\u0002l\"9\u0011QS\rA\u0002\u0005U\u0002B\u0002\u001c\u001a\u0001\u0004\tI*A\u0006eKN,'/[1mSj,G\u0003BAy\u0003w\u0004B!a=\u0002x6\u0011\u0011Q\u001f\u0006\u0004\u000339\u0014\u0002BA}\u0003k\u0014\u0001b\u00158baNDw\u000e\u001e\u0005\b\u0003{T\u0002\u0019AA\u0000\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\u0007}\u0014\t!\u0003\u0003\u0003\u0004\u0005\u0005!aC%oaV$8\u000b\u001e:fC6\f\u0011b]3sS\u0006d\u0017N_3\u0015\r\u0005\u0005#\u0011\u0002B\n\u0011\u001d\u0011Ya\u0007a\u0001\u0005\u001b\tAb\\;uaV$8\u000b\u001e:fC6\u00042a B\b\u0013\u0011\u0011\t\"!\u0001\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\rYZ\u0002\u0019AAy\u0003A9\u0018\u000e\u001e5PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0003\u0003\u001a\t\u0015Bc\u0001@\u0003\u001c!9!Q\u0004\u000fA\u0002\t}\u0011!\u00019\u0011\u000f\u0005\u0013\tC!\u0004\u0002B%\u0019!1\u0005\"\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBAK9\u0001\u0007\u0011QG\u0001\u0010o&$\b.\u00138qkR\u001cFO]3b[V!!1\u0006B\u001a)\u0011\u0011iCa\u0011\u0015\t\t=\"q\b\t\u0005\u0005c\u0011\u0019\u0004\u0004\u0001\u0005\u000f\tURD1\u0001\u00038\t\tA+\u0005\u0003\u0003:\u0005e\u0005cA!\u0003<%\u0019!Q\b\"\u0003\u000f9{G\u000f[5oO\"9!QD\u000fA\u0002\t\u0005\u0003cB!\u0003\"\u0005}(q\u0006\u0005\b\u0003+k\u0002\u0019AA\u001b\u0003)9\u0018\u000e\u001e5TiJ,\u0017-\\\u000b\u0007\u0005\u0013\u00129F!\u0014\u0015\r\t-#\u0011\u000bB2!\u0011\u0011\tD!\u0014\u0005\u000f\t=cD1\u0001\u00038\t\t!\tC\u0004\u0003Ty\u0001\rA!\u0016\u0002\rM$(/Z1n!\u0011\u0011\tDa\u0016\u0005\u000f\tecD1\u0001\u0003\\\t\t\u0011)\u0005\u0003\u0003:\tu\u0003cA@\u0003`%!!\u0011MA\u0001\u0005%\u0019En\\:fC\ndW\rC\u0004\u0003\u001ey\u0001\rA!\u001a\u0011\u000f\u0005\u0013\tC!\u0016\u0003L\u0005!2O\\1qg\"|GOR5mK\u001a{'o\u0016:ji\u0016$RA B6\u0005[Bq!!& \u0001\u0004\t)\u0004C\u0005\u0003p}\u0001\n\u00111\u0001\u0002n\u0005IQ\r\u001f;f]NLwN\\\u0001\u001fg:\f\u0007o\u001d5pi\u001aKG.\u001a$pe^\u0013\u0018\u000e^3%I\u00164\u0017-\u001e7uII*\"A!\u001e+\t\u00055$qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00026\u0011!Q\u0010\u0006\u0005\u0005\u007f\ni.A\u0005v]\u000eDWmY6fI&!!1\u0011B?\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012g:\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u001cHCBAk\u0005\u0013\u0013Y\tC\u0004\u0002l\u0005\u0002\r!!\u001c\t\u000f\u0005\u0015\u0015\u00051\u0001\u0002\b\u0006A\u0001O]3Ti\u0006\u0014H\u000f\u0006\u0002\u0002B\u0005Y1O\\1qg\"|G\u000fR5s)\u0005q\u0018!\u00063fM\u0006,H\u000e^*zgR,W.\u00128d_\u0012LgnZ\u000b\u0003\u00053\u0003BAa'\u0003\"6\u0011!Q\u0014\u0006\u0005\u0005?\u000b)!\u0001\u0003mC:<\u0017\u0002BA@\u0005;\u000ba\u0003Z3gCVdGoU=ti\u0016lWI\\2pI&tw\r\t\u0002\u0017':\f\u0007o\u001d5pi\u001aKG.\u001a8b[\u00164\u0015\u000e\u001c;feN)aE!+\u00030B!!1\u0014BV\u0013\u0011\u0011iK!(\u0003\r=\u0013'.Z2u!\ry(\u0011W\u0005\u0005\u0005g\u000b\tA\u0001\bGS2,g.Y7f\r&dG/\u001a:\u0015\t\t]&\u0011\u0018\t\u0004\u0003c3\u0003bBA6Q\u0001\u0007\u0011QN\u0001\u0015K:\u001cw\u000eZ3e!\u0016\u00148/[:uK:\u001cW-\u00133\u0002+\u0015t7m\u001c3fIB+'o]5ti\u0016t7-Z%eA\u00051\u0011mY2faR$bAa1\u0003J\n-\u0007cA!\u0003F&\u0019!q\u0019\"\u0003\u000f\t{w\u000e\\3b]\")Ap\u000ba\u0001}\"9!QZ\u0016A\u0002\u00055\u0014\u0001\u00028b[\u0016\u00141d\u00158baNDw\u000e^*fc:\u0013h)\u001b7f]\u0006lWMR5mi\u0016\u00148#\u0002\u0017\u0003*\n=\u0016AA7e)\u0011\u00119N!7\u0011\u0007\u0005EF\u0006C\u0004\u0003T:\u0002\r!!\u000e\u0002\u000f5\fGo\u00195fgRA!1\u0019Bp\u0005G\u00149\u000fC\u0004\u0003b>\u0002\r!!\u001c\u0002\u0007ALG\rC\u0004\u0003f>\u0002\r!!\u001c\u0002\u0007Mt'\u000fC\u0004\u0003j>\u0002\r!!\u001c\u0002\u0007Ql7\u000f\u0006\u0004\u0003D\n5(q\u001e\u0005\u0006yB\u0002\rA \u0005\b\u0005\u001b\u0004\u0004\u0019AA7\u0003=)\u0007\u0010\u001e:bGRlU\r^1eCR\fG\u0003\u0002B{\u0007\u0007\u0001R!QA0\u0005o\u0004\u0012\"\u0011B}\u0003[\u0012iP!@\n\u0007\tm(I\u0001\u0004UkBdWm\r\t\u0004\u0003\n}\u0018bAB\u0001\u0005\n!Aj\u001c8h\u0011\u001d\u0019)!\ra\u0001\u0003[\n\u0001BZ5mK:\fW.\u001a")
public class LocalSnapshotStore
implements SnapshotStore {
    private final Regex org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    private final int org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    private final int maxLoadAttempts;
    private final MessageDispatcher streamDispatcher;
    private final File dir;
    private final Serialization serializationExtension;
    private Set<SnapshotMetadata> org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving;
    private final String org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding;
    private Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    private boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    private CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    private PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    @Override
    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$(this);
    }

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public Persistence org$apache$pekko$persistence$snapshot$SnapshotStore$$extension() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension;
    }

    @Override
    public boolean org$apache$pekko$persistence$snapshot$SnapshotStore$$publish() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish;
    }

    @Override
    public CircuitBreaker org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker() {
        return this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker;
    }

    @Override
    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    @Override
    public final void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    @Override
    public final void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    @Override
    public final void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.org$apache$pekko$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    @Override
    public final void org$apache$pekko$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Regex org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern() {
        return this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    }

    public int org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() {
        return this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    }

    private int maxLoadAttempts() {
        return this.maxLoadAttempts;
    }

    private MessageDispatcher streamDispatcher() {
        return this.streamDispatcher;
    }

    private File dir() {
        return this.dir;
    }

    private Serialization serializationExtension() {
        return this.serializationExtension;
    }

    public Set<SnapshotMetadata> org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving() {
        return this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving;
    }

    public void org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq(Set<SnapshotMetadata> x$1) {
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = x$1;
    }

    @Override
    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq metadata = (Seq)((IterableOps)this.snapshotMetadatas(persistenceId, criteria).sorted(SnapshotMetadata$.MODULE$.ordering())).takeRight(this.maxLoadAttempts());
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Try<Option<SelectedSnapshot>> try_ = this.load((Seq<SnapshotMetadata>)metadata);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Option s2 = (Option)success.value();
                return s2;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }, (ExecutionContext)this.streamDispatcher()).recoverWith((PartialFunction)new Serializable(this, persistenceId, criteria){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalSnapshotStore $outer;
            private final String persistenceId$1;
            private final SnapshotSelectionCriteria criteria$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchFileException) {
                    return (B1)this.$outer.loadAsync(this.persistenceId$1, this.criteria$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof NoSuchFileException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.persistenceId$1 = persistenceId$1;
                this.criteria$1 = criteria$1;
            }
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving().$plus((Object)metadata)));
        Future completion = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.save(metadata, snapshot), (ExecutionContext)this.streamDispatcher());
        return completion;
    }

    @Override
    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
        return Future$.MODULE$.apply((Function0 & Serializable)() -> (Seq)this.snapshotFiles(metadata).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete())), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable)x$3 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$3(x$3);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq<SnapshotMetadata> metadatas = this.snapshotMetadatas(persistenceId, criteria);
        return Future$.MODULE$.sequence((IterableOnce)metadatas.map((Function1 & Serializable)metadata -> this.deleteAsync((SnapshotMetadata)metadata)), IterableFactory$.MODULE$.toBuildFrom((IterableFactory)IndexedSeq$.MODULE$), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable)x$4 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$5(x$4);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalSnapshotStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SaveSnapshotSuccess) {
                    SaveSnapshotSuccess saveSnapshotSuccess = (SaveSnapshotSuccess)A1;
                    SnapshotMetadata metadata = saveSnapshotSuccess.metadata();
                    this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof SaveSnapshotFailure) {
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DeleteSnapshotsSuccess) {
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DeleteSnapshotsFailure) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof SaveSnapshotSuccess) {
                    return true;
                }
                if (object instanceof SaveSnapshotFailure) {
                    return true;
                }
                if (object instanceof DeleteSnapshotsSuccess) {
                    return true;
                }
                return object instanceof DeleteSnapshotsFailure;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private Seq<File> snapshotFiles(SnapshotMetadata metadata) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.snapshotDir().listFiles(new SnapshotSeqNrFilenameFilter(this, metadata))).toVector();
    }

    private Try<Option<SelectedSnapshot>> load(Seq<SnapshotMetadata> metadata) {
        Option option;
        block4: {
            Try try_;
            while (true) {
                if (None$.MODULE$.equals(option = metadata.lastOption())) {
                    return new Success((Object)None$.MODULE$);
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                SnapshotMetadata md = (SnapshotMetadata)some.value();
                try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Snapshot)this.withInputStream(md, (Function1 & Serializable)inputStream -> this.deserialize((InputStream)inputStream)));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Snapshot s2 = (Snapshot)success.value();
                    return new Success((Object)new Some((Object)new SelectedSnapshot(md, s2.data())));
                }
                if (!(try_ instanceof Failure)) break;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Seq remaining = (Seq)metadata.init();
                this.log().error(e, "Error loading snapshot [{}], remaining attempts: [{}]", (Object)md, (Object)BoxesRunTime.boxToInteger((int)remaining.size()));
                if (remaining.isEmpty()) {
                    return new Failure(e);
                }
                metadata = remaining;
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    public void save(SnapshotMetadata metadata, Object snapshot) {
        File tmpFile = this.withOutputStream(metadata, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)x$5 -> {
            this.serialize(x$5, new Snapshot(snapshot));
            return BoxedUnit.UNIT;
        });
        tmpFile.renameTo(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()));
    }

    public Snapshot deserialize(InputStream inputStream) {
        return (Snapshot)this.serializationExtension().deserialize(package$.MODULE$.streamToBytes(inputStream), Snapshot.class).get();
    }

    public void serialize(OutputStream outputStream, Snapshot snapshot) {
        outputStream.write((byte[])this.serializationExtension().serialize(snapshot).get());
    }

    public File withOutputStream(SnapshotMetadata metadata, Function1<OutputStream, BoxedUnit> p) {
        File tmpFile = this.snapshotFileForWrite(metadata, "tmp");
        this.withStream(new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0])), p);
        return tmpFile;
    }

    private <T> T withInputStream(SnapshotMetadata metadata, Function1<InputStream, T> p) {
        return this.withStream(new BufferedInputStream(Files.newInputStream(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()).toPath(), new OpenOption[0])), p);
    }

    private <A extends Closeable, B> B withStream(A stream, Function1<A, B> p) {
        Object object;
        try {
            object = p.apply(stream);
        }
        finally {
            stream.close();
        }
        return (B)object;
    }

    public File snapshotFileForWrite(SnapshotMetadata metadata, String extension) {
        return new File(this.snapshotDir(), new StringBuilder(11).append("snapshot-").append(URLEncoder.encode(metadata.persistenceId(), ByteString$.MODULE$.UTF_8())).append("-").append(metadata.sequenceNr()).append("-").append(metadata.timestamp()).append(extension).toString());
    }

    public String snapshotFileForWrite$default$2() {
        return "";
    }

    private Seq<SnapshotMetadata> snapshotMetadatas(String persistenceId, SnapshotSelectionCriteria criteria) {
        File[] files = this.snapshotDir().listFiles(new SnapshotFilenameFilter(persistenceId));
        if (files == null) {
            return Nil$.MODULE$;
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)x$6 -> x$6.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)filename -> this.extractMetadata((String)filename).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                String pid = (String)tuple3._1();
                long snr = BoxesRunTime.unboxToLong((Object)tuple3._2());
                long tms = BoxesRunTime.unboxToLong((Object)tuple3._3());
                return SnapshotMetadata$.MODULE$.apply(URLDecoder.decode(pid, ByteString$.MODULE$.UTF_8()), snr, tms);
            }
            throw new MatchError((Object)tuple3);
        }), ClassTag$.MODULE$.apply(SnapshotMetadata.class))), (Function1 & Serializable)md -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$snapshotMetadatas$4(this, criteria, md)))).toVector();
    }

    @Override
    public void preStart() {
        this.snapshotDir();
        Actor.preStart$(this);
    }

    private File snapshotDir() {
        if (!(this.dir().isDirectory() || this.dir().mkdirs() || this.dir().isDirectory())) {
            throw new IOException(new StringBuilder(38).append("Failed to create snapshot directory [").append(this.dir().getCanonicalPath()).append("]").toString());
        }
        return this.dir();
    }

    public String org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding() {
        return this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding;
    }

    private Option<Tuple3<String, Object, Object>> extractMetadata(String filename) {
        int sequenceNumberEndIdx = filename.lastIndexOf(45);
        int persistenceIdEndIdx = filename.lastIndexOf(45, sequenceNumberEndIdx - 1);
        String timestampString = filename.substring(sequenceNumberEndIdx + 1);
        if (this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() >= persistenceIdEndIdx || StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(timestampString), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$extractMetadata$1(BoxesRunTime.unboxToChar((Object)x$7))))) {
            return None$.MODULE$;
        }
        String persistenceId = filename.substring(this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx(), persistenceIdEndIdx);
        long sequenceNumber = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(persistenceIdEndIdx + 1, sequenceNumberEndIdx)));
        long timestamp = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(filename.substring(sequenceNumberEndIdx + 1)));
        return new Some((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNumber), (Object)BoxesRunTime.boxToLong((long)timestamp)));
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$3(Seq x$3) {
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(IndexedSeq x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$snapshotMetadatas$4(LocalSnapshotStore $this, SnapshotSelectionCriteria criteria$2, SnapshotMetadata md) {
        return criteria$2.matches(md) && !$this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving().contains((Object)md);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadata$1(char x$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$7));
    }

    public LocalSnapshotStore(Config config) {
        Actor.$init$(this);
        ActorLogging.$init$(this);
        SnapshotStore.$init$(this);
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^snapshot-(.+)-(\\d+)-(\\d+)"));
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx = 9;
        this.maxLoadAttempts = BoxesRunTime.unboxToInt((Object)Helpers$Requiring$.MODULE$.requiring$extension(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)config.getInt("max-load-attempts"))), (JFunction1.mcZI.sp & Serializable)x$1 -> x$1 > 1, (Function0<Object>)(Function0 & Serializable)() -> "max-load-attempts must be >= 1"));
        this.streamDispatcher = this.context().system().dispatchers().lookup(config.getString("stream-dispatcher"));
        this.dir = new File(config.getString("dir"));
        this.serializationExtension = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$saving = Set$.MODULE$.empty();
        this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding = System.getProperty("file.encoding");
        Statics.releaseFence();
    }

    private final class SnapshotFilenameFilter
    implements FilenameFilter {
        private final String encodedPersistenceId;

        public String encodedPersistenceId() {
            return this.encodedPersistenceId;
        }

        @Override
        public boolean accept(File dir, String name) {
            int persistenceIdEndIdx = name.lastIndexOf(45, name.lastIndexOf(45) - 1);
            return LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() + this.encodedPersistenceId().length() == persistenceIdEndIdx && name.startsWith(this.encodedPersistenceId(), LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx());
        }

        public SnapshotFilenameFilter(String persistenceId) {
            if (LocalSnapshotStore.this == null) {
                throw null;
            }
            this.encodedPersistenceId = URLEncoder.encode(persistenceId, LocalSnapshotStore.this.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding());
        }
    }

    private final class SnapshotSeqNrFilenameFilter
    implements FilenameFilter {
        private final SnapshotMetadata md;
        private final /* synthetic */ LocalSnapshotStore $outer;

        private final boolean matches(String pid, String snr, String tms) {
            return pid.equals(URLEncoder.encode(this.md.persistenceId(), this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$defaultSystemEncoding())) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(snr)) == $this.md.sequenceNr() && ($this.md.timestamp() == 0L || StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(tms)) == $this.md.timestamp())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        }

        @Override
        public boolean accept(File dir, String name) {
            Option option;
            String string = name;
            if (string != null && !(option = this.$outer.org$apache$pekko$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
                String pid = (String)((LinearSeqOps)option.get()).apply(0);
                String snr = (String)((LinearSeqOps)option.get()).apply(1);
                String tms = (String)((LinearSeqOps)option.get()).apply(2);
                return this.matches(pid, snr, tms);
            }
            return false;
        }

        public SnapshotSeqNrFilenameFilter(LocalSnapshotStore $outer, SnapshotMetadata md) {
            this.md = md;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

