/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import org.apache.pekko.remote.artery.CacheStatistics;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055cA\u0002\r\u001a\u0003\u0003i2\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003.\u0011!\u0001\u0004A!A!\u0002\u0013i\u0003\u0002C\u0019\u0001\u0005\u0007\u0005\u000b1\u0002\u001a\t\u0011\u0001\u0003!1!Q\u0001\f\u0005CQ!\u0012\u0001\u0005\u0002\u0019CaA\u0014\u0001!\u0002\u0013i\u0003BB(\u0001A\u0003&Q\u0006\u0003\u0004Q\u0001\u0001\u0006I!\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B+\t\rY\u0003\u0001\u0015!\u0003X\u0011\u0019A\u0006\u0001)A\u0005/\")\u0011\f\u0001C\u00035\")\u0001\r\u0001C\u0003C\")Q\r\u0001C\u0003M\")\u0001\u000e\u0001C\u0005S\")a\u000f\u0001C\u0005o\")a\u000f\u0001C\tu\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u0007\u0001\r#\tY\u0002C\u0004\u0002 \u00011\t\"!\t\t\u000f\u0005\u0015\u0002A\"\u0005\u0002(!9\u0011\u0011\u0007\u0001\u0007\u0012\u0005M\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0002\u0010\u0019J,(i\\;oI\u0016$7)Y2iK*\u0011!dG\u0001\u0007CJ$XM]=\u000b\u0005qi\u0012A\u0002:f[>$XM\u0003\u0002\u001f?\u0005)\u0001/Z6l_*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h+\r!#hQ\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017\u0001C2ba\u0006\u001c\u0017\u000e^=\u0004\u0001A\u0011aEL\u0005\u0003_\u001d\u00121!\u00138u\u0003E)g/[2u\u0003\u001e,G\u000b\u001b:fg\"|G\u000eZ\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA\u001a7q5\tAG\u0003\u00026O\u00059!/\u001a4mK\u000e$\u0018BA\u001c5\u0005!\u0019E.Y:t)\u0006<\u0007CA\u001d;\u0019\u0001!Qa\u000f\u0001C\u0002q\u0012\u0011aS\t\u0003{\u0015\u0002\"A\n \n\u0005}:#a\u0002(pi\"LgnZ\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u001a7\u0005B\u0011\u0011h\u0011\u0003\u0006\t\u0002\u0011\r\u0001\u0010\u0002\u0002-\u00061A(\u001b8jiz\"2a\u0012'N)\rA%j\u0013\t\u0005\u0013\u0002A$)D\u0001\u001a\u0011\u0015\tT\u0001q\u00013\u0011\u0015\u0001U\u0001q\u0001B\u0011\u0015YS\u00011\u0001.\u0011\u0015\u0001T\u00011\u0001.\u0003\u0011i\u0015m]6\u0002\u000b\u0015\u0004xn\u00195\u0002\t-,\u0017p\u001d\t\u0004MIC\u0014BA*(\u0005\u0015\t%O]1z\u0003\u00191\u0018\r\\;fgB\u0019aE\u0015\"\u0002\r!\f7\u000f[3t!\r1#+L\u0001\u0007KB|7\r[:\u0002\u0007\u001d,G\u000f\u0006\u0002\\=B\u0019a\u0005\u0018\"\n\u0005u;#AB(qi&|g\u000eC\u0003`\u0019\u0001\u0007\u0001(A\u0001l\u0003\u0015\u0019H/\u0019;t+\u0005\u0011\u0007CA%d\u0013\t!\u0017DA\bDC\u000eDWm\u0015;bi&\u001cH/[2t\u000319W\r^(s\u0007>l\u0007/\u001e;f)\t\u0011u\rC\u0003`\u001d\u0001\u0007\u0001(\u0001\u0005sK6|g/Z!u)\tQW\u000e\u0005\u0002'W&\u0011An\n\u0002\u0005+:LG\u000fC\u0003o\u001f\u0001\u0007Q&\u0001\u0005q_NLG/[8oQ\ty\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002tO\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005U\u0014(a\u0002;bS2\u0014XmY\u0001\u0010aJ|'-\u001a#jgR\fgnY3PMR\u0011Q\u0006\u001f\u0005\u0006sB\u0001\r!L\u0001\u0005g2|G\u000fF\u0002.wvDQ\u0001`\tA\u00025\n\u0011\"\u001b3fC2\u001cFn\u001c;\t\u000by\f\u0002\u0019A\u0017\u0002\u0015\u0005\u001cG/^1m'2|G/\u0001\u0003n_Z,G#\u00046\u0002\u0004\u0005\u0015\u0011qAA\u0006\u0003\u001f\t\u0019\u0002C\u0003o%\u0001\u0007Q\u0006C\u0003`%\u0001\u0007\u0001\b\u0003\u0004\u0002\nI\u0001\r!L\u0001\u0002Q\"1\u0011Q\u0002\nA\u0002\t\u000bQA^1mk\u0016Da!!\u0005\u0013\u0001\u0004i\u0013!C3mK6,\u0005o\\2i\u0011\u0019\t)B\u0005a\u0001[\u0005i\u0001O]8cK\u0012K7\u000f^1oG\u0016D#A\u00059\u0002\u000f\r|W\u000e];uKR\u0019!)!\b\t\u000b}\u001b\u0002\u0019\u0001\u001d\u0002\t!\f7\u000f\u001b\u000b\u0004[\u0005\r\u0002\"B0\u0015\u0001\u0004A\u0014AD5t\u0017\u0016L8)Y2iK\u0006\u0014G.\u001a\u000b\u0005\u0003S\ty\u0003E\u0002'\u0003WI1!!\f(\u0005\u001d\u0011un\u001c7fC:DQaX\u000bA\u0002a\n1\"[:DC\u000eDW-\u00192mKR!\u0011\u0011FA\u001b\u0011\u0019\t9D\u0006a\u0001\u0005\u0006\ta/\u0001\u0005u_N#(/\u001b8h)\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\nAA[1wC&!\u00111JA!\u0005\u0019\u0019FO]5oO\u0002")
public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    private final int evictAgeThreshold;
    private final int Mask;
    private int epoch;
    private final K[] keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public final Option<V> get(K k) {
        int h2 = this.hash(k);
        return this.find$1(h2 & this.Mask, 0, h2, k);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return new CacheStatistics(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        if (!this.isKeyCacheable(k)) {
            return this.compute(k);
        }
        int h2 = this.hash(k);
        ++this.epoch;
        return (V)this.findOrCalculate$1(h2 & this.Mask, 0, k, h2);
    }

    private void removeAt(int position) {
        while (true) {
            int next2;
            if (this.values[next2 = position + 1 & this.Mask] == null || this.probeDistanceOf(next2) == 0) break;
            this.keys[position] = this.keys[next2];
            this.values[position] = this.values[next2];
            this.hashes[position] = this.hashes[next2];
            this.epochs[position] = this.epochs[next2];
            position = next2;
        }
        this.values[position] = null;
    }

    private int probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.Mask;
    }

    private void move(int position, K k, int h2, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) break;
            int otherEpoch = this.epochs[position];
            if (this.epoch - otherEpoch >= this.evictAgeThreshold) {
                this.removeAt(position);
                int n = h2 & this.Mask;
                probeDistance = 0;
                position = n;
                continue;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                K otherKey = this.keys[position];
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                this.keys[position] = k;
                this.values[position] = value;
                this.hashes[position] = h2;
                this.epochs[position] = elemEpoch;
                probeDistance = otherProbeDistance + 1;
                elemEpoch = otherEpoch2;
                value = otherValue;
                h2 = otherHash;
                k = otherKey;
                position = position + 1 & this.Mask;
                continue;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        this.keys[position] = k;
        this.values[position] = value;
        this.hashes[position] = h2;
        this.epochs[position] = elemEpoch;
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isKeyCacheable(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        return new StringBuilder(65).append("LruBoundedCache(").append(" values = ").append(Predef$.MODULE$.wrapRefArray((Object[])this.values).mkString("[", ",", "]")).append(",").append(" hashes = ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.hashes), (Function1)(JFunction1.mcII.sp & Serializable)x$1 -> x$1 & $this.Mask, (ClassTag)ClassTag$.MODULE$.Int())).mkString("[", ",", "]")).append(",").append(" epochs = ").append(Predef$.MODULE$.wrapIntArray(this.epochs).mkString("[", ",", "]")).append(",").append(" distances = ").append(ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.intArrayOps(this.hashes)).map((Function1)(JFunction1.mcII.sp & Serializable)slot -> this.probeDistanceOf(slot)).mkString("[", ",", "]")).append(",").append(" ").append(this.epoch).append(")").toString();
    }

    private final Option find$1(int position, int probeDistance, int h$1, Object k$1) {
        while (true) {
            int otherProbeDistance = this.probeDistanceOf(position);
            if (this.values[position] == null) {
                return None$.MODULE$;
            }
            if (probeDistance > otherProbeDistance) {
                return None$.MODULE$;
            }
            if (this.hashes[position] == h$1 && BoxesRunTime.equals((Object)k$1, this.keys[position])) {
                return new Some(this.values[position]);
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
    }

    private final Object findOrCalculate$1(int position, int probeDistance, Object k$2, int h$2) {
        while (true) {
            if (this.values[position] == null) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.keys[position] = k$2;
                    this.values[position] = value;
                    this.hashes[position] = h$2;
                    this.epochs[position] = this.epoch;
                }
                return value;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            if (probeDistance > otherProbeDistance) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.move(position, k$2, h$2, value, this.epoch, probeDistance);
                }
                return value;
            }
            if (this.hashes[position] == h$2 && BoxesRunTime.equals((Object)k$2, this.keys[position])) {
                this.epochs[position] = this.epoch;
                return this.values[position];
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
    }

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, (Function0 & Serializable)() -> "Capacity must be larger than zero");
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, (Function0 & Serializable)() -> "Capacity must be power of two");
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, (Function0 & Serializable)() -> "Age threshold must be less than capacity.");
        this.Mask = capacity - 1;
        this.epoch = 0x7FFFFFFE;
        this.keys = (Object[])Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = new int[capacity];
        this.epochs = (int[])Array$.MODULE$.fill(capacity, (Function0)(JFunction0.mcI.sp & Serializable)() -> $this.epoch - $this.evictAgeThreshold, (ClassTag)ClassTag$.MODULE$.Int());
    }
}

