/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.serialization;

import java.io.NotSerializableException;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.sysmsg.Create;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.Failed;
import org.apache.pekko.dispatch.sysmsg.NoMessage$;
import org.apache.pekko.dispatch.sysmsg.Recreate;
import org.apache.pekko.dispatch.sysmsg.Resume;
import org.apache.pekko.dispatch.sysmsg.Supervise;
import org.apache.pekko.dispatch.sysmsg.Suspend;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Terminate;
import org.apache.pekko.dispatch.sysmsg.Unwatch;
import org.apache.pekko.dispatch.sysmsg.Watch;
import org.apache.pekko.remote.ContainerFormats;
import org.apache.pekko.remote.SystemMessageFormats;
import org.apache.pekko.remote.serialization.WrappedPayloadSupport;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\b\u0011\u0001mA\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!)\u0001\u0007\u0001C\u0001c!A\u0011\u0003\u0001EC\u0002\u0013%Q\u0007C\u0004:\u0001\t\u0007I\u0011\u0002\u001e\t\ry\u0002\u0001\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\t92+_:uK6lUm]:bO\u0016\u001cVM]5bY&TXM\u001d\u0006\u0003#I\tQb]3sS\u0006d\u0017N_1uS>t'BA\n\u0015\u0003\u0019\u0011X-\\8uK*\u0011QCF\u0001\u0006a\u0016\\7n\u001c\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0015j\u0011\u0001\n\u0006\u0003#QI!A\n\u0013\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\u000611/_:uK6,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003YQ\tQ!Y2u_JL!AL\u0016\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"\u0001\t\t\u000b\u001d\u001a\u0001\u0019A\u0015\u0016\u0003Y\u0002\"aI\u001c\n\u0005a\"#!D*fe&\fG.\u001b>bi&|g.\u0001\bqCfdw.\u00193TkB\u0004xN\u001d;\u0016\u0003m\u0002\"a\r\u001f\n\u0005u\u0002\"!F,sCB\u0004X\r\u001a)bs2|\u0017\rZ*vaB|'\u000f^\u0001\u0010a\u0006LHn\\1e'V\u0004\bo\u001c:uA\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u0001B!\ti\")\u0003\u0002D=\t9!i\\8mK\u0006t\u0017\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0005\u0019c\u0005cA\u000fH\u0013&\u0011\u0001J\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003;)K!a\u0013\u0010\u0003\t\tKH/\u001a\u0005\u0006\u001b\"\u0001\r\u0001H\u0001\u0002_\u0006QaM]8n\u0005&t\u0017M]=\u0015\u0007q\u0001&\u000bC\u0003R\u0013\u0001\u0007a)A\u0003csR,7\u000fC\u0003T\u0013\u0001\u0007A+\u0001\u0005nC:Lg-Z:u!\riRkV\u0005\u0003-z\u0011aa\u00149uS>t\u0007G\u0001-f!\rI\u0006m\u0019\b\u00035z\u0003\"a\u0017\u0010\u000e\u0003qS!!\u0018\u000e\u0002\rq\u0012xn\u001c;?\u0013\tyf$\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014Qa\u00117bgNT!a\u0018\u0010\u0011\u0005\u0011,G\u0002\u0001\u0003\nMJ\u000b\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00132#\tA7\u000e\u0005\u0002\u001eS&\u0011!N\b\u0002\b\u001d>$\b.\u001b8h!\tiB.\u0003\u0002n=\t\u0019\u0011I\\=\u00021\u0011,7/\u001a:jC2L'0Z*zgR,W.T3tg\u0006<W\r\u0006\u0002qqB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0007gf\u001cXn]4\u000b\u0005U$\u0012\u0001\u00033jgB\fGo\u00195\n\u0005]\u0014(!D*zgR,W.T3tg\u0006<W\rC\u0003t\u0015\u0001\u0007\u0011\u0010\u0005\u0002{}:\u00111\u0010`\u0007\u0002%%\u0011QPE\u0001\u0015'f\u001cH/Z7NKN\u001c\u0018mZ3G_Jl\u0017\r^:\n\u0005]|(BA?\u0013\u0003I\u0019XM]5bY&TX\r\u00165s_^\f'\r\\3\u0015\t\u0005\u0015\u00111\u0004\t\u0005\u0003\u000f\t)B\u0004\u0003\u0002\n\u0005=abA>\u0002\f%\u0019\u0011Q\u0002\n\u0002!\r{g\u000e^1j]\u0016\u0014hi\u001c:nCR\u001c\u0018\u0002BA\t\u0003'\tq\u0001U1zY>\fGMC\u0002\u0002\u000eIIA!a\u0006\u0002\u001a\t9!)^5mI\u0016\u0014(\u0002BA\t\u0003'Aq!!\b\f\u0001\u0004\ty\"A\u0005uQJ|w/\u00192mKB!\u0011\u0011EA\u0016\u001d\u0011\t\u0019#a\n\u000f\u0007m\u000b)#C\u0001 \u0013\r\tICH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0013QC'o\\<bE2,'bAA\u0015=\u0005\tr-\u001a;DCV\u001cX\r\u00165s_^\f'\r\\3\u0015\t\u0005}\u0011Q\u0007\u0005\u0007\u0003oa\u0001\u0019A=\u0002\u00075\u001cx-A\ttKJL\u0017\r\\5{K\u0006\u001bGo\u001c:SK\u001a$B!!\u0010\u0002JA!\u0011qHA#\u001d\u0011\tI!!\u0011\n\t\u0005\r\u00131C\u0001\t\u0003\u000e$xN\u001d*fM&!\u0011qCA$\u0015\u0011\t\u0019%a\u0005\t\u000f\u0005-S\u00021\u0001\u0002N\u0005A\u0011m\u0019;peJ+g\rE\u0002+\u0003\u001fJ1!!\u0015,\u0005!\t5\r^8s%\u00164\u0017a\u00053fg\u0016\u0014\u0018.\u00197ju\u0016\f5\r^8s%\u00164G\u0003BA'\u0003/Bq!!\u0017\u000f\u0001\u0004\tY&A\u0007tKJL\u0017\r\\5{K\u0012\u0014VM\u001a\t\u0005\u0003\u0013\ti&\u0003\u0003\u0002R\u0005M\u0001")
public class SystemMessageSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final WrappedPayloadSupport payloadSupport;
    private int identifier;
    private volatile boolean bitmap$0;

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        SystemMessageSerializer systemMessageSerializer = this;
        synchronized (systemMessageSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private WrappedPayloadSupport payloadSupport() {
        return this.payloadSupport;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toBinary(Object o) {
        SystemMessageFormats.SystemMessage.Builder builder = SystemMessageFormats.SystemMessage.newBuilder();
        SystemMessage systemMessage = (SystemMessage)o;
        if (systemMessage instanceof Create) {
            Create create = (Create)systemMessage;
            Option<ActorInitializationException> failure = create.failure();
            builder.setType(SystemMessageFormats.SystemMessage.Type.CREATE);
            Option<ActorInitializationException> option = failure;
            if (option instanceof Some) {
                Some some = (Some)option;
                ActorInitializationException throwable = (ActorInitializationException)some.value();
                builder.setCauseData(this.serializeThrowable(throwable));
                return builder.build().toByteArray();
            } else if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Recreate) {
            Recreate recreate = (Recreate)systemMessage;
            Throwable cause = recreate.cause();
            builder.setType(SystemMessageFormats.SystemMessage.Type.RECREATE);
            builder.setCauseData(this.serializeThrowable(cause));
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Suspend) {
            builder.setType(SystemMessageFormats.SystemMessage.Type.SUSPEND);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Resume) {
            Resume resume = (Resume)systemMessage;
            Throwable cause = resume.causedByFailure();
            builder.setType(SystemMessageFormats.SystemMessage.Type.RESUME);
            builder.setCauseData(this.serializeThrowable(cause));
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Terminate) {
            builder.setType(SystemMessageFormats.SystemMessage.Type.TERMINATE);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Supervise) {
            Supervise supervise = (Supervise)systemMessage;
            ActorRef child = supervise.child();
            boolean async = supervise.async();
            builder.setType(SystemMessageFormats.SystemMessage.Type.SUPERVISE);
            SystemMessageFormats.SuperviseData.Builder superviseData = SystemMessageFormats.SuperviseData.newBuilder().setChild(this.serializeActorRef(child)).setAsync(async);
            builder.setSuperviseData(superviseData);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Watch) {
            Watch watch = (Watch)systemMessage;
            InternalActorRef watchee = watch.watchee();
            InternalActorRef watcher = watch.watcher();
            builder.setType(SystemMessageFormats.SystemMessage.Type.WATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder.setWatchData(watchData);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Unwatch) {
            Unwatch unwatch = (Unwatch)systemMessage;
            ActorRef watchee = unwatch.watchee();
            ActorRef watcher = unwatch.watcher();
            builder.setType(SystemMessageFormats.SystemMessage.Type.UNWATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder.setWatchData(watchData);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof Failed) {
            Failed failed = (Failed)systemMessage;
            ActorRef child = failed.child();
            Throwable cause = failed.cause();
            int uid = failed.uid();
            builder.setType(SystemMessageFormats.SystemMessage.Type.FAILED);
            SystemMessageFormats.FailedData.Builder failedData = SystemMessageFormats.FailedData.newBuilder().setChild(this.serializeActorRef(child)).setUid(uid);
            builder.setCauseData(this.serializeThrowable(cause));
            builder.setFailedData(failedData);
            return builder.build().toByteArray();
        } else if (systemMessage instanceof DeathWatchNotification) {
            DeathWatchNotification deathWatchNotification = (DeathWatchNotification)systemMessage;
            ActorRef actor = deathWatchNotification.actor();
            boolean existenceConfirmed = deathWatchNotification.existenceConfirmed();
            boolean addressTerminated = deathWatchNotification.addressTerminated();
            builder.setType(SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION);
            SystemMessageFormats.DeathWatchNotificationData.Builder deathWatchNotificationData = SystemMessageFormats.DeathWatchNotificationData.newBuilder().setActor(this.serializeActorRef(actor)).setExistenceConfirmed(existenceConfirmed).setAddressTerminated(addressTerminated);
            builder.setDwNotificationData(deathWatchNotificationData);
            return builder.build().toByteArray();
        } else {
            if (!NoMessage$.MODULE$.equals(systemMessage)) throw new MatchError((Object)systemMessage);
            throw new IllegalArgumentException("NoMessage should never be serialized or deserialized");
        }
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return this.deserializeSystemMessage(SystemMessageFormats.SystemMessage.parseFrom(bytes));
    }

    private SystemMessage deserializeSystemMessage(SystemMessageFormats.SystemMessage sysmsg) {
        SystemMessageFormats.SystemMessage.Type type = sysmsg.getType();
        if (SystemMessageFormats.SystemMessage.Type.CREATE.equals(type)) {
            None$ cause = sysmsg.hasCauseData() ? new Some((Object)((ActorInitializationException)this.getCauseThrowable(sysmsg))) : None$.MODULE$;
            return new Create((Option<ActorInitializationException>)cause);
        }
        if (SystemMessageFormats.SystemMessage.Type.RECREATE.equals(type)) {
            return new Recreate(this.getCauseThrowable(sysmsg));
        }
        if (SystemMessageFormats.SystemMessage.Type.SUSPEND.equals(type)) {
            return new Suspend();
        }
        if (SystemMessageFormats.SystemMessage.Type.RESUME.equals(type)) {
            return new Resume(this.getCauseThrowable(sysmsg));
        }
        if (SystemMessageFormats.SystemMessage.Type.TERMINATE.equals(type)) {
            return new Terminate();
        }
        if (SystemMessageFormats.SystemMessage.Type.SUPERVISE.equals(type)) {
            return new Supervise(this.deserializeActorRef(sysmsg.getSuperviseData().getChild()), sysmsg.getSuperviseData().getAsync());
        }
        if (SystemMessageFormats.SystemMessage.Type.WATCH.equals(type)) {
            return new Watch((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
        }
        if (SystemMessageFormats.SystemMessage.Type.UNWATCH.equals(type)) {
            return new Unwatch((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
        }
        if (SystemMessageFormats.SystemMessage.Type.FAILED.equals(type)) {
            return new Failed(this.deserializeActorRef(sysmsg.getFailedData().getChild()), this.getCauseThrowable(sysmsg), (int)sysmsg.getFailedData().getUid());
        }
        if (SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION.equals(type)) {
            return new DeathWatchNotification(this.deserializeActorRef(sysmsg.getDwNotificationData().getActor()), sysmsg.getDwNotificationData().getExistenceConfirmed(), sysmsg.getDwNotificationData().getAddressTerminated());
        }
        throw new MatchError((Object)type);
    }

    private ContainerFormats.Payload.Builder serializeThrowable(Throwable throwable) {
        return this.payloadSupport().payloadBuilder(throwable);
    }

    private Throwable getCauseThrowable(SystemMessageFormats.SystemMessage msg) {
        return (Throwable)this.payloadSupport().deserializePayload(msg.getCauseData());
    }

    private ContainerFormats.ActorRef.Builder serializeActorRef(ActorRef actorRef2) {
        return ContainerFormats.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(actorRef2));
    }

    private ActorRef deserializeActorRef(ContainerFormats.ActorRef serializedRef) {
        return this.serialization().system().provider().resolveActorRef(serializedRef.getPath());
    }

    public SystemMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        BaseSerializer.$init$(this);
        this.payloadSupport = new WrappedPayloadSupport(system);
        Statics.releaseFence();
    }
}

