/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerDetails$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011Ew!B/_\u0011\u00039g!B5_\u0011\u0003Q\u0007\"B9\u0002\t\u0003\u0011X\u0001B:\u0002\u0001QD!\"a\t\u0002\u0005\u0004%\t\u0001YA\u0013\u0011!\t\u00190\u0001Q\u0001\n\u0005\u001dbA\u0002B\u0001\u0003\u0001\u0011\u0019\u0001\u0003\u0006\u0003\u0006\u0019\u0011)\u0019!C\u0001\u0005\u000fA!Ba\u0007\u0007\u0005\u0003\u0005\u000b\u0011\u0002B\u0005\u0011\u0019\th\u0001\"\u0001\u0003\u001e!I!1\u0005\u0004C\u0002\u0013\u0005!Q\u0005\u0005\t\u0005c1\u0001\u0015!\u0003\u0003(!I!1\u0007\u0004C\u0002\u0013\u0005!Q\u0005\u0005\t\u0005k1\u0001\u0015!\u0003\u0003(!9!q\u0007\u0004\u0005\u000e\te\u0002b\u0002B \u0003\u0011\u0005!\u0011\t\u0004\u0007\u0003o\t!)!\u000f\t\u0015\u0005M\u0003C!f\u0001\n\u0003\t)\u0006\u0003\u0006\u0002dA\u0011\t\u0012)A\u0005\u0003/B!\"!\u001a\u0011\u0005+\u0007I\u0011AA4\u0011)\ty\u0007\u0005B\tB\u0003%\u0011\u0011\u000e\u0005\u0007cB!\t!!\u001d\t\u0013\u0005]\u0004#!A\u0005\u0002\u0005e\u0004\"CA@!E\u0005I\u0011AAA\u0011%\t9\nEI\u0001\n\u0003\tI\nC\u0005\u0002\u001eB\t\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0017\t\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003w\u0003\u0012\u0011!C\u0001\u0003{C\u0011\"a1\u0011\u0003\u0003%\t%!2\t\u0013\u0005M\u0007#!A\u0005\u0002\u0005U\u0007\"CAp!\u0005\u0005I\u0011IAq\u0011%\t)\u000fEA\u0001\n\u0003\n9\u000fC\u0005\u0002jB\t\t\u0011\"\u0011\u0002l\"I\u0011Q\u001e\t\u0002\u0002\u0013\u0005\u0013q^\u0004\n\u0005\u001b\n\u0011\u0011!E\u0001\u0005\u001f2\u0011\"a\u000e\u0002\u0003\u0003E\tA!\u0015\t\rE\u001cC\u0011\u0001B5\u0011%\tIoIA\u0001\n\u000b\nY\u000fC\u0005\u0003l\r\n\t\u0011\"!\u0003n!I!1O\u0012\u0002\u0002\u0013\u0005%Q\u000f\u0005\n\u0005\u0007\u001b\u0013\u0011!C\u0005\u0005\u000bCqA!$\u0002\t\u0003\u0011y\tC\u0004\u0003.\u0006!\tAa,\u0007\u000b%t\u0006A!-\t\u0015\u0005\u00154F!b\u0001\n\u0003\u0011I\f\u0003\u0006\u0002p-\u0012\t\u0011)A\u0005\u0005OCa!]\u0016\u0005\u0002\tm\u0006\"\u0003BaW\t\u0007I\u0011\u0001Bb\u0011!\u0011Im\u000bQ\u0001\n\t\u0015\u0007\"\u0003BfW\t\u0007I\u0011\u0001Bg\u0011!\u0011ym\u000bQ\u0001\n\u0005]\u0007\u0002\u0003BiW\u0001\u0006IAa5\t\u0013\t}7F1A\u0005\u0002\t\u0005\b\u0002\u0003BuW\u0001\u0006IAa9\t\u0013\t-8F1A\u0005\n\t5\b\u0002CB\rW\u0001\u0006IAa<\t\u0011\rm1\u0006\"\u0001a\u0007;AqA!$,\t\u0013\u0019\u0019\u0003C\u0004\u00040-\"\ta!\r\t\u000f\r%3\u0006\"\u0001\u0004L!91\u0011J\u0016\u0005\u0002\rM\u0005bBBPW\u0011%1\u0011\u0015\u0005\b\u0007W[C\u0011ABW\u0011\u001d\u0019Ie\u000bC\u0001\u0007'Dqaa9,\t\u0003\u0019)\u000fC\u0004\u0004j.\"\taa;\t\u000f\rm8\u0006\"\u0001\u0004~\"911`\u0016\u0005\n\u0011\u0015\u0001\"\u0003C\u0007W\t\u0007I\u0011\u0002C\b\u0011!!ib\u000bQ\u0001\n\u0011E\u0001\"\u0003C\u0010W\t\u0007I\u0011\u0002C\u0011\u0011!!)c\u000bQ\u0001\n\u0011\r\u0002B\u0003C\u0014W\t\u0007I\u0011\u00011\u0005*!AAqF\u0016!\u0002\u0013!Y\u0003C\u0004\u00052-\"I\u0001b\r\t\u000f\u0011\r3\u0006\"\u0003\u0005F!9AqK\u0016\u0005\n\u0011e\u0003b\u0002C0W\u0011%A\u0011\r\u0005\b\tKZC\u0011\u0002C4\u0011\u001d!yg\u000bC\u0005\tcB\u0011\u0002\" ,\u0005\u0004%I\u0001b \t\u0011\u0011M5\u0006)A\u0005\t\u0003C\u0011\u0002\"&,\u0005\u0004%\t\u0001b&\t\u0011\u0011m5\u0006)A\u0005\t3C\u0011\u0002\"(,\u0005\u0004%I\u0001b(\t\u0011\u0011\r6\u0006)A\u0005\tCCq\u0001\"*,\t\u0013!9\u000bC\u0005\u0005..\u0012\r\u0011\"\u0003\u0003N\"AAqV\u0016!\u0002\u0013\t9\u000eC\u0005\u00052.\u0012\r\u0011\"\u0003\u0003N\"AA1W\u0016!\u0002\u0013\t9\u000eC\u0004\u00056.\"I\u0001b.\t\u0011\u0011m6\u0006\"\u0001a\t{\u000bQbU3sS\u0006d\u0017N_1uS>t'BA0a\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011\u0011MY\u0001\u0006a\u0016\\7n\u001c\u0006\u0003G\u0012\fa!\u00199bG\",'\"A3\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005!\fQ\"\u00010\u0003\u001bM+'/[1mSj\fG/[8o'\t\t1\u000e\u0005\u0002m_6\tQNC\u0001o\u0003\u0015\u00198-\u00197b\u0013\t\u0001XN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0014qb\u00117bgN\u001cVM]5bY&TXM\u001d\t\u0006YV<\u0018QD\u0005\u0003m6\u0014a\u0001V;qY\u0016\u0014\u0004g\u0001=\u0002\fA)\u00110!\u0001\u0002\b9\u0011!P \t\u0003w6l\u0011\u0001 \u0006\u0003{\u001a\fa\u0001\u0010:p_Rt\u0014BA@n\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0015\u0019E.Y:t\u0015\tyX\u000e\u0005\u0003\u0002\n\u0005-A\u0002\u0001\u0003\f\u0003\u001b\u0019\u0011\u0011!A\u0001\u0006\u0003\tyAA\u0002`IE\nB!!\u0005\u0002\u0018A\u0019A.a\u0005\n\u0007\u0005UQNA\u0004O_RD\u0017N\\4\u0011\u00071\fI\"C\u0002\u0002\u001c5\u00141!\u00118z!\rA\u0017qD\u0005\u0004\u0003Cq&AC*fe&\fG.\u001b>fe\u0006Y2-\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:,\"!a\n\u0011\r\u0005%\u0012qFA\u001a\u001b\t\tYCC\u0002\u0002.5\fA!\u001e;jY&!\u0011\u0011GA\u0016\u0005=!\u0015P\\1nS\u000e4\u0016M]5bE2,\u0007cAA\u001b!5\t\u0011AA\u0006J]\u001a|'/\\1uS>t7C\u0002\tl\u0003w\t\t\u0005E\u0002m\u0003{I1!a\u0010n\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0011\u0002N9!\u0011QIA%\u001d\rY\u0018qI\u0005\u0002]&\u0019\u00111J7\u0002\u000fA\f7m[1hK&!\u0011qJA)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tY%\\\u0001\bC\u0012$'/Z:t+\t\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti\u0006Y\u0001\u0006C\u000e$xN]\u0005\u0005\u0003C\nYFA\u0004BI\u0012\u0014Xm]:\u0002\u0011\u0005$GM]3tg\u0002\naa]=ti\u0016lWCAA5!\u0011\tI&a\u001b\n\t\u00055\u00141\f\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0015\r\u0005M\u00121OA;\u0011\u001d\t\u0019&\u0006a\u0001\u0003/Bq!!\u001a\u0016\u0001\u0004\tI'\u0001\u0003d_BLHCBA\u001a\u0003w\ni\bC\u0005\u0002TY\u0001\n\u00111\u0001\u0002X!I\u0011Q\r\f\u0011\u0002\u0003\u0007\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019I\u000b\u0003\u0002X\u0005\u00155FAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005EU.\u0001\u0006b]:|G/\u0019;j_:LA!!&\u0002\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0014\u0016\u0005\u0003S\n))A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003C\u0003B!a)\u0002.6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+\u0001\u0003mC:<'BAAV\u0003\u0011Q\u0017M^1\n\t\u0005=\u0016Q\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0006c\u00017\u00028&\u0019\u0011\u0011X7\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0011q\u0018\u0005\n\u0003\u0003\\\u0012\u0011!a\u0001\u0003k\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAd!\u0019\tI-a4\u0002\u00185\u0011\u00111\u001a\u0006\u0004\u0003\u001bl\u0017AC2pY2,7\r^5p]&!\u0011\u0011[Af\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0017Q\u001c\t\u0004Y\u0006e\u0017bAAn[\n9!i\\8mK\u0006t\u0007\"CAa;\u0005\u0005\t\u0019AA\f\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0005\u00161\u001d\u0005\n\u0003\u0003t\u0012\u0011!a\u0001\u0003k\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003k\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\u000ba!Z9vC2\u001cH\u0003BAl\u0003cD\u0011\"!1\"\u0003\u0003\u0005\r!a\u0006\u00029\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8oA!\u001aQ!a>\u0011\t\u0005e\u0018Q`\u0007\u0003\u0003wT1!!%a\u0013\u0011\ty0a?\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0002\t'\u0016$H/\u001b8hgN\u0011aa[\u0001\u0007G>tg-[4\u0016\u0005\t%\u0001\u0003\u0002B\u0006\u0005/i!A!\u0004\u000b\t\t\u0015!q\u0002\u0006\u0005\u0005#\u0011\u0019\"\u0001\u0005usB,7/\u00194f\u0015\t\u0011)\"A\u0002d_6LAA!\u0007\u0003\u000e\t11i\u001c8gS\u001e\fqaY8oM&<\u0007\u0005\u0006\u0003\u0003 \t\u0005\u0002cAA\u001b\r!9!QA\u0005A\u0002\t%\u0011aC*fe&\fG.\u001b>feN,\"Aa\n\u0011\u000fe\u0014IC!\f\u0003.%!!1FA\u0003\u0005\ri\u0015\r\u001d\t\u0004s\n=\u0012\u0002BAX\u0003\u000b\tAbU3sS\u0006d\u0017N_3sg\u0002\nQcU3sS\u0006d\u0017N_1uS>t')\u001b8eS:<7/\u0001\fTKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0003-\u0019wN\u001c4jOR{W*\u00199\u0015\t\t\u001d\"1\b\u0005\b\u0005{q\u0001\u0019\u0001B\u0005\u0003\r\u0019gmZ\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$\u0017i\u0019;peB\u000bG\u000f\u001b\u000b\u0005\u0005[\u0011\u0019\u0005C\u0004\u0003F=\u0001\rAa\u0012\u0002\u0011\u0005\u001cGo\u001c:SK\u001a\u0004B!!\u0017\u0003J%!!1JA.\u0005!\t5\r^8s%\u00164\u0017aC%oM>\u0014X.\u0019;j_:\u00042!!\u000e$'\u0015\u0019#1\u000bB0!)\u0011)Fa\u0017\u0002X\u0005%\u00141G\u0007\u0003\u0005/R1A!\u0017n\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0018\u0003X\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\u0005$qM\u0007\u0003\u0005GRAA!\u001a\u0002*\u0006\u0011\u0011n\\\u0005\u0005\u0003\u001f\u0012\u0019\u0007\u0006\u0002\u0003P\u0005)\u0011\r\u001d9msR1\u00111\u0007B8\u0005cBq!a\u0015'\u0001\u0004\t9\u0006C\u0004\u0002f\u0019\u0002\r!!\u001b\u0002\u000fUt\u0017\r\u001d9msR!!q\u000fB@!\u0015a'\u0011\u0010B?\u0013\r\u0011Y(\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r1,\u0018qKA5\u0011%\u0011\tiJA\u0001\u0002\u0004\t\u0019$A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\"\u0011\t\u0005\r&\u0011R\u0005\u0005\u0005\u0017\u000b)K\u0001\u0004PE*,7\r^\u0001\u0019o&$\b\u000e\u0016:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tW\u0003\u0002BI\u0005/#BAa%\u0003&R!!Q\u0013BN!\u0011\tIAa&\u0005\u000f\te\u0015F1\u0001\u0002\u0010\t\tA\u000bC\u0004\u0003\u001e&\u0002\rAa(\u0002\u0003\u0019\u0004R\u0001\u001cBQ\u0005+K1Aa)n\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0002f%\u0002\rAa*\u0011\t\u0005e#\u0011V\u0005\u0005\u0005W\u000bYFA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0010hKR\u001cUO\u001d:f]R$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]R\u0011\u00111G\n\u0005W-\u0014\u0019\f\u0005\u0003\u0002Z\tU\u0016\u0002\u0002B\\\u00037\u0012\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0016\u0005\t\u001dF\u0003\u0002B_\u0005\u007f\u0003\"\u0001[\u0016\t\u000f\u0005\u0015d\u00061\u0001\u0003(\u0006A1/\u001a;uS:<7/\u0006\u0002\u0003FB\u0019!q\u0019\u0004\u000f\u0005!\u0004\u0011!C:fiRLgnZ:!\u0003Y\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tWCAAl\u0003]\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>t\u0007%\u0001\u0003`Y><\u0007\u0003\u0002Bk\u00057l!Aa6\u000b\u0007\te\u0007-A\u0003fm\u0016tG/\u0003\u0003\u0003^\n]'\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/A\u0002m_\u001e,\"Aa9\u0011\t\tU'Q]\u0005\u0005\u0005O\u00149N\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000e[\u0006t\u0017NZ3ti\u000e\u000b7\r[3\u0016\u0005\t=\bC\u0002By\u0005{\u001c\t!\u0004\u0002\u0003t*!!Q\u001fB|\u0003\u0019\tGo\\7jG*!!\u0011 B~\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003[\tI+\u0003\u0003\u0003\u0000\nM(aD!u_6L7MU3gKJ,gnY3\u0011\u0011\r\r1\u0011\u0002B\u0017\u0007\u0017i!a!\u0002\u000b\t\r\u001d\u00111Z\u0001\nS6lW\u000f^1cY\u0016LAAa\u000b\u0004\u0006A)AN!\u001f\u0004\u000eA\"1qBB\u000b!\u0019\t\u0019k!\u0005\u0004\u0014%!\u00111AAS!\u0011\tIa!\u0006\u0005\u0017\r]q'!A\u0001\u0002\u000b\u0005\u0011q\u0002\u0002\u0004?\u0012\u0012\u0014AD7b]&4Wm\u001d;DC\u000eDW\rI\u0001\u0019g\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8J]\u001a|'/\\1uS>tWCAB\u0010!\r\u00119\r\u0005\u0015\u0004q\u0005]X\u0003BB\u0013\u0007S!Baa\n\u0004,A!\u0011\u0011BB\u0015\t\u001d\u0011I*\u000fb\u0001\u0003\u001fAqA!(:\u0001\u0004\u0019i\u0003E\u0003m\u0005C\u001b9#A\u0005tKJL\u0017\r\\5{KR!11GB#!\u0019\tIc!\u000e\u0004:%!1qGA\u0016\u0005\r!&/\u001f\t\u0006Y\u000em2qH\u0005\u0004\u0007{i'!B!se\u0006L\bc\u00017\u0004B%\u001911I7\u0003\t\tKH/\u001a\u0005\u0007\u0007\u000fR\u0004\u0019A6\u0002\u0003=\f1\u0002Z3tKJL\u0017\r\\5{KV!1QJB*)!\u0019ye!\u0016\u0004Z\ru\u0003CBA\u0015\u0007k\u0019\t\u0006\u0005\u0003\u0002\n\rMCa\u0002BMw\t\u0007\u0011q\u0002\u0005\b\u0007/Z\u0004\u0019AB\u001d\u0003\u0015\u0011\u0017\u0010^3t\u0011\u001d\u0019Yf\u000fa\u0001\u0003k\u000bAb]3sS\u0006d\u0017N_3s\u0013\u0012Dqaa\u0018<\u0001\u0004\u0019\t'A\u0003dY\u0006T(\u0010E\u0003m\u0005s\u001a\u0019\u0007\r\u0003\u0004f\r%\u0004#B=\u0002\u0002\r\u001d\u0004\u0003BA\u0005\u0007S\"Aba\u001b\u0004n\u0005\u0005\t\u0011!B\u0001\u0007{\u00121a\u0018\u00135\u0011\u001d\u0019yf\u000fa\u0001\u0007_\u0002R\u0001\u001cB=\u0007c\u0002Daa\u001d\u0004xA)\u00110!\u0001\u0004vA!\u0011\u0011BB<\t1\u0019Yg!\u001c\u0002\u0002\u0003\u0005)\u0011AB=#\u0011\t\tba\u001f\u0011\t\u0005%11K\t\u0005\u0003#\u0019\t\u0006K\u0006<\u0007\u0003\u001b9i!#\u0004\u000e\u000e=\u0005c\u00017\u0004\u0004&\u00191QQ7\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0005\r-\u0015\u0001P+tK\u0002\"Wm]3sS\u0006d\u0017N_3!i\"\fG\u000fI1dG\u0016\u0004Ho\u001d\u0011uQ\u0016\u0004\u0003-\\1oS\u001a,7\u000f\u001e1!CN\u0004\u0013\rI2mCN\u001c\bE\\1nK:\nQa]5oG\u0016\f#a!%\u0002\u0015\u0005[7.\u0019\u00113]Yr\u0003\u0007\u0006\u0005\u0004\u0016\u000e]5\u0011TBN!\u0015\tIc!\u000el\u0011\u001d\u00199\u0006\u0010a\u0001\u0007sAqaa\u0017=\u0001\u0004\t)\fC\u0004\u0004\u001er\u0002\rA!\f\u0002\u00115\fg.\u001b4fgR\fA\u0003Z3tKJL\u0017\r\\5{K\nKH/Z!se\u0006LHcB6\u0004$\u000e\u00156\u0011\u0016\u0005\b\u0007/j\u0004\u0019AB\u001d\u0011\u001d\u00199+\u0010a\u0001\u0003;\t!b]3sS\u0006d\u0017N_3s\u0011\u001d\u0019i*\u0010a\u0001\u0005[\tQ\u0003Z3tKJL\u0017\r\\5{K\nKH/\u001a\"vM\u001a,'\u000fF\u0004l\u0007_\u001byl!1\t\u000f\rEf\b1\u0001\u00044\u0006\u0019!-\u001e4\u0011\t\rU61X\u0007\u0003\u0007oSAa!/\u0002*\u0006\u0019a.[8\n\t\ru6q\u0017\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBB.}\u0001\u0007\u0011Q\u0017\u0005\b\u0007;s\u0004\u0019\u0001B\u0017Q\u0015q4QYBi!\u0015a7qYBf\u0013\r\u0019I-\u001c\u0002\u0007i\"\u0014xn^:\u0011\t\t\u00054QZ\u0005\u0005\u0007\u001f\u0014\u0019G\u0001\rO_R\u001cVM]5bY&T\u0018M\u00197f\u000bb\u001cW\r\u001d;j_:\u001c#aa3\u0016\t\rU71\u001c\u000b\u0007\u0007/\u001cina8\u0011\r\u0005%2QGBm!\u0011\tIaa7\u0005\u000f\teuH1\u0001\u0002\u0010!91qK A\u0002\re\u0002bBB0\u007f\u0001\u00071\u0011\u001d\t\u0006s\u0006\u00051\u0011\\\u0001\u0012M&tGmU3sS\u0006d\u0017N_3s\r>\u0014H\u0003BA\u000f\u0007ODaaa\u0012A\u0001\u0004Y\u0017!D:fe&\fG.\u001b>fe\u001a{'\u000f\u0006\u0003\u0002\u001e\r5\bbBB0\u0003\u0002\u00071q\u001e\u0019\u0005\u0007c\u001c)\u0010E\u0003z\u0003\u0003\u0019\u0019\u0010\u0005\u0003\u0002\n\rUH\u0001DB|\u0007[\f\t\u0011!A\u0003\u0002\u0005=!aA0%q!*\u0011i!2\u0004R\u0006a1/\u001a:jC2L'0\u001a:PMR!1q C\u0001!\u0019\tIc!\u000e\u0002\u001e!9A1\u0001\"A\u0002\t5\u0012!D:fe&\fG.\u001b>fe\u001a\u000bf\n\u0006\u0004\u0004\u0000\u0012\u001dA1\u0002\u0005\b\t\u0013\u0019\u0005\u0019\u0001B\u0017\u0003-\u0011\u0017N\u001c3j]\u001et\u0015-\\3\t\u000f\u0011\r1\t1\u0001\u0003.\u0005\t2/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0016\u0005\u0011E\u0001CBB\u0002\t'!9\"\u0003\u0003\u0005\u0016\r\u0015!aA*fcB\u0019\u0001\u000e\"\u0007\n\u0007\u0011maLA\tTKJL\u0017\r\\5{KJ$U\r^1jYN\f!c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7tA\u0005Y1/\u001a:jC2L'0\u001a:t+\t!\u0019\u0003E\u0004z\u0005S\u0011i#!\b\u0002\u0019M,'/[1mSj,'o\u001d\u0011\u0002\u0011\tLg\u000eZ5oON,\"\u0001b\u000b\u0011\r\r\rA1\u0003C\u0017!\r\u00119mA\u0001\nE&tG-\u001b8hg\u0002\nA$\u001a8tkJ,wJ\u001c7z\u00032dwn^3e'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0006\u0003\u00056\u0011m\u0002c\u00017\u00058%\u0019A\u0011H7\u0003\tUs\u0017\u000e\u001e\u0005\b\t{Q\u0005\u0019\u0001C \u0003\u0011IG/\u001a:\u0011\r\u0005\rC\u0011IA\u000f\u0013\u0011\t\t.!\u0015\u0002A]\f'O\\+oKb\u0004Xm\u0019;fI:{g\u000eU3lW>\u001cVM]5bY&TXM\u001d\u000b\u0007\u0003/$9\u0005b\u0015\t\u000f\r}3\n1\u0001\u0005JA\"A1\nC(!\u0015I\u0018\u0011\u0001C'!\u0011\tI\u0001b\u0014\u0005\u0019\u0011ECqIA\u0001\u0002\u0003\u0015\t!a\u0004\u0003\t}#\u0013\u0007\r\u0005\b\t+Z\u0005\u0019AA\u000f\u0003\r\u0019XM]\u0001\u0014G\",7m[$p_\u001edW\r\u0015:pi>\u0014WO\u001a\u000b\u0005\u0003/$Y\u0006C\u0004\u0005^1\u0003\rA!\f\u0002\u0013\rd\u0017m]:OC6,\u0017AE2iK\u000e\\\u0007+Z6l_B\u0013x\u000e^8ck\u001a$B!a6\u0005d!9AQL'A\u0002\t5\u0012AC2iK\u000e\\7\t\\1tgR1\u0011q\u001bC5\t[Bq\u0001b\u001bO\u0001\u0004\u0011i#\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\b\t;r\u0005\u0019\u0001B\u0017\u0003\u0011\u0019xN\u001d;\u0015\t\u0011-B1\u000f\u0005\b\tkz\u0005\u0019\u0001C<\u0003\tIg\u000e\u0005\u0004\u0002D\u0011eDQF\u0005\u0005\tw\n\tF\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u00035\u0019XM]5bY&TXM]'baV\u0011A\u0011\u0011\t\t\t\u0007#)\t\"#\u0002\u001e5\u0011!q_\u0005\u0005\t\u000f\u00139PA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004D\u0001b#\u0005\u0010B)\u00110!\u0001\u0005\u000eB!\u0011\u0011\u0002CH\t-!\t*UA\u0001\u0002\u0003\u0015\t!a\u0004\u0003\t}#\u0013'M\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00199!\u0003Q\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5usV\u0011A\u0011\u0014\t\bs\n%\u0012QWA\u000f\u0003U\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5us\u0002\n\u0011$];jG.\u001cVM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5usV\u0011A\u0011\u0015\t\u0006Y\u000em\u0012QD\u0001\u001bcVL7m[*fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010I\u0001\u0012O\u0016$8+\u001a:jC2L'0\u001a:Cs&#G\u0003BA\u000f\tSCq\u0001b+W\u0001\u0004\t),\u0001\u0002jI\u0006\t\u0013n\u001d&bm\u0006\u001cVM]5bY&T\u0018\r^5p]^\u000b'O\\5oO\u0016s\u0017M\u00197fI\u0006\u0011\u0013n\u001d&bm\u0006\u001cVM]5bY&T\u0018\r^5p]^\u000b'O\\5oO\u0016s\u0017M\u00197fI\u0002\n\u0001%[:XCJt\u0017N\\4P]:{g+\u001a:jM&\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0006\t\u0013n],be:LgnZ(o\u001d>4VM]5gS\u000e\fG/[8o\u000b:\f'\r\\3eA\u0005Q\u0012n\u001d#jg\u0006dGn\\<fI*\u000bg/Y*fe&\fG.\u001b>feR!\u0011q\u001bC]\u0011\u001d\u00199k\u0017a\u0001\u0003;\tQd\u001d5pk2$w+\u0019:o\u0003\n|W\u000f\u001e&bm\u0006\u001cVM]5bY&TXM\u001d\u000b\u0007\u0003/$y\f\"4\t\u000f\u0011\u0005G\f1\u0001\u0005D\u0006y1/\u001a:jC2L'0\u001a3DY\u0006\u001c8\u000f\r\u0003\u0005F\u0012%\u0007#B=\u0002\u0002\u0011\u001d\u0007\u0003BA\u0005\t\u0013$A\u0002b3\u0005@\u0006\u0005\t\u0011!B\u0001\u0003\u001f\u0011Aa\u0018\u00132g!91q\u0015/A\u0002\u0005u\u0001f\u0001/\u0002x\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef2) {
        return Serialization$.MODULE$.serializedActorPath(actorRef2);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0 & Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable)() -> {
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                return serializerWithStringManifest.fromBinary(bytes, manifest);
            }
            String string = manifest;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return serializer.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
            }
            Map<String, Option<Class<?>>> cache = this.manifestCache().get();
            Option option = cache.get((Object)manifest);
            if (option instanceof Some) {
                Some some = (Some)option;
                Option cachedClassManifest = (Option)some.value();
                return serializer.fromBinary(bytes, cachedClassManifest);
            }
            if (None$.MODULE$.equals(option)) {
                Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Class classManifest = (Class)success.value();
                    Some classManifestOption = new Some((Object)classManifest);
                    this.updateCache$1(cache, manifest, (Option)classManifestOption);
                    return serializer.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                }
                if (try_ instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                }
                throw new MatchError(try_);
            }
            throw new MatchError((Object)option);
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap().get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer2 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            Serializer s2 = (Serializer)tuple2._2();
                            return s2.getClass().getName();
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            return serializer3;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, fqn, bindingName){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchMethodException) {
                    return (B1)this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof NoSuchMethodException) {
                                NoSuchMethodException noSuchMethodException = (NoSuchMethodException)A1;
                                String string = this.$outer.bindingName$1;
                                String string2 = "";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    throw noSuchMethodException;
                                }
                                return (B1)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.$outer.bindingName$1), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return throwable instanceof NoSuchMethodException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof NoSuchMethodException;
            }

            public /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable)() -> "Disallowed JavaSerializer binding.");
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        if (clazz.getName().startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkPekkoProtobuf(String className) {
        return this.checkClass("org.apache.pekko.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    Buffer buffer = buf.append(ca);
                    break;
                }
                default: {
                    buf.insert(n, ca);
                    Buffer buffer = BoxedUnit.UNIT;
                    break;
                }
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer = this.quickSerializerByIdentity()[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            return serializer;
        }
        return (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, (Map<String, Option<Class<?>>>)cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class c = (Class)tuple2._1();
            return c.isAssignableFrom(clazz$3);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null && tuple2._2() instanceof JavaSerializer) {
            return false;
        }
        return tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
    }

    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String alias = (String)tuple2._2();
            if (className != null && alias != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String alias = (String)tuple2._2();
            if (className != null) {
                String string = className;
                if (alias != null) {
                    String string2;
                    String string3 = string2 = alias;
                    String string4 = "none";
                    return (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string) && $this.checkPekkoProtobuf(string);
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Class clazz = (Class)tuple2._1();
            Serializer ser = (Serializer)tuple2._2();
            return $this.warnUnexpectedNonPekkoSerializer(clazz, ser);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (Seq)vector.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    return (B1)SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                }
                return (B1)A12;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                if (serializerDetails2 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer())) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k != null) {
                    String string = k;
                    if (v != null) {
                        String string2 = v;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string, string2).get());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Map result = (Map)fromConfig.$plus$plus((IterableOnce)this.serializerDetails().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer())));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError((Object)tuple2);
        }));
        this.serializers = result;
        Map fromConfig2 = (Map)this.settings().SerializationBindings().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                String className = (String)tuple2._1();
                String alias = (String)tuple2._2();
                if (className != null) {
                    String string = className;
                    if (alias != null) {
                        String string2 = alias;
                        return new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Seq fromSettings = (Seq)this.serializerDetails().flatMap((Function1 & Serializable)detail -> (Seq)detail.useFor().map((Function1 & Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer())));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((IterableOnce)fromSettings));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError((Object)tuple2);
        }));
        result2.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
            if (tuple2 != null) {
                ConcurrentHashMap map = (ConcurrentHashMap)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Class c = (Class)tuple22._1();
                    Serializer s2 = (Serializer)tuple22._2();
                    map.put(c, s2);
                    return map;
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Map zero = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}));
        this.serializerByIdentity = (Map)this.serializers().foldLeft((Object)zero, (Function2 & Serializable)(x0$5, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
            if (tuple2 != null) {
                Map acc = (Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Serializer ser = (Serializer)tuple22._2();
                    int id = ser.identifier();
                    Option option = acc.get((Object)BoxesRunTime.boxToInteger((int)id));
                    if (option instanceof Some) {
                        Serializer existing;
                        Some some = (Some)option;
                        Serializer serializer = existing = (Serializer)some.value();
                        Serializer serializer2 = ser;
                        if (serializer == null ? serializer2 != null : !serializer.equals(serializer2)) {
                            throw new IllegalArgumentException(new StringBuilder(68).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append("is not unique. It is also used by [").append(acc.apply((Object)BoxesRunTime.boxToInteger((int)id)).getClass().getName()).append("].").toString());
                        }
                    }
                    return (Map)acc.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.system();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "system";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)package$JavaConverters$.MODULE$.MapHasAsScala(cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

