/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.akka.instrumentations;

import akka.actor.ActorRef;
import akka.pattern.AskTimeoutException;
import akka.util.Timeout;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.instrumentation.akka.AkkaInstrumentation;
import kamon.instrumentation.akka.AkkaInstrumentation$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Heavyweight$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Lightweight$;
import kamon.instrumentation.akka.AkkaInstrumentation$AskPatternTimeoutWarningSetting$Off$;
import kamon.instrumentation.akka.instrumentations.AkkaPrivateAccess;
import kamon.instrumentation.akka.instrumentations.AskPatternInstrumentation;
import kamon.util.CallingThreadExecutionContext$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class AskPatternInstrumentation$ {
    public static final AskPatternInstrumentation$ MODULE$ = new AskPatternInstrumentation$();
    private static final Logger _log = LoggerFactory.getLogger(AskPatternInstrumentation.class);

    private Logger _log() {
        return _log;
    }

    @Advice.OnMethodExit(suppress=Throwable.class)
    public void onExit(@Advice.Origin String origin, @Advice.Return Future<Object> future, @Advice.Argument(value=0) ActorRef actor, @Advice.Argument(value=2) Timeout timeout) {
        if (AkkaPrivateAccess.isInternalAndActiveActorRef(actor) && Kamon$.MODULE$.currentContext().nonEmpty()) {
            AkkaInstrumentation.AskPatternTimeoutWarningSetting askPatternTimeoutWarningSetting = AkkaInstrumentation$.MODULE$.settings().askPatternWarning();
            if (AkkaInstrumentation$AskPatternTimeoutWarningSetting$Off$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                return;
            }
            if (AkkaInstrumentation$AskPatternTimeoutWarningSetting$Lightweight$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                this.hookLightweightWarning(future, this.sourceLocation(origin), actor);
                return;
            }
            if (AkkaInstrumentation$AskPatternTimeoutWarningSetting$Heavyweight$.MODULE$.equals(askPatternTimeoutWarningSetting)) {
                this.hookHeavyweightWarning(future, new AskPatternInstrumentation.StackTraceCaptureException(), actor);
                return;
            }
            throw new MatchError((Object)askPatternTimeoutWarningSetting);
        }
    }

    private PartialFunction<Throwable, BoxedUnit> ifAskTimeoutException(Function0<BoxedUnit> code) {
        return new Serializable(code){
            private static final long serialVersionUID = 0L;
            private final Function0 code$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AskTimeoutException) {
                    this.code$1.apply$mcV$sp();
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof AskTimeoutException) {
                    return true;
                }
                return true;
            }
            {
                this.code$1 = code$1;
            }
        };
    }

    private void hookLightweightWarning(Future<Object> future, AskPatternInstrumentation.SourceLocation sourceLocation, ActorRef actor) {
        String locationString = (String)Option$.MODULE$.apply((Object)sourceLocation).map((Function1 & Serializable)location -> new StringBuilder(1).append(location.declaringType()).append(":").append(location.method()).toString()).getOrElse((Function0 & Serializable)() -> "<unknown position>");
        future.failed().foreach(this.ifAskTimeoutException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$._log().warn(new StringBuilder(51).append("Timeout triggered for ask pattern to actor [").append(actor.path().name()).append("] at [").append(locationString).append("]").toString())), (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
    }

    private void hookHeavyweightWarning(Future<Object> future, AskPatternInstrumentation.StackTraceCaptureException captureException, ActorRef actor) {
        String locationString = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])captureException.getStackTrace()), 3)).mkString("", System.lineSeparator(), System.lineSeparator());
        future.failed().foreach(this.ifAskTimeoutException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> MODULE$._log().warn(new StringBuilder(51).append("Timeout triggered for ask pattern to actor [").append(actor.path().name()).append("] at [").append(locationString).append("]").toString())), (ExecutionContext)CallingThreadExecutionContext$.MODULE$);
    }

    private AskPatternInstrumentation.SourceLocation sourceLocation(String origin) {
        String[] methodDescription = origin.split(" ");
        return new AskPatternInstrumentation.SourceLocation(methodDescription[0], methodDescription[1]);
    }

    private AskPatternInstrumentation$() {
    }
}

