/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.apache.httpclient;

import java.io.IOException;
import kamon.Kamon;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.apache.httpclient.ApacheHttpClientInstrumentation;
import kamon.instrumentation.http.HttpClientInstrumentation;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class ResponseHandlerProxy<T, U>
implements ResponseHandler<T> {
    private final ResponseHandler<T> delegate;
    private final HttpClientInstrumentation.RequestHandler<U> handler;
    private Context parentContext;

    public ResponseHandlerProxy(HttpClientInstrumentation.RequestHandler<U> requestHandler, ResponseHandler<T> responseHandler, Context context) {
        this.handler = requestHandler;
        this.delegate = responseHandler;
        this.parentContext = context;
    }

    public T handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        ApacheHttpClientInstrumentation.processResponse(this.handler, httpResponse, null);
        try (Storage.Scope scope = Kamon.storeContext((Context)this.parentContext);){
            Object object = this.delegate.handleResponse(httpResponse);
            return (T)object;
        }
    }
}

