/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props$;
import com.typesafe.config.Config;
import kamon.Kamon;
import kamon.Kamon$;
import kamon.graphite.GraphiteClient;
import kamon.graphite.GraphiteExtension$;
import kamon.metric.MetricScaleDecorator$;
import kamon.util.ConfigTools;
import kamon.util.ConfigTools$;
import kamon.util.NeedToScale$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001\u001d\u0011\u0011c\u0012:ba\"LG/Z#yi\u0016t7/[8o\u0015\t\u0019A!\u0001\u0005he\u0006\u0004\b.\u001b;f\u0015\u0005)\u0011!B6b[>t7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010'9\u0011\u0001#E\u0007\u0002\t%\u0011!\u0003B\u0001\u0006\u0017\u0006lwN\\\u0005\u0003)U\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u000b\u0005I!\u0001\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\rML8\u000f^3n!\tIb$D\u0001\u001b\u0015\tYB$A\u0003bGR|'OC\u0001\u001e\u0003\u0011\t7n[1\n\u0005}Q\"aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0007\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\b\u0006\u0002$KA\u0011A\u0005A\u0007\u0002\u0005!)q\u0003\ta\u00011!9q\u0005\u0001b\u0001\n\u0003A\u0013a\u00017pOV\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005)1\u000f\u001c45U*\ta&A\u0002pe\u001eL!\u0001M\u0016\u0003\r1{wmZ3s\u0011\u0019\u0011\u0004\u0001)A\u0005S\u0005!An\\4!\u0011\u001d!\u0004A1A\u0005\u0004U\n!!Y:\u0016\u0003aAaa\u000e\u0001!\u0002\u0013A\u0012aA1tA!9\u0011\b\u0001b\u0001\n\u0013Q\u0014AB2p]\u001aLw-F\u0001<!\ta$)D\u0001>\u0015\tIdH\u0003\u0002@\u0001\u0006AA/\u001f9fg\u00064WMC\u0001B\u0003\r\u0019w.\\\u0005\u0003\u0007v\u0012aaQ8oM&<\u0007BB#\u0001A\u0003%1(A\u0004d_:4\u0017n\u001a\u0011\t\u000f\u001d\u0003!\u0019!C\u0005u\u0005qqM]1qQ&$XmQ8oM&<\u0007BB%\u0001A\u0003%1(A\bhe\u0006\u0004\b.\u001b;f\u0007>tg-[4!\u0011\u001dY\u0005A1A\u0005\u00021\u000bA\u0002^5dW&sG/\u001a:wC2,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003%*\t!bY8oGV\u0014(/\u001a8u\u0013\t!vJ\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\rY\u0003\u0001\u0015!\u0003N\u00035!\u0018nY6J]R,'O^1mA!9\u0001\f\u0001b\u0001\n\u0003I\u0016\u0001\u00035pgRt\u0017-\\3\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t1\fgn\u001a\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0004TiJLgn\u001a\u0005\u0007G\u0002\u0001\u000b\u0011\u0002.\u0002\u0013!|7\u000f\u001e8b[\u0016\u0004\u0003bB3\u0001\u0005\u0004%\tAZ\u0001\u0005a>\u0014H/F\u0001h!\tI\u0001.\u0003\u0002j\u0015\t\u0019\u0011J\u001c;\t\r-\u0004\u0001\u0015!\u0003h\u0003\u0015\u0001xN\u001d;!\u0011\u001di\u0007A1A\u0005\u0002e\u000bA\"\\3ue&\u001c\u0007K]3gSbDaa\u001c\u0001!\u0002\u0013Q\u0016!D7fiJL7\r\u0015:fM&D\b\u0005C\u0004r\u0001\t\u0007I\u0011\u00014\u0002\u001fI,GO]=Ck\u001a4WM]*ju\u0016Daa\u001d\u0001!\u0002\u00139\u0017\u0001\u0005:fiJL()\u001e4gKJ\u001c\u0016N_3!\u0011\u001d)\bA1A\u0005\u0002Y\fQ\"\\3ue&\u001c7oU3oI\u0016\u0014X#A<\u0011\u0005eA\u0018BA=\u001b\u0005!\t5\r^8s%\u00164\u0007BB>\u0001A\u0003%q/\u0001\bnKR\u0014\u0018nY:TK:$WM\u001d\u0011\t\u000fu\u0004!\u0019!C\u0001m\u0006qqM]1qQ&$Xm\u00117jK:$\bBB@\u0001A\u0003%q/A\bhe\u0006\u0004\b.\u001b;f\u00072LWM\u001c;!\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003Q\u0014!D:vEN\u001c'/\u001b9uS>t7\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011B\u001e\u0002\u001dM,(m]2sSB$\u0018n\u001c8tA\u0001")
public class GraphiteExtension
implements Kamon.Extension {
    private final Logger log = LoggerFactory.getLogger(GraphiteExtension.class);
    private final ExtendedActorSystem as;
    private final Config config;
    private final Config graphiteConfig;
    private final FiniteDuration tickInterval;
    private final String hostname;
    private final int port;
    private final String metricPrefix;
    private final int retryBufferSize;
    private final ActorRef metricsSender;
    private final ActorRef graphiteClient;
    private final Config subscriptions;

    public Logger log() {
        return this.log;
    }

    public ExtendedActorSystem as() {
        return this.as;
    }

    private Config config() {
        return this.config;
    }

    private Config graphiteConfig() {
        return this.graphiteConfig;
    }

    public FiniteDuration tickInterval() {
        return this.tickInterval;
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    public String metricPrefix() {
        return this.metricPrefix;
    }

    public int retryBufferSize() {
        return this.retryBufferSize;
    }

    public ActorRef metricsSender() {
        return this.metricsSender;
    }

    public ActorRef graphiteClient() {
        return this.graphiteClient;
    }

    public Config subscriptions() {
        return this.subscriptions;
    }

    public GraphiteExtension(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.log().info("Starting the Kamon(Graphite) extension");
        this.as = system;
        this.config = system.settings().config();
        this.graphiteConfig = this.config().getConfig("kamon.graphite");
        this.tickInterval = Kamon$.MODULE$.metrics().settings().tickInterval();
        this.hostname = this.graphiteConfig().getString("hostname");
        this.port = this.graphiteConfig().getInt("port");
        this.metricPrefix = this.graphiteConfig().getString("metric-name-prefix");
        this.retryBufferSize = this.graphiteConfig().getInt("write-retry-buffer-size");
        this.metricsSender = system.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this), ClassTag$.MODULE$.apply(GraphiteClient.class)), "kamon-graphite");
        Config config = this.graphiteConfig();
        Option option = NeedToScale$.MODULE$.unapply(config);
        if (option.isEmpty()) {
            actorRef = this.metricsSender();
        } else {
            Option scaleTimeTo = (Option)((Tuple2)option.get())._1();
            Option scaleMemoryTo = (Option)((Tuple2)option.get())._2();
            actorRef = system.actorOf(MetricScaleDecorator$.MODULE$.props(scaleTimeTo, scaleMemoryTo, this.metricsSender()), "graphite-metric-scale-decorator");
        }
        this.graphiteClient = actorRef;
        this.subscriptions = this.graphiteConfig().getConfig("subscriptions");
        ConfigTools.Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(this.subscriptions())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphiteExtension $outer;

            public final void apply(String subscriptionCategory) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.subscriptions().getStringList(subscriptionCategory)).asScala()).foreach((Function1)new Serializable(this, subscriptionCategory){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final String subscriptionCategory$1;

                    public final void apply(String pattern) {
                        Kamon$.MODULE$.metrics().subscribe(this.subscriptionCategory$1, pattern, this.$outer.kamon$graphite$GraphiteExtension$$anonfun$$$outer().graphiteClient(), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.subscriptionCategory$1 = subscriptionCategory$1;
                    }
                });
            }

            public /* synthetic */ GraphiteExtension kamon$graphite$GraphiteExtension$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
    }
}

