/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import akka.util.ByteString;
import akka.util.ByteString$;
import kamon.graphite.MetricPacket;
import kamon.graphite.MetricPacking;
import kamon.graphite.MetricPacking$;
import kamon.metric.CounterKey;
import kamon.metric.Entity;
import kamon.metric.GaugeKey;
import kamon.metric.HistogramKey;
import kamon.metric.MetricKey;
import kamon.metric.MinMaxCounterKey;
import kamon.metric.instrument.Counter;
import kamon.metric.instrument.Histogram;

public abstract class MetricPacking$class {
    private static String sanitize(MetricPacking $this, String value) {
        return value.replace('/', '_').replace('.', '_');
    }

    private static String baseName(MetricPacking $this, String prefix, Entity entity, MetricKey key) {
        return prefix + "." + entity.category() + "." + MetricPacking$class.sanitize($this, entity.name()) + "." + MetricPacking$class.sanitize($this, key.name());
    }

    private static MetricPacket newMetricPacket(MetricPacking $this, String baseName, long timestamp) {
        return new MetricPacket($this, baseName, timestamp){
            private final StringBuilder builder;
            private final String baseName$1;
            private final long timestamp$1;

            private StringBuilder builder() {
                return this.builder;
            }

            public MetricPacking$.anon.1 append(String metricName, long value) {
                this.builder().append(this.baseName$1).append(".").append(metricName).append(" ").append(value).append(" ").append(this.timestamp$1).append("\n");
                return this;
            }

            public ByteString byteString() {
                return ByteString$.MODULE$.apply(this.builder().toString());
            }
            {
                this.baseName$1 = baseName$1;
                this.timestamp$1 = timestamp$1;
                this.builder = new StringBuilder();
            }
        };
    }

    public static ByteString packHistogram(MetricPacking $this, String prefix, Entity entity, HistogramKey histogramKey, Histogram.Snapshot snapshot, long timestamp) {
        return MetricPacking$class.newMetricPacket($this, MetricPacking$class.baseName($this, prefix, entity, (MetricKey)histogramKey), timestamp).append("count", snapshot.numberOfMeasurements()).append("min", snapshot.min()).append("max", snapshot.max()).append("p50", snapshot.percentile(50.0)).append("p90", snapshot.percentile(90.0)).append("p99", snapshot.percentile(99.0)).append("sum", snapshot.sum()).byteString();
    }

    public static ByteString packGauge(MetricPacking $this, String prefix, Entity entity, GaugeKey histogramKey, Histogram.Snapshot snapshot, long timestamp) {
        return MetricPacking$class.newMetricPacket($this, MetricPacking$class.baseName($this, prefix, entity, (MetricKey)histogramKey), timestamp).append("min", snapshot.min()).append("max", snapshot.max()).append("sum", snapshot.sum()).append("avg", MetricPacking$class.average($this, snapshot)).byteString();
    }

    public static ByteString packMinMaxCounter(MetricPacking $this, String prefix, Entity entity, MinMaxCounterKey minMaxCounterKey, Histogram.Snapshot snapshot, long timestamp) {
        return MetricPacking$class.newMetricPacket($this, MetricPacking$class.baseName($this, prefix, entity, (MetricKey)minMaxCounterKey), timestamp).append("min", snapshot.min()).append("max", snapshot.max()).append("avg", MetricPacking$class.average($this, snapshot)).byteString();
    }

    public static ByteString packCounter(MetricPacking $this, String prefix, Entity entity, CounterKey counterKey, Counter.Snapshot snapshot, long timestamp) {
        return MetricPacking$class.newMetricPacket($this, MetricPacking$class.baseName($this, prefix, entity, (MetricKey)counterKey), timestamp).append("count", snapshot.count()).byteString();
    }

    private static long average(MetricPacking $this, Histogram.Snapshot snapshot) {
        return snapshot.numberOfMeasurements() > 0L ? snapshot.sum() / snapshot.numberOfMeasurements() : 0L;
    }

    public static void $init$(MetricPacking $this) {
    }
}

