/*
 * Decompiled with CFR 0.152.
 */
package kamon.instrumentation.kafka.client;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.context.Context;
import kamon.context.Storage;
import kamon.instrumentation.kafka.client.ConsumedRecordData;
import kamon.instrumentation.kafka.client.KafkaInstrumentation;
import kamon.instrumentation.kafka.client.KafkaInstrumentation$Syntax$;
import kamon.trace.Span;
import kamon.trace.Span$;
import kamon.trace.SpanBuilder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class KafkaInstrumentation$ {
    public static KafkaInstrumentation$ MODULE$;
    private volatile KafkaInstrumentation.Settings _settings;

    static {
        new KafkaInstrumentation$();
    }

    private KafkaInstrumentation.Settings _settings() {
        return this._settings;
    }

    private void _settings_$eq(KafkaInstrumentation.Settings x$1) {
        this._settings = x$1;
    }

    public KafkaInstrumentation.Settings settings() {
        return this._settings();
    }

    private KafkaInstrumentation.Settings readSettings(Config config) {
        Config kafkaConfig = config.getConfig("kamon.instrumentation.kafka.client");
        return new KafkaInstrumentation.Settings(kafkaConfig.getBoolean("tracing.continue-trace-on-consumer"), kafkaConfig.getBoolean("tracing.use-delayed-spans"));
    }

    public <K, V> Context extractContext(ConsumerRecord<K, V> consumerRecord) {
        return KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(consumerRecord));
    }

    public ConsumerRecord<?, ?> Syntax(ConsumerRecord<?, ?> cr) {
        return cr;
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, Function0<T> f) {
        return this.runWithConsumerSpan(record, "consumer.process", true, f);
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, String operationName, Function0<T> f) {
        return this.runWithConsumerSpan(record, operationName, true, f);
    }

    public <T> T runWithConsumerSpan(ConsumerRecord<?, ?> record, String operationName, boolean finishSpan, Function0<T> f) {
        Object object;
        Context incomingContext = KafkaInstrumentation$Syntax$.MODULE$.context$extension(this.Syntax(record));
        Context operationContext = incomingContext.nonEmpty() ? incomingContext : Kamon$.MODULE$.currentContext();
        Span span = this.consumerSpan(record, operationName);
        Storage.Scope scope = Kamon$.MODULE$.storeContext(operationContext.withEntry(Span$.MODULE$.Key(), (Object)span));
        try {
            try {
                object = f.apply();
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    span.fail(t.getMessage(), t);
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            if (finishSpan) {
                span.finish();
            }
            scope.close();
        }
        return (T)object;
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record) {
        return this.consumerSpan(record, "consumer.process");
    }

    public Span consumerSpan(ConsumerRecord<?, ?> record, String operationName) {
        SpanBuilder consumerSpan = Kamon$.MODULE$.consumerSpanBuilder(operationName, "kafka.consumer").tag("kafka.topic", record.topic()).tag("kafka.partition", (long)record.partition()).tag("kafka.offset", record.offset()).tag("kafka.timestamp", record.timestamp()).tag("kafka.timestamp-type", record.timestampType().name);
        Option$.MODULE$.apply(record.key()).foreach((Function1 & Serializable & scala.Serializable)k -> consumerSpan.tag("kafka.key", k.toString()));
        if (record instanceof ConsumedRecordData) {
            ConsumedRecordData consumerRecordData = (ConsumedRecordData)record;
            Span incomingSpan = (Span)consumerRecordData.incomingContext().get(Span$.MODULE$.Key());
            consumerSpan.tag("kafka.group-id", (String)consumerRecordData.consumerInfo().groupId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown")).tag("kafka.client-id", consumerRecordData.consumerInfo().clientId()).tag("kafka.poll-time", consumerRecordData.nanosSincePollStart());
            if (!incomingSpan.isEmpty()) {
                if (this.settings().continueTraceOnConsumer()) {
                    consumerSpan.asChildOf(incomingSpan);
                } else {
                    consumerSpan.link(incomingSpan, (Span.Link$.Kind)Span.Link$.Kind$.FollowsFrom$.MODULE$);
                }
            }
        }
        if (this.settings().useDelayedSpans()) {
            return consumerSpan.delay(Kamon$.MODULE$.clock().toInstant(record.timestamp() * 1000000L)).start();
        }
        return consumerSpan.start();
    }

    private KafkaInstrumentation$() {
        MODULE$ = this;
        this._settings = this.readSettings(Kamon$.MODULE$.config());
        Kamon$.MODULE$.onReconfigure((Function1 & Serializable & scala.Serializable)newConfig -> {
            KafkaInstrumentation$.MODULE$._settings_$eq(KafkaInstrumentation$.MODULE$.readSettings(newConfig));
            return BoxedUnit.UNIT;
        });
    }
}

