/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import java.io.Serializable;
import kamon.metric.Distribution;
import kamon.metric.DynamicRange;
import kamon.metric.MeasurementUnit;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.newrelic.AttributeBuddy$;
import kamon.tag.TagSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Long$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NewRelicDistributionMetrics$
implements Serializable {
    private static final Seq<Object> percentilesToReport;
    private static final Logger logger;
    public static final NewRelicDistributionMetrics$ MODULE$;

    private NewRelicDistributionMetrics$() {
    }

    static {
        MODULE$ = new NewRelicDistributionMetrics$();
        percentilesToReport = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{50.0, 75.0, 90.0, 95.0, 99.0, 99.9}));
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NewRelicDistributionMetrics$.class);
    }

    public Seq<Metric> apply(long start, long end, MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution> dist, String sourceMetricType) {
        logger.debug("name: {} ; numberOfInstruments: {}", (Object)dist.name(), (Object)BoxesRunTime.boxToInteger((int)dist.instruments().size()));
        Attributes baseAttributes = this.buildBaseAttributes(dist, sourceMetricType);
        return (Seq)dist.instruments().flatMap((Function1 & Serializable)inst -> {
            TagSet tags = inst.tags();
            Attributes instrumentBaseAttributes = AttributeBuddy$.MODULE$.addTagsFromTagSets((Seq<TagSet>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TagSet[]{tags}))), baseAttributes.copy());
            Distribution distValue = (Distribution)inst.value();
            Seq buckets = distValue.buckets();
            Summary summary = this.buildSummary(start, end, dist, instrumentBaseAttributes, distValue);
            Seq<Metric> percentiles = this.makePercentiles(dist.name(), end, distValue, instrumentBaseAttributes);
            return (IterableOnce)percentiles.$colon$plus((Object)summary);
        });
    }

    private Summary buildSummary(long start, long end, MetricSnapshot dist, Attributes instrumentBaseAttributes, Distribution distValue) {
        long count = distValue.count();
        long sum = distValue.sum();
        long min = distValue.min();
        long max = distValue.max();
        return new Summary(dist.name() + ".summary", (int)count, Long$.MODULE$.long2double(sum), Long$.MODULE$.long2double(min), Long$.MODULE$.long2double(max), start, end, instrumentBaseAttributes);
    }

    private Seq<Metric> makePercentiles(String name, long end, Distribution distValue, Attributes instrumentBaseAttributes) {
        return (Seq)((IterableOps)((IterableOps)percentilesToReport.map((Function1 & Serializable)rank -> this.makePercentiles$$anonfun$3(distValue, BoxesRunTime.unboxToDouble((Object)rank)))).filter((Function1 & Serializable)percentileValue -> percentileValue != null)).map((Function1 & Serializable)percentile -> {
            Attributes attributes = instrumentBaseAttributes.copy().put("percentile", (Number)Predef$.MODULE$.double2Double(percentile.rank()));
            return new Gauge(name + ".percentiles", Long$.MODULE$.long2double(percentile.value()), end, attributes);
        });
    }

    private Attributes buildBaseAttributes(MetricSnapshot dist, String sourceMetricType) {
        DynamicRange dynamicRange = ((Metric.Settings.ForDistributionInstrument)dist.settings()).dynamicRange();
        long lowestDiscernibleValue = dynamicRange.lowestDiscernibleValue();
        long highestTrackableValue = dynamicRange.highestTrackableValue();
        int significantValueDigits = dynamicRange.significantValueDigits();
        MeasurementUnit unit = ((Metric.Settings.ForDistributionInstrument)dist.settings()).unit();
        MeasurementUnit.Magnitude magnitude = unit.magnitude();
        MeasurementUnit.Dimension dimension = unit.dimension();
        return new Attributes().put("description", dist.description()).put("sourceMetricType", sourceMetricType).put("lowestDiscernibleValue", (Number)Predef$.MODULE$.long2Long(lowestDiscernibleValue)).put("highestTrackableValue", (Number)Predef$.MODULE$.long2Long(highestTrackableValue)).put("significantValueDigits", (Number)Predef$.MODULE$.int2Integer(significantValueDigits)).put("magnitude.name", magnitude.name()).put("magnitude.scaleFactor", (Number)Predef$.MODULE$.double2Double(magnitude.scaleFactor())).put("dimension", dimension.name());
    }

    private final /* synthetic */ Distribution.Percentile makePercentiles$$anonfun$3(Distribution distValue$1, double rank) {
        return distValue$1.percentile(rank);
    }
}

