/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.metrics;

import com.newrelic.telemetry.OkHttpPoster;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.URL;
import java.time.Duration;
import kamon.Kamon$;
import kamon.newrelic.LibraryVersion$;
import scala.Function0;
import scala.runtime.ModuleSerializationProxy;

public final class NewRelicMetricsReporter$
implements Serializable {
    public static final NewRelicMetricsReporter$ MODULE$ = new NewRelicMetricsReporter$();

    private NewRelicMetricsReporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NewRelicMetricsReporter$.class);
    }

    public Function0<MetricBatchSender> $lessinit$greater$default$1() {
        return (Function0 & Serializable)() -> this.buildSender(this.buildSender$default$1());
    }

    public MetricBatchSender buildSender(Config config) {
        SenderConfiguration senderConfig = this.buildSenderConfig(config);
        return MetricBatchSender.create((SenderConfiguration)senderConfig);
    }

    public Config buildSender$default$1() {
        return Kamon$.MODULE$.config();
    }

    public SenderConfiguration buildSenderConfig(Config config) {
        Config nrConfig = config.getConfig("kamon.newrelic");
        String nrInsightsInsertKey = nrConfig.getString("nr-insights-insert-key");
        boolean enableAuditLogging = nrConfig.getBoolean("enable-audit-logging");
        String userAgent = "newrelic-kamon-reporter/" + LibraryVersion$.MODULE$.version();
        Duration callTimeout = Duration.ofSeconds(5L);
        SenderConfiguration.SenderConfigurationBuilder senderConfig = MetricBatchSender.configurationBuilder().apiKey(nrInsightsInsertKey).httpPoster((HttpPoster)new OkHttpPoster(callTimeout)).auditLoggingEnabled(enableAuditLogging).secondaryUserAgent(userAgent);
        if (nrConfig.hasPath("metric-ingest-uri")) {
            String uriOverride = nrConfig.getString("metric-ingest-uri");
            senderConfig.endpoint(new URL(uriOverride));
        }
        return senderConfig.build();
    }
}

