/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.metrics.MetricBatch;
import com.newrelic.telemetry.metrics.MetricBatchSender;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kamon.Kamon$;
import kamon.metric.Distribution;
import kamon.metric.Metric;
import kamon.metric.MetricSnapshot;
import kamon.metric.PeriodSnapshot;
import kamon.module.MetricReporter;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.newrelic.AttributeBuddy$;
import kamon.newrelic.metrics.NewRelicCounters$;
import kamon.newrelic.metrics.NewRelicDistributionMetrics$;
import kamon.newrelic.metrics.NewRelicGauges$;
import kamon.newrelic.metrics.NewRelicMetricsReporter$;
import kamon.status.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class NewRelicMetricsReporter
implements MetricReporter {
    private final Function0<MetricBatchSender> senderBuilder;
    private final Logger logger;
    private volatile Attributes commonAttributes;
    private volatile MetricBatchSender sender;

    public static MetricBatchSender buildSender(Config config) {
        return NewRelicMetricsReporter$.MODULE$.buildSender(config);
    }

    public static SenderConfiguration buildSenderConfig(Config config) {
        return NewRelicMetricsReporter$.MODULE$.buildSenderConfig(config);
    }

    public static Function0<MetricBatchSender> $lessinit$greater$default$1() {
        return NewRelicMetricsReporter$.MODULE$.$lessinit$greater$default$1();
    }

    public static Config buildSender$default$1() {
        return NewRelicMetricsReporter$.MODULE$.buildSender$default$1();
    }

    public NewRelicMetricsReporter(Function0<MetricBatchSender> senderBuilder) {
        this.senderBuilder = senderBuilder;
        this.logger = LoggerFactory.getLogger(NewRelicMetricsReporter.class);
        this.commonAttributes = AttributeBuddy$.MODULE$.buildCommonAttributes(Kamon$.MODULE$.environment());
        this.sender = (MetricBatchSender)senderBuilder.apply();
    }

    public void reportPeriodSnapshot(PeriodSnapshot snapshot) {
        this.logger.debug("NewRelicMetricReporter reportPeriodSnapshot...");
        long periodStartTime = snapshot.from().toEpochMilli();
        long periodEndTime = snapshot.to().toEpochMilli();
        scala.collection.immutable.Seq counters = (scala.collection.immutable.Seq)snapshot.counters().flatMap((Function1 & Serializable)counter -> NewRelicCounters$.MODULE$.apply(periodStartTime, periodEndTime, (MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)counter));
        scala.collection.immutable.Seq gauges = (scala.collection.immutable.Seq)snapshot.gauges().flatMap((Function1 & Serializable)gauge -> NewRelicGauges$.MODULE$.apply(periodEndTime, (MetricSnapshot<Metric.Settings.ForValueInstrument, Object>)gauge));
        scala.collection.immutable.Seq histogramMetrics = (scala.collection.immutable.Seq)snapshot.histograms().flatMap((Function1 & Serializable)histogram -> NewRelicDistributionMetrics$.MODULE$.apply(periodStartTime, periodEndTime, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)histogram, "histogram"));
        scala.collection.immutable.Seq timerMetrics = (scala.collection.immutable.Seq)snapshot.timers().flatMap((Function1 & Serializable)timer -> NewRelicDistributionMetrics$.MODULE$.apply(periodStartTime, periodEndTime, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)timer, "timer"));
        scala.collection.immutable.Seq rangeSamplerMetrics = (scala.collection.immutable.Seq)snapshot.rangeSamplers().flatMap((Function1 & Serializable)rangeSampler -> NewRelicDistributionMetrics$.MODULE$.apply(periodStartTime, periodEndTime, (MetricSnapshot<Metric.Settings.ForDistributionInstrument, Distribution>)rangeSampler, "rangeSampler"));
        List metrics = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Seq[]{counters, gauges, histogramMetrics, timerMetrics, rangeSamplerMetrics})).flatten(Predef$.MODULE$.$conforms())).asJava();
        MetricBatch batch = new MetricBatch((Collection)metrics, this.commonAttributes);
        this.sender.sendBatch(batch);
    }

    public void stop() {
    }

    public void reconfigure(Config newConfig) {
        this.reconfigure(Kamon$.MODULE$.environment());
    }

    public void reconfigure(Environment environment) {
        this.commonAttributes = AttributeBuddy$.MODULE$.buildCommonAttributes(environment);
        this.sender = (MetricBatchSender)this.senderBuilder.apply();
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new NewRelicMetricsReporter(NewRelicMetricsReporter$.MODULE$.$lessinit$greater$default$1());
        }
    }
}

