/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.spans;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.spans.Span;
import java.io.Serializable;
import java.time.Instant;
import kamon.newrelic.AttributeBuddy$;
import kamon.newrelic.spans.NewRelicSpanConverter;
import kamon.newrelic.spans.NewRelicSpanConverter$Endpoint$;
import kamon.newrelic.spans.NewRelicSpanConverter$PeerKeys$;
import kamon.tag.Lookups$;
import kamon.tag.TagSet;
import kamon.trace.Span;
import kamon.util.Clock$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Long$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NewRelicSpanConverter$
implements Serializable {
    private static final NewRelicSpanConverter$PeerKeys$ PeerKeys;
    public static final NewRelicSpanConverter$Endpoint$ Endpoint;
    public static final NewRelicSpanConverter$ MODULE$;

    private NewRelicSpanConverter$() {
    }

    static {
        MODULE$ = new NewRelicSpanConverter$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NewRelicSpanConverter$.class);
    }

    public Span convertSpan(Span.Finished kamonSpan) {
        long durationMs = Math.floorDiv(Clock$.MODULE$.nanosBetween(kamonSpan.from(), kamonSpan.to()), 1000000L);
        String parentId = kamonSpan.parentId().isEmpty() ? null : kamonSpan.parentId().string();
        Span.SpanBuilder builder = Span.builder((String)kamonSpan.id().string()).traceId(kamonSpan.trace().id().string()).parentId(parentId).name(kamonSpan.operationName()).timestamp(Clock$.MODULE$.toEpochMicros(kamonSpan.from()) / 1000L).durationMs(Long$.MODULE$.long2double(durationMs)).attributes(this.buildAttributes(kamonSpan));
        if (kamonSpan.hasError()) {
            builder.withError();
        }
        return builder.build();
    }

    private Attributes buildAttributes(Span.Finished kamonSpan) {
        NewRelicSpanConverter.Endpoint remoteEndpoint;
        Attributes attributes = new Attributes().put("span.kind", kamonSpan.kind().toString());
        Span.Kind kind = kamonSpan.kind();
        Span.Kind$.Client$ client$ = Span.Kind$.Client$.MODULE$;
        if (!(kind != null ? !kind.equals(client$) : client$ != null) && this.hasAnyData(remoteEndpoint = NewRelicSpanConverter$Endpoint$.MODULE$.apply(this.getStringTag(kamonSpan, NewRelicSpanConverter$PeerKeys$.MODULE$.IPv4()), this.getStringTag(kamonSpan, NewRelicSpanConverter$PeerKeys$.MODULE$.IPv6()), Predef$.MODULE$.int2Integer((int)this.getLongTag(kamonSpan, NewRelicSpanConverter$PeerKeys$.MODULE$.Port()))))) {
            attributes.put("remoteEndpoint", remoteEndpoint.toString());
        }
        kamonSpan.marks().foreach((Function1 & Serializable)x$1 -> {
            Span.Mark mark = x$1;
            if (mark == null) {
                throw new MatchError((Object)mark);
            }
            Span.Mark mark2 = Span.Mark$.MODULE$.unapply(mark);
            Instant instant = mark2._1();
            String string = mark2._2();
            Instant instant2 = instant;
            String key = string;
            return attributes.put(key, (Number)Predef$.MODULE$.long2Long(Clock$.MODULE$.toEpochMicros(instant2) / 1000L));
        });
        return AttributeBuddy$.MODULE$.addTagsFromTagSets((Seq<TagSet>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TagSet[]{kamonSpan.tags(), kamonSpan.metricTags()}))), attributes);
    }

    private String getStringTag(Span.Finished span, String tagName) {
        return (String)((Option)span.tags().get(Lookups$.MODULE$.option(tagName))).orElse(() -> this.getStringTag$$anonfun$1(span, tagName)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private long getLongTag(Span.Finished span, String tagName) {
        return BoxesRunTime.unboxToLong((Object)((Option)span.tags().get(Lookups$.MODULE$.longOption(tagName))).orElse(() -> this.getLongTag$$anonfun$1(span, tagName)).getOrElse(this::getLongTag$$anonfun$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasAnyData(NewRelicSpanConverter.Endpoint endpoint) {
        if (endpoint.ipv4() != null) return true;
        if (endpoint.ipv6() != null) return true;
        Integer n = endpoint.port();
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        if (n == null) {
            if (n2 == null) return false;
            return true;
        } else if (((Object)n).equals(n2)) return false;
        return true;
    }

    private final Option getStringTag$$anonfun$1(Span.Finished span$1, String tagName$1) {
        return (Option)span$1.metricTags().get(Lookups$.MODULE$.option(tagName$1));
    }

    private final Option getLongTag$$anonfun$1(Span.Finished span$2, String tagName$2) {
        return (Option)span$2.metricTags().get(Lookups$.MODULE$.longOption(tagName$2));
    }

    private final long getLongTag$$anonfun$2() {
        return 0L;
    }
}

