/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.spans;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.SpanBatchSender;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kamon.Kamon$;
import kamon.module.Module;
import kamon.module.ModuleFactory;
import kamon.module.SpanReporter;
import kamon.newrelic.AttributeBuddy$;
import kamon.newrelic.spans.NewRelicSpanConverter$;
import kamon.newrelic.spans.NewRelicSpanReporter$;
import kamon.newrelic.spans.SpanBatchSenderBuilder;
import kamon.status.Environment;
import kamon.trace.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public class NewRelicSpanReporter
implements SpanReporter {
    private final SpanBatchSenderBuilder spanBatchSenderBuilder;
    private final Logger logger;
    private volatile SpanBatchSender spanBatchSender;
    private volatile Attributes commonAttributes;

    public static SpanBatchSenderBuilder $lessinit$greater$default$1() {
        return NewRelicSpanReporter$.MODULE$.$lessinit$greater$default$1();
    }

    public NewRelicSpanReporter(SpanBatchSenderBuilder spanBatchSenderBuilder) {
        this.spanBatchSenderBuilder = spanBatchSenderBuilder;
        this.logger = LoggerFactory.getLogger(NewRelicSpanReporter.class);
        this.spanBatchSender = spanBatchSenderBuilder.build(Kamon$.MODULE$.config());
        this.commonAttributes = AttributeBuddy$.MODULE$.buildCommonAttributes(Kamon$.MODULE$.environment());
        this.checkJoinParameter();
        this.logger.info("Started the New Relic Span reporter");
    }

    public void checkJoinParameter() {
        boolean joinRemoteParentsWithSameID = Kamon$.MODULE$.config().getBoolean("kamon.trace.join-remote-parents-with-same-span-id");
        if (!joinRemoteParentsWithSameID) {
            this.logger.warn("For full distributed trace compatibility enable `kamon.trace.join-remote-parents-with-same-span-id` to preserve span id across client/server sides of a Span.");
        }
    }

    public void reportSpans(scala.collection.immutable.Seq<Span.Finished> spans) {
        this.logger.debug("NewRelicSpanReporter reportSpans...");
        List newRelicSpans = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)spans.map((Function1 & Serializable)kamonSpan -> NewRelicSpanConverter$.MODULE$.convertSpan((Span.Finished)kamonSpan))).asJava();
        this.spanBatchSender.sendBatch(new SpanBatch((Collection)newRelicSpans, this.commonAttributes));
    }

    public void reconfigure(Config newConfig) {
        this.reconfigure(newConfig, Kamon$.MODULE$.environment());
    }

    public void reconfigure(Config newConfig, Environment environment) {
        this.logger.debug("NewRelicSpanReporter reconfigure...");
        this.spanBatchSender = this.spanBatchSenderBuilder.build(newConfig);
        this.commonAttributes = AttributeBuddy$.MODULE$.buildCommonAttributes(environment);
        this.checkJoinParameter();
    }

    public void stop() {
        this.logger.info("Stopped the New Relic Span reporter");
    }

    public static class Factory
    implements ModuleFactory {
        public Module create(ModuleFactory.Settings settings) {
            return new NewRelicSpanReporter(NewRelicSpanReporter$.MODULE$.$lessinit$greater$default$1());
        }
    }
}

