/*
 * Decompiled with CFR 0.152.
 */
package kamon.newrelic.spans;

import com.newrelic.telemetry.OkHttpPoster;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.spans.SpanBatchSender;
import com.typesafe.config.Config;
import java.net.URL;
import java.time.Duration;
import kamon.newrelic.LibraryVersion$;
import kamon.newrelic.spans.SpanBatchSenderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSpanBatchSenderBuilder
implements SpanBatchSenderBuilder {
    private final Logger logger = LoggerFactory.getLogger(SpanBatchSenderBuilder.class);

    @Override
    public SpanBatchSender build(Config config) {
        this.logger.warn("NewRelicSpanReporter buildReporter...");
        SenderConfiguration senderConfig = this.buildConfig(config);
        return SpanBatchSender.create((SenderConfiguration)senderConfig);
    }

    public SenderConfiguration buildConfig(Config config) {
        Config nrConfig = config.getConfig("kamon.newrelic");
        String nrInsightsInsertKey = nrConfig.getString("nr-insights-insert-key");
        if (nrInsightsInsertKey.equals("none")) {
            this.logger.error("No Insights Insert API Key defined for the kamon.newrelic.nr-insights-insert-key config setting. No spans will be sent to New Relic.");
        }
        boolean enableAuditLogging = nrConfig.getBoolean("enable-audit-logging");
        String userAgent = "newrelic-kamon-reporter/" + LibraryVersion$.MODULE$.version();
        Duration callTimeout = Duration.ofSeconds(5L);
        SenderConfiguration.SenderConfigurationBuilder senderConfig = SpanBatchSender.configurationBuilder().apiKey(nrInsightsInsertKey).httpPoster((HttpPoster)new OkHttpPoster(callTimeout)).secondaryUserAgent(userAgent).auditLoggingEnabled(enableAuditLogging);
        if (nrConfig.hasPath("span-ingest-uri")) {
            String uriOverride = nrConfig.getString("span-ingest-uri");
            senderConfig.endpoint(new URL(uriOverride));
        }
        return senderConfig.build();
    }
}

